/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitOptions;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitSettings;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitTableModel;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.TableSorter;
import org.openide.util.NbBundle;

class CommitTable
implements AncestorListener,
TableModelListener {
    private CommitTableModel tableModel = new CommitTableModel();
    private JTable table;
    private JComponent component;
    private TableSorter sorter;
    private String[] columns;

    public CommitTable(JLabel jLabel) {
        this.tableModel.addTableModelListener(this);
        this.sorter = new TableSorter((TableModel)this.tableModel);
        this.table = new JTable((TableModel)this.sorter);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDefaultRenderer(String.class, new CommitStringsCellRenderer());
        this.table.setDefaultEditor(CommitOptions.class, new CommitOptionsCellEditor());
        this.table.getTableHeader().setReorderingAllowed(true);
        this.sorter.setTableHeader(this.table.getTableHeader());
        int n = new JLabel((String)"FONTSIZE").getPreferredSize().height * 6 / 5;
        this.table.setRowHeight(n);
        this.table.addAncestorListener(this);
        this.component = new JScrollPane(this.table, 22, 31);
        jLabel.setLabelFor(this.table);
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitTable.class, (String)"ACSD_CommitTable"));
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.setDefaultColumnSizes();
    }

    private void setDefaultColumnSizes() {
        block12: {
            TableColumnModel tableColumnModel;
            int n;
            block11: {
                n = this.table.getWidth();
                tableColumnModel = this.table.getColumnModel();
                if (this.columns == null || tableColumnModel == null) {
                    return;
                }
                if (tableColumnModel.getColumnCount() != this.columns.length) {
                    return;
                }
                if (this.columns.length != 4) break block11;
                for (int i = 0; i < this.columns.length; ++i) {
                    String string = this.columns[i];
                    this.sorter.setColumnComparator(i, null);
                    this.sorter.setSortingStatus(i, 0);
                    if (string.equals("name")) {
                        this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                        tableColumnModel.getColumn(i).setPreferredWidth(n * 30 / 100);
                        continue;
                    }
                    if (string.equals("status")) {
                        this.sorter.setColumnComparator(i, (Comparator)new StatusComparator());
                        this.sorter.setSortingStatus(i, 1);
                        tableColumnModel.getColumn(i).setPreferredWidth(n * 15 / 100);
                        continue;
                    }
                    if (string.equals("action")) {
                        tableColumnModel.getColumn(i).setPreferredWidth(n * 15 / 100);
                        continue;
                    }
                    tableColumnModel.getColumn(i).setPreferredWidth(n * 40 / 100);
                }
                break block12;
            }
            if (this.columns.length != 5) break block12;
            for (int i = 0; i < this.columns.length; ++i) {
                String string = this.columns[i];
                this.sorter.setColumnComparator(i, null);
                this.sorter.setSortingStatus(i, 0);
                if (string.equals("name")) {
                    this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                    tableColumnModel.getColumn(i).setPreferredWidth(n * 25 / 100);
                    continue;
                }
                if (string.equals("sticky")) {
                    tableColumnModel.getColumn(i).setPreferredWidth(n * 15 / 100);
                    continue;
                }
                if (string.equals("status")) {
                    this.sorter.setColumnComparator(i, (Comparator)new StatusComparator());
                    this.sorter.setSortingStatus(i, 1);
                    tableColumnModel.getColumn(i).setPreferredWidth(n * 15 / 100);
                    continue;
                }
                if (string.equals("action")) {
                    tableColumnModel.getColumn(i).setPreferredWidth(n * 15 / 100);
                    continue;
                }
                tableColumnModel.getColumn(i).setPreferredWidth(n * 30 / 100);
            }
        }
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    void setColumns(String[] stringArray) {
        if (Arrays.equals(this.columns, stringArray)) {
            return;
        }
        this.columns = stringArray;
        this.tableModel.setColumns(stringArray);
        this.setDefaultColumnSizes();
    }

    void setNodes(CvsFileNode[] cvsFileNodeArray) {
        this.tableModel.setNodes(cvsFileNodeArray);
    }

    public CommitSettings.CommitFile[] getCommitFiles() {
        return this.tableModel.getCommitFiles();
    }

    public JComponent getComponent() {
        return this.component;
    }

    void dataChanged() {
        int n = this.table.getSelectedRow();
        this.tableModel.fireTableDataChanged();
        if (n != -1) {
            this.table.getSelectionModel().addSelectionInterval(n, n);
        }
    }

    TableModel getTableModel() {
        return this.tableModel;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.table.repaint();
    }

    private class CommitOptionsCellEditor
    extends DefaultCellEditor {
        private final Object[] addOptions;
        private final Object[] commitOptions;
        private final Object[] removeOptions;

        public CommitOptionsCellEditor() {
            super(new JComboBox());
            this.addOptions = new Object[]{CommitOptions.ADD_TEXT, CommitOptions.ADD_BINARY, CommitOptions.EXCLUDE};
            this.commitOptions = new Object[]{CommitOptions.COMMIT, CommitOptions.EXCLUDE};
            this.removeOptions = new Object[]{CommitOptions.COMMIT_REMOVE, CommitOptions.EXCLUDE};
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            int n3 = CommitTable.this.tableModel.getCommitFile(CommitTable.this.sorter.modelIndex(n)).getNode().getInformation().getStatus();
            JComboBox jComboBox = (JComboBox)this.editorComponent;
            if (n3 == 2048 || n3 == 256) {
                jComboBox.setModel(new DefaultComboBoxModel<Object>(this.removeOptions));
            } else if ((n3 & 0xFF8) == 0) {
                jComboBox.setModel(new DefaultComboBoxModel<Object>(this.addOptions));
            } else {
                jComboBox.setModel(new DefaultComboBoxModel<Object>(this.commitOptions));
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    private static class CommitStringsCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private CommitStringsCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = jTable.convertColumnIndexToModel(n2);
            if (n3 == 0) {
                TableSorter tableSorter = (TableSorter)jTable.getModel();
                CommitTableModel commitTableModel = (CommitTableModel)tableSorter.getTableModel();
                CommitSettings.CommitFile commitFile = commitTableModel.getCommitFile(tableSorter.modelIndex(n));
                if (!bl) {
                    object = "<html>" + CvsVersioningSystem.getInstance().getAnnotator().annotateNameHtml(commitFile.getNode().getFile().getName(), commitFile.getNode().getInformation(), null);
                }
                if (commitFile.getOptions() == CommitOptions.EXCLUDE) {
                    object = "<html><s>" + object + "</s></html>";
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            if (n3 == 3) {
                return this.pathRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private class FileNameComparator
    implements Comparator {
        private FileNameComparator() {
        }

        public int compare(Object object, Object object2) {
            Integer n = (Integer)object;
            Integer n2 = (Integer)object2;
            return CommitTable.this.tableModel.getCommitFile(n).getNode().getName().compareToIgnoreCase(CommitTable.this.tableModel.getCommitFile(n2).getNode().getName());
        }
    }

    private class StatusComparator
    extends Utils.ByImportanceComparator {
        private StatusComparator() {
        }

        public int compare(Object object, Object object2) {
            Integer n = (Integer)object;
            Integer n2 = (Integer)object2;
            return super.compare(CommitTable.this.tableModel.getCommitFile(n).getNode().getInformation(), CommitTable.this.tableModel.getCommitFile(n2).getNode().getInformation());
        }
    }
}

