/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Set;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.diff.EncodedReaderFactory;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class DiffStreamSource
extends StreamSource {
    private final File baseFile;
    private final String revision;
    private final String title;
    private String mimeType = "text/plain";
    private File remoteFile;
    private boolean binary;
    private ExecutorGroup group;
    private boolean initialized;

    public DiffStreamSource(File file, String string, String string2) {
        this.baseFile = file;
        this.revision = string;
        this.title = string2;
    }

    public String getName() {
        return this.baseFile.getName();
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized void setGroup(ExecutorGroup executorGroup) {
        this.group = executorGroup;
    }

    public synchronized String getMIMEType() {
        try {
            this.init(null);
        }
        catch (IOException iOException) {
            return null;
        }
        return this.mimeType;
    }

    public synchronized Reader createReader() throws IOException {
        this.init(this.group);
        if (this.revision == null || this.remoteFile == null) {
            return null;
        }
        if (this.binary) {
            return new StringReader(NbBundle.getMessage(DiffStreamSource.class, (String)"BK5001", (Object)this.getTitle()));
        }
        FileObject fileObject = FileUtil.toFileObject((File)this.remoteFile);
        return EncodedReaderFactory.getDefault().getReader(fileObject, null);
    }

    public Writer createWriter(Difference[] differenceArray) throws IOException {
        throw new IOException("Operation not supported");
    }

    public boolean isEditable() {
        return "".equals(this.revision) && this.isPrimary();
    }

    private boolean isPrimary() {
        FileObject fileObject = FileUtil.toFileObject((File)this.baseFile);
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                return fileObject.equals(dataObject.getPrimaryFile());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized Lookup getLookup() {
        try {
            this.init(null);
        }
        catch (IOException iOException) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        if (this.remoteFile == null || !this.isPrimary()) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        FileObject fileObject = FileUtil.toFileObject((File)this.remoteFile);
        if (fileObject == null) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        return Lookups.fixed((Object[])new Object[]{fileObject});
    }

    synchronized void init(ExecutorGroup executorGroup) throws IOException {
        File file;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.revision == null) {
            return;
        }
        this.binary = !CvsVersioningSystem.getInstance().isText(this.baseFile);
        try {
            if (this.isEditable()) {
                this.remoteFile = VersionsCache.getInstance().getRemoteFile(this.baseFile, this.revision, executorGroup);
            } else {
                file = Utils.getTempFolder();
                Set set = Utils.getAllDataObjectFiles((File)this.baseFile);
                for (File file2 : set) {
                    boolean bl = file2.equals(this.baseFile);
                    try {
                        File file3 = VersionsCache.getInstance().getRemoteFile(file2, this.revision, executorGroup);
                        File file4 = new File(file, file2.getName());
                        Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(file4), (InputStream)new FileInputStream(file3));
                        file4.deleteOnExit();
                        if (!bl) continue;
                        this.remoteFile = file4;
                    }
                    catch (Exception exception) {
                        if (!bl) continue;
                        throw exception;
                    }
                }
            }
            if (!this.baseFile.exists() && this.remoteFile != null && this.remoteFile.exists()) {
                this.binary = !CvsVersioningSystem.getInstance().isText(this.remoteFile);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Cannot initialize stream source");
            iOException.initCause(exception);
            throw iOException;
        }
        file = FileUtil.toFileObject((File)this.baseFile);
        if (file == null && this.remoteFile != null) {
            file = FileUtil.toFileObject((File)this.remoteFile);
        }
        this.mimeType = file != null ? file.getMIMEType() : (this.binary ? "application/octet-stream" : "text/plain");
    }
}

