/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.io.File;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ResolveConflictsAction
extends AbstractSystemAction {
    public ResolveConflictsAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_ResolveConflicts";
    }

    protected boolean enable(Node[] nodeArray) {
        return CvsVersioningSystem.getInstance().getFileTableModel(Utils.getCurrentContext(nodeArray), 64).getNodes().length > 0;
    }

    public void performCvsAction(Node[] nodeArray) {
        CvsFileNode[] cvsFileNodeArray = CvsVersioningSystem.getInstance().getFileTableModel(this.getContext(nodeArray), 64).getNodes();
        if (cvsFileNodeArray.length == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_NoConflicts")));
            return;
        }
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        for (int i = 0; i < cvsFileNodeArray.length; ++i) {
            File file = cvsFileNodeArray[i].getFile();
            FileInformation fileInformation = fileStatusCache.getStatus(file);
            Entry entry = fileInformation.getEntry(file);
            if (entry == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_MoveAwayLocalFileConflict", (Object)file.getName())));
                continue;
            }
            ResolveConflictsExecutor resolveConflictsExecutor = new ResolveConflictsExecutor();
            resolveConflictsExecutor.exec(file);
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

