/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.status;

import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.CvsSynchronizeTopComponent;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class StatusProjectsAction
extends SystemAction {
    public StatusProjectsAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(StatusProjectsAction.class, (String)"CTL_MenuItem_StatusProjects_Label");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(StatusProjectsAction.class);
    }

    public boolean isEnabled() {
        if (super.isEnabled()) {
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            for (int i = 0; i < projectArray.length; ++i) {
                Project project = projectArray[i];
                if (!Utils.isVersionedProject(project)) continue;
                return true;
            }
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                StatusProjectsAction.this.async();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void async() {
        try {
            String string;
            this.setEnabled(false);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CvsSynchronizeTopComponent cvsSynchronizeTopComponent = CvsSynchronizeTopComponent.getInstance();
                    cvsSynchronizeTopComponent.setContext(null);
                    cvsSynchronizeTopComponent.open();
                }
            });
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            final Context context = Utils.getProjectsContext(projectArray);
            if (projectArray.length == 1) {
                Project project = projectArray[0];
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                string = projectInformation.getDisplayName();
            } else {
                string = NbBundle.getMessage(StatusProjectsAction.class, (String)"CTL_StatusProjects_WindowTitle", (Object)Integer.toString(projectArray.length));
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CvsSynchronizeTopComponent cvsSynchronizeTopComponent = CvsSynchronizeTopComponent.getInstance();
                    cvsSynchronizeTopComponent.setContentTitle(string);
                    cvsSynchronizeTopComponent.setContext(context);
                    cvsSynchronizeTopComponent.open();
                    cvsSynchronizeTopComponent.requestActive();
                    if (StatusProjectsAction.this.shouldPostRefresh()) {
                        cvsSynchronizeTopComponent.performRefreshAction();
                    }
                }
            });
        }
        finally {
            this.setEnabled(true);
        }
    }

    protected boolean shouldPostRefresh() {
        return true;
    }
}

