/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.tag.TagCommand;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.Mnemonics;

public class TagSettings
extends JPanel
implements DocumentListener {
    private final File[] roots;
    private JCheckBox cbCheckModified;
    private JCheckBox cbDeleteTag;
    private JCheckBox cbMoveTag;
    private JButton jButton1;
    private JLabel nameLabel;
    private JTextField tfName;

    public TagSettings(File[] fileArray) {
        this.roots = fileArray;
        this.initComponents();
        this.tfName.getDocument().addDocumentListener(this);
    }

    void refreshComponents() {
        this.cbMoveTag.setEnabled(!this.cbDeleteTag.isSelected());
        this.cbDeleteTag.setEnabled(!this.cbMoveTag.isSelected());
        this.cbCheckModified.setEnabled(!this.cbDeleteTag.isSelected());
        JButton jButton = (JButton)this.getClientProperty("OKButton");
        if (jButton != null) {
            jButton.setEnabled(Utils.isTagValid(this.tfName.getText()));
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.refreshComponents();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.refreshComponents();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.refreshComponents();
    }

    public void setCommand(TagCommand tagCommand) {
        this.cbMoveTag.setSelected(tagCommand.isOverrideExistingTag());
        this.cbCheckModified.setSelected(tagCommand.isCheckThatUnmodified());
        this.cbDeleteTag.setSelected(tagCommand.isDeleteTag());
        this.tfName.setText(tagCommand.getTag());
    }

    public void updateCommand(TagCommand tagCommand) {
        tagCommand.setOverrideExistingTag(this.cbMoveTag.isSelected());
        tagCommand.setCheckThatUnmodified(this.cbCheckModified.isSelected());
        tagCommand.setDeleteTag(this.cbDeleteTag.isSelected());
        tagCommand.setTag(this.tfName.getText());
    }

    private void initComponents() {
        this.cbCheckModified = new JCheckBox();
        this.cbMoveTag = new JCheckBox();
        this.nameLabel = new JLabel();
        this.tfName = new JTextField();
        this.jButton1 = new JButton();
        this.cbDeleteTag = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.cbCheckModified, (String)resourceBundle.getString("CTL_TagForm_EnsureUptodate"));
        this.cbCheckModified.setToolTipText(resourceBundle.getString("TT_TagForm_EnsureUptodate"));
        this.cbCheckModified.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagSettings.this.cbCheckModifiedActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbMoveTag, (String)resourceBundle.getString("CTL_TagForm_MoveExisting"));
        this.cbMoveTag.setToolTipText(resourceBundle.getString("TT_TagForm_MoveExisting"));
        this.cbMoveTag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagSettings.this.cbMoveTagActionPerformed(actionEvent);
            }
        });
        this.nameLabel.setLabelFor(this.tfName);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)resourceBundle.getString("CTL_TagForm_TagName"));
        this.tfName.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)resourceBundle.getString("CTL_BrowseTag"));
        this.jButton1.setToolTipText(resourceBundle.getString("TT_BrowseTag"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagSettings.this.onBrowseTag(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbDeleteTag, (String)resourceBundle.getString("CTL_TagForm_DeleteExisting"));
        this.cbDeleteTag.setToolTipText(resourceBundle.getString("TT_TagForm_DeleteExisting"));
        this.cbDeleteTag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagSettings.this.cbDeleteTagActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cbMoveTag, -1, 195, Short.MAX_VALUE).add(159, 159, 159)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.nameLabel).addPreferredGap(0).add((Component)this.tfName, -1, 212, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton1)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cbCheckModified, -1, -1, Short.MAX_VALUE).add(159, 159, 159)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cbDeleteTag, -1, 195, Short.MAX_VALUE).add(159, 159, 159)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.jButton1).add((Component)this.tfName, -2, -1, -2)).addPreferredGap(0).add((Component)this.cbCheckModified, -2, 23, -2).addPreferredGap(0).add((Component)this.cbMoveTag).addPreferredGap(0).add((Component)this.cbDeleteTag)));
    }

    private void cbDeleteTagActionPerformed(ActionEvent actionEvent) {
        this.refreshComponents();
    }

    private void cbMoveTagActionPerformed(ActionEvent actionEvent) {
        this.refreshComponents();
    }

    private void onBrowseTag(ActionEvent actionEvent) {
        for (int i = 0; i < this.roots.length; ++i) {
            try {
                CVSRoot.parse((String)Utils.getCVSRootFor(this.roots[i]));
                BranchSelector branchSelector = new BranchSelector();
                String string = branchSelector.selectTag(this.roots[i]);
                if (string != null) {
                    this.tfName.setText(string);
                }
                return;
            }
            catch (IOException iOException) {
                continue;
            }
        }
    }

    private void cbCheckModifiedActionPerformed(ActionEvent actionEvent) {
    }
}

