/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.Mnemonics;

class SearchCriteriaPanel
extends JPanel {
    private final File[] roots;
    private JButton bBrowseFrom;
    private JButton bBrowseTo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTextField tfCommitMessage;
    private JTextField tfFrom;
    private JTextField tfTo;
    private JTextField tfUsername;

    public SearchCriteriaPanel(File[] fileArray) {
        this.roots = fileArray;
        this.initComponents();
    }

    public String getFrom() {
        String string = this.tfFrom.getText().trim();
        return string.length() > 0 ? string : null;
    }

    public String getTo() {
        String string = this.tfTo.getText().trim();
        return string.length() > 0 ? string : null;
    }

    public String getCommitMessage() {
        String string = this.tfCommitMessage.getText().trim();
        return string.length() > 0 ? string : null;
    }

    public String getUsername() {
        String string = this.tfUsername.getText().trim();
        return string.length() > 0 ? string : null;
    }

    public void setFrom(String string) {
        if (string == null) {
            string = "";
        }
        this.tfFrom.setText(string);
    }

    public void setTo(String string) {
        if (string == null) {
            string = "";
        }
        this.tfTo.setText(string);
    }

    public void setCommitMessage(String string) {
        if (string == null) {
            string = "";
        }
        this.tfCommitMessage.setText(string);
    }

    public void setUsername(String string) {
        if (string == null) {
            string = "";
        }
        this.tfUsername.setText(string);
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchCriteriaPanel.this.tfCommitMessage.requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.tfCommitMessage = new JTextField();
        this.jLabel2 = new JLabel();
        this.tfUsername = new JTextField();
        this.jLabel3 = new JLabel();
        this.tfFrom = new JTextField();
        this.jLabel5 = new JLabel();
        this.bBrowseFrom = new JButton();
        this.jLabel4 = new JLabel();
        this.tfTo = new JTextField();
        this.jLabel6 = new JLabel();
        this.bBrowseTo = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 12, 0, 11));
        this.jLabel1.setLabelFor(this.tfCommitMessage);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_UseCommitMessage"));
        this.jLabel1.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_CommitMessage"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.tfCommitMessage.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.tfCommitMessage, gridBagConstraints);
        this.jLabel2.setLabelFor(this.tfUsername);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_UseUsername"));
        this.jLabel2.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_Username"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.tfUsername.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.tfUsername, gridBagConstraints);
        this.jLabel3.setLabelFor(this.tfFrom);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_UseFrom"));
        this.jLabel3.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_From"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.tfFrom.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.tfFrom, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_FromToHint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        this.add((Component)this.jLabel5, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseFrom, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_BrowseFrom"));
        this.bBrowseFrom.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_BrowseFrom"));
        this.bBrowseFrom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchCriteriaPanel.this.onFromBrowse(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.bBrowseFrom, gridBagConstraints);
        this.jLabel4.setLabelFor(this.tfTo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_UseTo"));
        this.jLabel4.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_To"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.tfTo.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.tfTo, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_FromToHint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 0, 4);
        this.add((Component)this.jLabel6, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseTo, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_BrowseTo"));
        this.bBrowseTo.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_BrowseTo"));
        this.bBrowseTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchCriteriaPanel.this.onToBrowse(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.bBrowseTo, gridBagConstraints);
    }

    private void onToBrowse(ActionEvent actionEvent) {
        this.onBrowse(this.tfTo);
    }

    private void onFromBrowse(ActionEvent actionEvent) {
        this.onBrowse(this.tfFrom);
    }

    private void onBrowse(JTextField jTextField) {
        for (int i = 0; i < this.roots.length; ++i) {
            try {
                CVSRoot.parse((String)Utils.getCVSRootFor(this.roots[i]));
                BranchSelector branchSelector = new BranchSelector();
                String string = branchSelector.selectTag(this.roots[i]);
                if (string != null) {
                    jTextField.setText(string);
                }
                return;
            }
            catch (IOException iOException) {
                continue;
            }
        }
    }
}

