/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

class TooltipWindow
extends JWindow
implements AWTEventListener {
    private static final int SCREEN_BORDER = 20;
    private final JComponent content;

    public TooltipWindow(Window window, JComponent jComponent) {
        super(window);
        this.content = jComponent;
    }

    public void show(Point point) {
        this.add(this.content);
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (point.y + dimension.height + 20 > dimension2.height) {
            dimension.height = dimension2.height - (point.y + 20);
        }
        if (point.x + dimension.width + 20 > dimension2.width) {
            dimension.width = dimension2.width - (point.x + 20);
        }
        this.setSize(dimension);
        this.setLocation(point.x, point.y - 1);
        this.setVisible(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 501) {
            this.onClick(aWTEvent);
        } else if (aWTEvent.getID() == 401 && ((KeyEvent)aWTEvent).getKeyCode() == 27) {
            this.shutdown();
        }
    }

    private void onClick(AWTEvent aWTEvent) {
        Component component = (Component)aWTEvent.getSource();
        Window window = SwingUtilities.windowForComponent(component);
        if (window != this) {
            this.shutdown();
        }
    }

    void shutdown() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.dispose();
    }
}

