/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.system.cvss.ui.history.ViewRevisionPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ViewRevisionAction
extends AbstractAction
implements Runnable {
    private final VCSContext ctx;
    private ViewRevisionPanel settings;

    public ViewRevisionAction(VCSContext vCSContext) {
        this(Utils.getActionName(ViewRevisionAction.class, (String)"CTL_MenuItem_ViewRevision", (VCSContext)vCSContext), vCSContext);
    }

    public ViewRevisionAction(String string, VCSContext vCSContext) {
        super(string);
        this.ctx = vCSContext;
    }

    public boolean isEnabled() {
        return this.ctx.getRootFiles().size() > 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = NbBundle.getMessage(ViewRevisionAction.class, (String)"CTL_ViewRevisionDialog_Title", (Object)Utils.getContextDisplayName((VCSContext)this.ctx));
        this.settings = new ViewRevisionPanel(this.ctx);
        JButton jButton = new JButton(NbBundle.getMessage(ViewRevisionAction.class, (String)"CTL_ViewRevisionDialog_Action_View"));
        this.settings.putClientProperty("OKButton", jButton);
        this.settings.refreshComponents();
        jButton.setToolTipText(NbBundle.getMessage(ViewRevisionAction.class, (String)"TT_ViewRevisionDialog_Action_View"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.settings, string, true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, new HelpCtx(ViewRevisionAction.class), null);
        dialogDescriptor.setClosingOptions(null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ViewRevisionAction.class, (String)"ACSD_ViewRevisionDialog"));
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != jButton) {
            return;
        }
        this.settings.saveSettings();
        Utils.createTask((Runnable)this).schedule(0);
    }

    public void run() {
        final String string = this.settings.getRevision();
        File file = Utils.getTempFolder();
        file.deleteOnExit();
        for (File file2 : this.ctx.getRootFiles()) {
            if (file2.isDirectory()) continue;
            try {
                File file3 = VersionsCache.getInstance().getRemoteFile(file2, string, null);
                File file4 = new File(file, file2.getName());
                Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(file4), (InputStream)new FileInputStream(file3));
                file4.deleteOnExit();
                final FileObject fileObject = FileUtil.toFileObject((File)file4);
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                    if (editorCookie == null) continue;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Utils.openFile((FileObject)fileObject, (String)string);
                        }
                    });
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                }
            }
            catch (Exception exception) {}
        }
    }
}

