/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.syncview;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.SynchronizePanel;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CvsSynchronizeTopComponent
extends TopComponent
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private SynchronizePanel syncPanel;
    private Context context;
    private String contentTitle;
    private String branchTitle;
    private long lastUpdateTimestamp;
    private static CvsSynchronizeTopComponent instance;

    public CvsSynchronizeTopComponent() {
        this.setName(NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_Title"));
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/versioning-view.png", (boolean)true));
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"ACSD_Synchronize_TopComponent"));
        this.syncPanel = new SynchronizePanel(this);
        this.add(this.syncPanel);
        this.setFocusable(true);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    protected void componentActivated() {
        this.updateTitle();
        this.syncPanel.focus();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.context);
        objectOutput.writeObject(this.contentTitle);
        objectOutput.writeLong(this.lastUpdateTimestamp);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.context = (Context)objectInput.readObject();
        this.contentTitle = (String)objectInput.readObject();
        this.lastUpdateTimestamp = objectInput.readLong();
        this.syncPanel.deserialize();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.refreshContent();
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    private void refreshContent() {
        if (this.syncPanel == null) {
            return;
        }
        this.updateTitle();
        this.syncPanel.setContext(this.context);
    }

    public void setContentTitle(String string) {
        this.contentTitle = string;
        this.updateTitle();
    }

    void setBranchTitle(String string) {
        this.branchTitle = string;
        this.updateTitle();
    }

    public void contentRefreshed() {
        this.lastUpdateTimestamp = System.currentTimeMillis();
        this.updateTitle();
    }

    private void updateTitle() {
        String string = this.computeAge(System.currentTimeMillis() - this.lastUpdateTimestamp);
        if (this.contentTitle == null) {
            this.setName(NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_Title"));
        } else if (this.branchTitle == null) {
            this.setName(NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_MultiTitle", (Object)this.contentTitle, (Object)string));
        } else {
            this.setName(NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_Title_ContentBranch", (Object)this.contentTitle, (Object)this.branchTitle, (Object)string));
        }
    }

    String getContentTitle() {
        return this.contentTitle;
    }

    private String computeAge(long l) {
        if (this.lastUpdateTimestamp == 0L) {
            return NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_AgeUnknown");
        }
        if (l < 1000L) {
            return NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_AgeCurrent");
        }
        if (l < 2000L) {
            return NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_AgeOneSecond");
        }
        if (l < 60000L) {
            return NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_AgeSeconds", (Object)Long.toString(l / 1000L));
        }
        if (l < 120000L) {
            return NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_AgeOneMinute");
        }
        if (l < 3600000L) {
            return NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_AgeMinutes", (Object)Long.toString(l / 60000L));
        }
        if (l < 0x6DDD00L) {
            return NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_AgeOneHour");
        }
        if (l < 86400000L) {
            return NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_AgeHours", (Object)Long.toString(l / 3600000L));
        }
        if (l < 172800000L) {
            return NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_AgeOneDay");
        }
        return NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_AgeDays", (Object)Long.toString(l / 86400000L));
    }

    public static synchronized CvsSynchronizeTopComponent getInstance() {
        if (instance == null && (instance = (CvsSynchronizeTopComponent)WindowManager.getDefault().findTopComponent("synchronize")) == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Can not find Versioning component"));
            instance = new CvsSynchronizeTopComponent();
        }
        return instance;
    }

    public Object readResolve() {
        return CvsSynchronizeTopComponent.getInstance();
    }

    public void performRefreshAction() {
        this.syncPanel.performRefreshAction();
    }

    public void setContext(Context context) {
        this.syncPanel.cancelRefresh();
        if (context == null) {
            this.setName(NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"BK1001"));
            this.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setEnabled(true);
            this.setCursor(Cursor.getDefaultCursor());
            this.context = context;
            this.setBranchTitle(null);
            this.refreshContent();
        }
        this.setToolTipText(this.getContextFilesList(context, NbBundle.getMessage(CvsSynchronizeTopComponent.class, (String)"CTL_Synchronize_TopComponent_Title")));
    }

    private String getContextFilesList(Context context, String string) {
        if (context == null || context.getFiles().length == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<html>");
        for (File file : context.getFiles()) {
            stringBuilder.append(file.getAbsolutePath());
            stringBuilder.append("<br>");
        }
        stringBuilder.delete(stringBuilder.length() - 4, Integer.MAX_VALUE);
        return stringBuilder.toString();
    }

    public boolean hasContext() {
        return this.context != null && this.context.getFiles().length > 0;
    }

    protected String preferredID() {
        return "synchronize";
    }

    public int getPersistenceType() {
        return 0;
    }

    public static final class ReadResolver
    implements Serializable {
        public Object readResolve() {
            if (instance == null) {
                instance = new CvsSynchronizeTopComponent();
            }
            return instance;
        }
    }
}

