/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.wizards;

import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;

public abstract class AbstractStep
implements WizardDescriptor.ValidatingPanel {
    private List listeners = new LinkedList();
    private boolean valid;
    private JComponent panel;
    private volatile boolean underConstruction;
    private String errorMessage;
    private boolean applyStandaloneLayout;

    public void applyStandaloneLayout() {
        this.applyStandaloneLayout = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Component getComponent() {
        if (this.panel == null) {
            try {
                this.underConstruction = true;
                this.panel = this.createComponent();
                HelpCtx.setHelpIDString((JComponent)this.panel, (String)this.getClass().getName());
                if (!this.applyStandaloneLayout) {
                    JTextArea jTextArea = new JTextArea();
                    jTextArea.setColumns(60);
                    jTextArea.setRows(25);
                    this.panel.setPreferredSize(jTextArea.getPreferredSize());
                }
            }
            catch (RuntimeException runtimeException) {
                ErrorManager.getDefault().notify((Throwable)runtimeException);
            }
            finally {
                assert (this.panel != null);
                this.underConstruction = false;
                this.fireChange();
            }
        }
        return this.panel;
    }

    protected abstract JComponent createComponent();

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(Object object) {
    }

    public void storeSettings(Object object) {
    }

    protected final void valid() {
        this.setValid(true, null);
    }

    protected final void valid(String string) {
        this.setValid(true, string);
    }

    protected final void invalid(String string) {
        this.setValid(false, string);
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final void validate() throws WizardValidationException {
        this.validateBeforeNext();
        if (!this.isValid() || this.errorMessage != null) {
            throw new WizardValidationException(this.panel, this.errorMessage, this.errorMessage);
        }
    }

    protected abstract void validateBeforeNext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(changeListener);
        }
    }

    private void setValid(boolean bl, String string) {
        boolean bl2 = this.valid != bl;
        boolean bl3 = string != null && !string.equals(this.errorMessage);
        this.valid = bl;
        this.errorMessage = string;
        if (bl2 |= bl3) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList arrayList;
        if (this.underConstruction) {
            return;
        }
        Object object = this.listeners;
        synchronized (object) {
            arrayList = new ArrayList(this.listeners);
        }
        object = arrayList.iterator();
        ChangeEvent changeEvent = new ChangeEvent(this);
        while (object.hasNext()) {
            ChangeListener changeListener = (ChangeListener)object.next();
            changeListener.stateChanged(changeEvent);
        }
    }
}

