/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ModuleSelector;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.AbstractStep;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.ModulePanel;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.RepositoryStep;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class CheckoutWizard
implements ChangeListener {
    private static final String RECENT_DIRECTORY = "checkout.recentDirectory";
    private static final String CHECKOUT_RECENT_MODULE = "checkout.recentModule";
    private static final String CHECKOUT_RECENT_TAG = "checkout.recentTag";
    private WizardDescriptor wizard;
    private String errorMessage;
    private WizardDescriptor.Iterator wizardIterator;
    private ModulePanel modulePanel;
    private RepositoryStep repositoryStep;
    private String initialCvsRoot;
    private String initialModule;

    public CheckoutWizard() {
    }

    public CheckoutWizard(String string, String string2) {
        this.initialCvsRoot = string;
        this.initialModule = string2;
    }

    public boolean show() {
        this.wizardIterator = this.panelIterator();
        this.wizard = new WizardDescriptor(this.wizardIterator);
        this.wizard.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getMessage(CheckoutWizard.class, (String)"BK0006"), NbBundle.getMessage(CheckoutWizard.class, (String)"BK2009")});
        this.wizard.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
        this.wizard.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
        this.wizard.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
        this.wizard.setTitleFormat(new MessageFormat("{0}"));
        this.wizard.setTitle(NbBundle.getMessage(CheckoutWizard.class, (String)"BK0007"));
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)this.wizard);
        boolean bl = NotifyDescriptor.OK_OPTION.equals(object);
        if (bl) {
            this.onFinished();
        }
        return bl;
    }

    private void onFinished() {
        String string = this.modulePanel.workTextField.getText();
        CvsModuleConfig.getDefault().getPreferences().put(CHECKOUT_RECENT_MODULE, this.modulePanel.moduleTextField.getText());
        CvsModuleConfig.getDefault().getPreferences().put(CHECKOUT_RECENT_TAG, this.modulePanel.tagTextField.getText());
        Utils.insert((Preferences)CvsModuleConfig.getDefault().getPreferences(), (String)RECENT_DIRECTORY, (String)string, (int)8);
    }

    String getErrorMessage() {
        String string = this.wizard != null ? (String)this.wizard.getProperty("WizardPanel_errorMessage") : this.errorMessage;
        if (string == null) {
            string = "";
        }
        return string;
    }

    private void setErrorMessage(String string) {
        this.errorMessage = string;
        if (this.wizard != null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        AbstractStep abstractStep = (AbstractStep)this.wizardIterator.current();
        this.setErrorMessage(abstractStep.getErrorMessage());
    }

    private WizardDescriptor.Iterator panelIterator() {
        this.repositoryStep = new RepositoryStep(this.initialCvsRoot);
        this.repositoryStep.addChangeListener(this);
        ModuleStep moduleStep = new ModuleStep();
        moduleStep.addChangeListener(this);
        final WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[]{this.repositoryStep, moduleStep};
        WizardDescriptor.ArrayIterator arrayIterator = new WizardDescriptor.ArrayIterator(panelArray){

            public WizardDescriptor.Panel current() {
                WizardDescriptor.Panel panel = super.current();
                for (int i = 0; i < panelArray.length; ++i) {
                    if (panelArray[i] != panel) continue;
                    CheckoutWizard.this.wizard.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(i));
                }
                return panel;
            }
        };
        return arrayIterator;
    }

    public String getModules() {
        return this.modulePanel.moduleTextField.getText().trim();
    }

    public String getTag() {
        return this.modulePanel.tagTextField.getText().trim();
    }

    public String getWorkingDir() {
        String string = this.modulePanel.workTextField.getText();
        return FileUtil.normalizeFile((File)new File(string)).getAbsolutePath();
    }

    public String getScrambledPassword() {
        return this.repositoryStep.getScrambledPassword();
    }

    public String getCvsRoot() {
        return this.repositoryStep.getCvsRoot();
    }

    private class ModuleStep
    extends AbstractStep
    implements DocumentListener,
    FocusListener,
    ActionListener {
        private ModuleStep() {
        }

        protected JComponent createComponent() {
            CheckoutWizard.this.modulePanel = new ModulePanel();
            if (CheckoutWizard.this.initialModule != null) {
                ((CheckoutWizard)CheckoutWizard.this).modulePanel.moduleTextField.setText(CheckoutWizard.this.initialModule);
            }
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.moduleTextField.setText(CvsModuleConfig.getDefault().getPreferences().get(CheckoutWizard.CHECKOUT_RECENT_MODULE, ""));
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.tagTextField.setText(CvsModuleConfig.getDefault().getPreferences().get(CheckoutWizard.CHECKOUT_RECENT_TAG, ""));
            String string = this.defaultWorkingDirectory().getPath();
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.setText(string);
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.getDocument().addDocumentListener(this);
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.addFocusListener(this);
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.addActionListener(this);
            this.validateUserInput(true);
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.moduleButton.addActionListener(this);
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.tagButton.addActionListener(this);
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.workButton.addActionListener(this);
            return CheckoutWizard.this.modulePanel;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(ModuleStep.class);
        }

        protected void validateBeforeNext() {
            boolean bl;
            String string;
            File file;
            if (this.validateUserInput(true) && !(file = new File(string = ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.getText())).exists() && !(bl = file.mkdirs())) {
                this.invalid(NbBundle.getMessage(CheckoutWizard.class, (String)"BK2013") + file.getPath());
            }
        }

        private boolean validateUserInput(boolean bl) {
            String string = ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.getText();
            if (string == null || string.length() == 0) {
                this.invalid(NbBundle.getMessage(CheckoutWizard.class, (String)"BK2014"));
                return false;
            }
            String string2 = null;
            if (bl) {
                File file = new File(string);
                if (!file.exists()) {
                    for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
                        if (!file2.exists()) continue;
                        if (!file2.canWrite()) {
                            string2 = NbBundle.getMessage(CheckoutWizard.class, (String)"BK2016") + file2.getPath();
                        }
                        break;
                    }
                } else if (file.isFile()) {
                    string2 = NbBundle.getMessage(CheckoutWizard.class, (String)"BK2017");
                }
            }
            if (string2 == null) {
                this.valid();
            } else {
                this.invalid(string2);
            }
            return string2 == null;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.validateUserInput(false);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.validateUserInput(false);
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.validateUserInput(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ((CheckoutWizard)CheckoutWizard.this).modulePanel.moduleButton) {
                ModuleSelector moduleSelector = new ModuleSelector();
                String string = CheckoutWizard.this.repositoryStep.getCvsRoot();
                CVSRoot cVSRoot = CVSRoot.parse((String)string);
                Set set = moduleSelector.selectModules(cVSRoot);
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = "";
                for (String string3 : set) {
                    stringBuffer.append(string2).append(string3);
                    string2 = ",";
                }
                ((CheckoutWizard)CheckoutWizard.this).modulePanel.moduleTextField.setText(stringBuffer.toString());
            } else if (actionEvent.getSource() == ((CheckoutWizard)CheckoutWizard.this).modulePanel.tagButton) {
                String string;
                String string4;
                BranchSelector branchSelector = new BranchSelector();
                String string5 = CheckoutWizard.this.repositoryStep.getCvsRoot();
                CVSRoot cVSRoot = CVSRoot.parse((String)string5);
                String string6 = ((CheckoutWizard)CheckoutWizard.this).modulePanel.moduleTextField.getText();
                if (string6.trim().length() == 0) {
                    string6 = ".";
                }
                if ((string4 = branchSelector.selectTag(cVSRoot, string = new StringTokenizer(string6, ", ").nextToken())) != null) {
                    ((CheckoutWizard)CheckoutWizard.this).modulePanel.tagTextField.setText(string4);
                }
            } else if (actionEvent.getSource() == ((CheckoutWizard)CheckoutWizard.this).modulePanel.workButton) {
                File file = this.defaultWorkingDirectory();
                AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(CheckoutWizard.class, (String)"ACSD_BrowseFolder"), file);
                accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(CheckoutWizard.class, (String)"BK0010"));
                accessibleJFileChooser.setMultiSelectionEnabled(false);
                FileFilter[] fileFilterArray = accessibleJFileChooser.getChoosableFileFilters();
                for (int i = 0; i < fileFilterArray.length; ++i) {
                    FileFilter fileFilter = fileFilterArray[i];
                    accessibleJFileChooser.removeChoosableFileFilter(fileFilter);
                }
                accessibleJFileChooser.addChoosableFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory();
                    }

                    public String getDescription() {
                        return NbBundle.getMessage(CheckoutWizard.class, (String)"BK0008");
                    }
                });
                accessibleJFileChooser.setFileSelectionMode(1);
                accessibleJFileChooser.showDialog(CheckoutWizard.this.modulePanel, NbBundle.getMessage(CheckoutWizard.class, (String)"BK0009"));
                File file2 = accessibleJFileChooser.getSelectedFile();
                if (file2 != null) {
                    ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.setText(file2.getAbsolutePath());
                }
            } else {
                this.validateUserInput(true);
            }
        }

        private File defaultWorkingDirectory() {
            Object object;
            Object object2 = null;
            String string = ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.getText();
            if (string != null && !string.trim().equals("")) {
                for (object = new File(string); object != null && !((File)object).exists(); object = ((File)object).getParentFile()) {
                }
                if (object != null) {
                    object2 = ((File)object).isFile() ? ((File)object).getParentFile() : object;
                }
            }
            if (object2 == null) {
                object = Utils.getStringList((Preferences)CvsModuleConfig.getDefault().getPreferences(), (String)CheckoutWizard.RECENT_DIRECTORY);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    File file = new File(string2);
                    File file2 = file.getParentFile();
                    if (file2 == null || !file2.exists() || !file2.isDirectory()) continue;
                    object2 = file;
                    break;
                }
            }
            if (object2 == null && ((File)(object = ProjectChooser.getProjectsFolder())).exists() && ((File)object).isDirectory()) {
                object2 = object;
            }
            if (object2 == null) {
                object2 = new File(System.getProperty("user.home"));
            }
            return object2;
        }
    }
}

