/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.util;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.util.FlatFolder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class Utils {
    private static final Pattern metadataPattern = Pattern.compile(".*\\" + File.separatorChar + "CVS(\\" + File.separatorChar + ".*|$)");
    private static Reference contextNodesCached = new WeakReference<Object>(null);
    private static Context contextCached;

    public static Context getCurrentContext(Node[] nodeArray) {
        if (nodeArray == null) {
            nodeArray = TopComponent.getRegistry().getActivatedNodes();
        }
        if (Arrays.equals((Node[])contextNodesCached.get(), nodeArray)) {
            return contextCached;
        }
        HashSet<File> hashSet = new HashSet<File>(nodeArray.length);
        HashSet<File> hashSet2 = new HashSet<File>(nodeArray.length);
        HashSet hashSet3 = new HashSet(5);
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            CvsFileNode cvsFileNode = (CvsFileNode)node.getLookup().lookup(CvsFileNode.class);
            if (cvsFileNode != null) {
                hashSet.add(cvsFileNode.getFile());
                hashSet2.add(cvsFileNode.getFile());
                continue;
            }
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project != null) {
                Utils.addProjectFiles(hashSet, hashSet2, hashSet3, project);
                continue;
            }
            Utils.addFileObjects(node, hashSet, hashSet2);
        }
        contextCached = new Context(hashSet, hashSet2, hashSet3);
        contextNodesCached = new WeakReference<Node[]>(nodeArray);
        return contextCached;
    }

    public static Context getCurrentContext(Node[] nodeArray, int n, int n2) {
        Serializable serializable;
        Serializable serializable2;
        Context context = Utils.getCurrentContext(nodeArray);
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        File[] fileArray = context.getRootFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            serializable2 = fileArray[i];
            serializable = fileStatusCache.getStatus((File)serializable2);
            if (!(serializable2.isDirectory() ? (serializable.getStatus() & n2) == 0 : (serializable.getStatus() & n) == 0)) continue;
            return Context.Empty;
        }
        if (context.getExclusions().size() == 0) {
            return context;
        }
        HashSet<File> hashSet = new HashSet<File>(Arrays.asList(context.getFiles()));
        serializable2 = new HashSet<File>(Arrays.asList(context.getRootFiles()));
        serializable = new HashSet<File>(context.getExclusions());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (file.isDirectory()) {
                if ((fileStatusCache.getStatus(file).getStatus() & n2) != 0) continue;
                iterator.remove();
                continue;
            }
            if ((fileStatusCache.getStatus(file).getStatus() & n) != 0) continue;
            iterator.remove();
        }
        return new Context(hashSet, (Set)((Object)serializable2), (Set)((Object)serializable));
    }

    public static boolean isVersionedProject(Node node) {
        Lookup lookup = node.getLookup();
        Project project = (Project)lookup.lookup(Project.class);
        return Utils.isVersionedProject(project);
    }

    public static boolean isVersionedProject(Project project) {
        if (project != null) {
            FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                SourceGroup sourceGroup = sourceGroupArray[i];
                File file = FileUtil.toFile((FileObject)sourceGroup.getRootFolder());
                if (file == null || (fileStatusCache.getStatus(file).getStatus() & 0xFFFFFFFE) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static void addFileObjects(Node node, Set set, Set set2) {
        Collection collection = node.getLookup().lookup(new Lookup.Template(NonRecursiveFolder.class)).allInstances();
        ArrayList<FlatFolder> arrayList = new ArrayList<FlatFolder>();
        if (collection.size() > 0) {
            for (NonRecursiveFolder nonRecursiveFolder : collection) {
                arrayList.add(new FlatFolder(FileUtil.toFile((FileObject)nonRecursiveFolder.getFolder()).getAbsolutePath()));
            }
        } else {
            Collection collection2 = node.getLookup().lookup(new Lookup.Template(FileObject.class)).allInstances();
            if (collection2.size() > 0) {
                arrayList.addAll(Utils.toFileCollection(collection2));
            } else {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                if (dataObject != null) {
                    Collection collection3 = Utils.toFileCollection(dataObject.files());
                    arrayList.addAll(collection3);
                }
            }
        }
        set.addAll(arrayList);
        set2.addAll(arrayList);
    }

    public static void addProjectFiles(Collection collection, Collection collection2, Collection collection3, Project project) {
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            SourceGroup sourceGroup = sourceGroupArray[i];
            FileObject fileObject = sourceGroup.getRootFolder();
            File file = FileUtil.toFile((FileObject)fileObject);
            try {
                Utils.getCVSRootFor(file);
            }
            catch (IOException iOException) {
                continue;
            }
            collection2.add(file);
            boolean bl = false;
            FileObject[] fileObjectArray = fileObject.getChildren();
            HashSet<File> hashSet = new HashSet<File>(fileObjectArray.length);
            for (int j = 0; j < fileObjectArray.length; ++j) {
                FileObject fileObject2 = fileObjectArray[j];
                if ("CVS".equals(fileObject2.getNameExt())) continue;
                File file2 = FileUtil.toFile((FileObject)fileObject2);
                if (sourceGroup.contains(fileObject2) || ".cvsignore".equals(fileObject2.getNameExt())) {
                    hashSet.add(file2);
                    continue;
                }
                int n = fileStatusCache.getStatus(file2).getStatus();
                if (n == 2) continue;
                collection3.add(file2);
                bl = true;
            }
            if (bl) {
                collection.addAll(hashSet);
                continue;
            }
            collection.add(file);
        }
    }

    public static Context getProjectsContext(Project[] projectArray) {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet();
        for (int i = 0; i < projectArray.length; ++i) {
            Utils.addProjectFiles(hashSet, hashSet2, hashSet3, projectArray[i]);
        }
        return new Context(hashSet, hashSet2, hashSet3);
    }

    private static Collection toFileCollection(Collection collection) {
        HashSet<File> hashSet = new HashSet<File>(collection.size() * 4 / 3 + 1);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            hashSet.add(FileUtil.toFile((FileObject)((FileObject)iterator.next())));
        }
        hashSet.remove(null);
        return hashSet;
    }

    public static File[] toFileArray(Collection collection) {
        HashSet<File> hashSet = new HashSet<File>(collection.size() * 4 / 3 + 1);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            hashSet.add(FileUtil.toFile((FileObject)((FileObject)iterator.next())));
        }
        hashSet.remove(null);
        return hashSet.toArray(new File[hashSet.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCVSRootFor(File file) throws IOException {
        if (file.isFile()) {
            file = file.getParentFile();
        }
        while (file != null) {
            File file2 = new File(file, "CVS/Root");
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file2));
                String string = bufferedReader.readLine();
                return string;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            file = file.getParentFile();
        }
        throw new IOException("CVS/Root not found");
    }

    public static Window getCurrentWindow() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window instanceof Dialog || window instanceof Frame) {
            return window;
        }
        return WindowManager.getDefault().getMainWindow();
    }

    public static boolean isParentOrEqual(File file, File file2) {
        while (file2 != null) {
            if (file2.equals(file)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        return false;
    }

    public static String getRelativePath(File file) {
        try {
            return CvsVersioningSystem.getInstance().getAdminHandler().getRepositoryForDirectory(file.getParent(), "").substring(1);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String getSticky(File file) {
        if (file == null) {
            return null;
        }
        FileInformation fileInformation = CvsVersioningSystem.getInstance().getStatusCache().getStatus(file);
        if (fileInformation.getStatus() == 4) {
            return Utils.getSticky(file.getParentFile());
        }
        if (fileInformation.getStatus() == 2) {
            return null;
        }
        if (file.isDirectory()) {
            return CvsVersioningSystem.getInstance().getAdminHandler().getStickyTagForDirectory(file);
        }
        Entry entry = fileInformation.getEntry(file);
        if (entry != null) {
            String string = null;
            if (entry.getTag() != null) {
                string = "T" + entry.getTag();
            } else if (entry.getDate() != null) {
                string = "D" + entry.getDateFormatted();
            }
            return string;
        }
        return null;
    }

    public static String previousRevision(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("\\.");
        assert (stringArray.length % 2 == 0) : "File revisions must consist from even tokens: " + string;
        boolean bl = false;
        for (n = stringArray.length - 1; n > 1 && "1".equals(stringArray[n]); n -= 2) {
            bl = true;
        }
        if (n <= 0) {
            return null;
        }
        if (n == 1 && "1".equals(stringArray[n])) {
            return null;
        }
        int n2 = Integer.parseInt(stringArray[n]);
        if (!bl) {
            --n2;
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < n; ++i) {
            stringBuffer.append('.').append(stringArray[i]);
        }
        stringBuffer.append('.').append(n2);
        return stringBuffer.toString();
    }

    public static Project getProject(File file) {
        if (file == null) {
            return null;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return Utils.getProject(file.getParentFile());
        }
        return FileOwnerQuery.getOwner((FileObject)fileObject);
    }

    public static String createBranchRevisionNumber(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.lastIndexOf(46);
        stringBuilder.append(string.substring(0, n));
        stringBuilder.append(".0");
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    public static String formatBranches(LogInformation.Revision revision, boolean bl) {
        String string = revision.getBranches();
        if (string == null) {
            return "";
        }
        boolean bl2 = true;
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            List list = revision.getLogInfoHeader().getSymNamesForRevision(Utils.createBranchRevisionNumber(string2));
            if (list.size() > 0) {
                stringBuilder.append(((LogInformation.SymName)list.get(0)).getName());
            } else {
                bl2 = false;
                if (!bl) break;
                stringBuilder.append(string2);
            }
            stringBuilder.append("; ");
        }
        if (bl2 || bl) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        } else {
            stringBuilder.delete(0, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public static int getComparableStatus(int n) {
        switch (n) {
            case 64: {
                return 0;
            }
            case 128: {
                return 1;
            }
            case 2048: {
                return 10;
            }
            case 256: {
                return 11;
            }
            case 4: {
                return 12;
            }
            case 4096: {
                return 13;
            }
            case 16: {
                return 14;
            }
            case 1024: {
                return 30;
            }
            case 512: {
                return 31;
            }
            case 32: {
                return 32;
            }
            case 8: {
                return 50;
            }
            case 2: {
                return 100;
            }
            case 1: {
                return 101;
            }
            case 0: {
                return 102;
            }
        }
        throw new IllegalArgumentException("Unknown status: " + n);
    }

    public static boolean isPartOfCVSMetadata(File file) {
        return metadataPattern.matcher(file.getAbsolutePath()).matches();
    }

    public static FileObject mkfolders(File file) throws IOException {
        if (file.isDirectory()) {
            return FileUtil.toFileObject((File)file);
        }
        File file2 = file.getParentFile();
        String string = file.getName();
        while (!file2.isDirectory()) {
            string = file2.getName() + "/" + string;
            file2 = file2.getParentFile();
        }
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        return FileUtil.createFolder((FileObject)fileObject, (String)string);
    }

    public static boolean isTagValid(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') continue;
            return false;
        }
        return !string.equals("HEAD") && !string.equals("BASE");
    }

    public static class ByImportanceComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            FileInformation fileInformation = (FileInformation)object;
            FileInformation fileInformation2 = (FileInformation)object2;
            return Utils.getComparableStatus(fileInformation.getStatus()) - Utils.getComparableStatus(fileInformation2.getStatus());
        }
    }
}

