/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class NoProjectNew
extends JPanel
implements ActionListener,
DocumentListener {
    public static final int TYPE_FILE = 0;
    public static final int TYPE_FOLDER = 1;
    private static final String FILE_NAME = NbBundle.getMessage(NoProjectNew.class, (String)"LBL_NonProject_File_Name");
    private static final String FILE_TITLE = NbBundle.getMessage(NoProjectNew.class, (String)"LBL_NonProject_File_Title");
    private static final String FILE_TEXT_FIELD_ACD = NbBundle.getMessage(NoProjectNew.class, (String)"ACD_NonProject_File_TextField");
    private static final String FILE_DIALOG_ACD = NbBundle.getMessage(NoProjectNew.class, (String)"ACD_NonProject_File_Dialog");
    private static final String FOLDER_NAME = NbBundle.getMessage(NoProjectNew.class, (String)"LBL_NonProject_Folder_Name");
    private static final String FOLDER_TITLE = NbBundle.getMessage(NoProjectNew.class, (String)"LBL_NonProject_Folder_Title");
    private static final String FOLDER_TEXT_FIELD_ACD = NbBundle.getMessage(NoProjectNew.class, (String)"ACD_NonProject_Folder_TextField");
    private static final String FOLDER_DIALOG_ACD = NbBundle.getMessage(NoProjectNew.class, (String)"ACD_NonProject_Folder_Dialog");
    public static final String COMMAND_OK = "OK";
    public static final String COMMAND_CANCEL = "CANCEL";
    private static DataObject[] templates;
    private int type;
    private DataFolder targetFolder;
    private String result;
    private JButton okOption;
    public JLabel nameLabel;
    public JTextField nameTextField;

    public NoProjectNew(int n, DataFolder dataFolder, JButton jButton) {
        this.initComponents();
        this.nameTextField.getDocument().addDocumentListener(this);
        this.type = n;
        this.targetFolder = dataFolder;
        this.okOption = jButton;
        switch (n) {
            case 0: {
                Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)FILE_NAME);
                this.nameTextField.getAccessibleContext().setAccessibleDescription(FILE_TEXT_FIELD_ACD);
                this.getAccessibleContext().setAccessibleDescription(FILE_DIALOG_ACD);
                break;
            }
            case 1: {
                Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)FOLDER_NAME);
                this.nameTextField.getAccessibleContext().setAccessibleDescription(FOLDER_TEXT_FIELD_ACD);
                this.getAccessibleContext().setAccessibleDescription(FOLDER_DIALOG_ACD);
            }
        }
        this.okOption.setEnabled(false);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameLabel.setText("Folders:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField.setColumns(25);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.nameTextField, gridBagConstraints);
    }

    public static void showDialog(DataObject dataObject, DataFolder dataFolder) {
        int n = dataObject.getPrimaryFile().getName().equals("file") ? 0 : 1;
        Object[] objectArray = new JButton[]{new JButton(NbBundle.getMessage(NoProjectNew.class, (String)"LBL_NonProject_OK_Button")), new JButton(NbBundle.getMessage(NoProjectNew.class, (String)"LBL_NonProject_Cancel_Button"))};
        NoProjectNew noProjectNew = new NoProjectNew(n, dataFolder, objectArray[0]);
        objectArray[0].setActionCommand(COMMAND_OK);
        objectArray[0].addActionListener(noProjectNew);
        objectArray[1].setActionCommand(COMMAND_CANCEL);
        objectArray[1].addActionListener(noProjectNew);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)noProjectNew, n == 0 ? FILE_TITLE : FOLDER_TITLE, true, objectArray, (Object)objectArray[0], 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{objectArray[0], objectArray[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        noProjectNew.createFile();
    }

    public static DataObject[] getTemplates() {
        if (templates == null) {
            ArrayList<DataObject> arrayList = new ArrayList<DataObject>(2);
            DataObject dataObject = NoProjectNew.findTemplate("Templates/Other/file");
            if (dataObject != null) {
                arrayList.add(dataObject);
            }
            if ((dataObject = NoProjectNew.findTemplate("Templates/Other/Folder")) != null) {
                arrayList.add(dataObject);
            }
            templates = new DataObject[arrayList.size()];
            arrayList.toArray(templates);
        }
        return templates;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.result = COMMAND_OK.equals(actionEvent.getActionCommand()) ? this.getFileName() : null;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        String string = this.getFileName();
        if (string.length() == 0) {
            this.okOption.setEnabled(false);
            return;
        }
        FileObject fileObject = this.targetFolder.getPrimaryFile().getFileObject(string);
        if (fileObject != null) {
            this.okOption.setEnabled(false);
            return;
        }
        this.okOption.setEnabled(true);
    }

    private static DataObject findTemplate(String string) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
        if (fileObject == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    private String getFileName() {
        String string = this.nameTextField.getText().trim();
        return string.replace(File.separatorChar, '/');
    }

    private void createFile() {
        if (this.result != null) {
            DataObject dataObject;
            if (!this.targetFolder.getPrimaryFile().canWrite()) {
                return;
            }
            DataObject dataObject2 = null;
            try {
                FileObject fileObject = dataObject = this.type == 0 ? FileUtil.createData((FileObject)this.targetFolder.getPrimaryFile(), (String)this.result) : FileUtil.createFolder((FileObject)this.targetFolder.getPrimaryFile(), (String)this.result);
                if (dataObject != null) {
                    dataObject2 = DataObject.find((FileObject)dataObject);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.result != null) {
                dataObject = NoProjectNew.findTemplate("/Templates");
                if (dataObject != null && dataObject2 != null && FileUtil.isParentOf((FileObject)dataObject.getPrimaryFile(), (FileObject)dataObject2.getPrimaryFile())) {
                    try {
                        dataObject2.setTemplate(true);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ProjectUtilities.openAndSelectNewObject(dataObject2);
            }
        }
    }
}

