/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectChooserAccessory
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private RequestProcessor.Task updateSubprojectsTask;
    private RequestProcessor RP;
    private ModelUpdater modelUpdater;
    private Boolean tempSetAsMain;
    private Map<Project, Set<? extends Project>> subprojectsCache = new HashMap<Project, Set<? extends Project>>();
    private JCheckBox jCheckBoxMain;
    private JCheckBox jCheckBoxSubprojects;
    private JLabel jLabelProjectName;
    private JList jListSubprojects;
    private JScrollPane jScrollPaneSubprojects;
    private JTextField jTextFieldProjectName;

    public ProjectChooserAccessory(JFileChooser jFileChooser, boolean bl, boolean bl2) {
        this.initComponents();
        this.modelUpdater = new ModelUpdater();
        this.RP = new RequestProcessor(ModelUpdater.class.getName(), 1);
        this.updateSubprojectsTask = this.RP.create((Runnable)this.modelUpdater);
        this.updateSubprojectsTask.setPriority(1);
        this.jCheckBoxSubprojects.setSelected(bl);
        this.jCheckBoxSubprojects.addActionListener(this);
        this.jCheckBoxMain.setSelected(bl2);
        this.jCheckBoxMain.addActionListener(this);
        jFileChooser.addPropertyChangeListener(this);
        this.jListSubprojects.setModel(new DefaultListModel());
        this.setAccessoryEnablement(false, 0);
    }

    private void initComponents() {
        this.jLabelProjectName = new JLabel();
        this.jTextFieldProjectName = new JTextField();
        this.jCheckBoxMain = new JCheckBox();
        this.jCheckBoxSubprojects = new JCheckBox();
        this.jScrollPaneSubprojects = new JScrollPane();
        this.jListSubprojects = new JList();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(0, 12, 0, 0)));
        this.jLabelProjectName.setLabelFor(this.jTextFieldProjectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabelProjectName, (String)NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabelProjectName, gridBagConstraints);
        this.jLabelProjectName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AN_ProjectName"));
        this.jLabelProjectName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AD_ProjectName"));
        this.jTextFieldProjectName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jTextFieldProjectName, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxMain, (String)NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Main_CheckBox"));
        this.jCheckBoxMain.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jCheckBoxMain, gridBagConstraints);
        this.jCheckBoxMain.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSD_ProjectChooserAccessory_jCheckBoxMain"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxSubprojects, (String)NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Subprojects_CheckBox"));
        this.jCheckBoxSubprojects.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jCheckBoxSubprojects, gridBagConstraints);
        this.jCheckBoxSubprojects.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSD_ProjectChooserAccessory_jCheckBoxSubprojects"));
        this.jListSubprojects.setSelectionMode(0);
        this.jListSubprojects.setEnabled(false);
        this.jScrollPaneSubprojects.setViewportView(this.jListSubprojects);
        this.jListSubprojects.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSN_ProjectChooserAccessory_jListSubprojects"));
        this.jListSubprojects.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSD_ProjectChooserAccessory_jListSubprojects"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPaneSubprojects, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.jCheckBoxSubprojects) {
            OpenProjectListSettings.getInstance().setOpenSubprojects(this.jCheckBoxSubprojects.isSelected());
        } else if (actionEvent.getSource() == this.jCheckBoxMain) {
            OpenProjectListSettings.getInstance().setOpenAsMain(this.jCheckBoxMain.isSelected());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName()) || "SelectedFilesChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
            final ListModel listModel = this.jListSubprojects.getModel();
            final File[] fileArray = jFileChooser.isMultiSelectionEnabled() ? jFileChooser.getSelectedFiles() : new File[]{jFileChooser.getSelectedFile()};
            this.jTextFieldProjectName.setText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"MSG_PrjChooser_WaitMessage"));
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    final ArrayList<Project> arrayList = new ArrayList<Project>(fileArray.length);
                    for (File file : fileArray) {
                        Project project;
                        if (file == null || (project = ProjectChooserAccessory.getProject(FileUtil.normalizeFile((File)file))) == null) continue;
                        arrayList.add(project);
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (!arrayList.isEmpty()) {
                                ProjectChooserAccessory.this.setAccessoryEnablement(true, arrayList.size());
                                if (arrayList.size() == 1) {
                                    String string = ProjectUtils.getInformation((Project)((Project)arrayList.get(0))).getDisplayName();
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setText(string);
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setToolTipText(string);
                                } else {
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Multiselection", (Object)arrayList.size()));
                                    StringBuffer stringBuffer = new StringBuffer("<html>");
                                    Iterator iterator = arrayList.iterator();
                                    while (iterator.hasNext()) {
                                        Project project = (Project)iterator.next();
                                        stringBuffer.append(ProjectUtils.getInformation((Project)project).getDisplayName());
                                        if (!iterator.hasNext()) continue;
                                        stringBuffer.append("<br>");
                                    }
                                    stringBuffer.append("</html>");
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setToolTipText(stringBuffer.toString());
                                }
                                if (listModel instanceof DefaultListModel) {
                                    ((DefaultListModel)listModel).clear();
                                } else {
                                    ProjectChooserAccessory.this.jListSubprojects.setListData(new String[0]);
                                }
                                if (ProjectChooserAccessory.this.modelUpdater != null) {
                                    ((ProjectChooserAccessory)ProjectChooserAccessory.this).modelUpdater.projects = arrayList;
                                    ProjectChooserAccessory.this.updateSubprojectsTask.schedule(100);
                                }
                            } else {
                                File file;
                                FileObject fileObject;
                                ProjectChooserAccessory.this.jTextFieldProjectName.setText("");
                                if (ProjectChooserAccessory.this.modelUpdater != null) {
                                    ((ProjectChooserAccessory)ProjectChooserAccessory.this).modelUpdater.projects = null;
                                }
                                if (listModel instanceof DefaultListModel) {
                                    ((DefaultListModel)listModel).clear();
                                } else {
                                    ProjectChooserAccessory.this.jListSubprojects.setListData(new String[0]);
                                }
                                ProjectChooserAccessory.this.setAccessoryEnablement(false, 0);
                                if (fileArray.length == 1 && fileArray[0] != null && (fileObject = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)fileArray[0])))) != null && fileObject.isFolder() && ProjectManager.getDefault().isProject(fileObject)) {
                                    try {
                                        Project project = ProjectManager.getDefault().findProject(fileObject);
                                        if (project == null) {
                                            ProjectChooserAccessory.this.jTextFieldProjectName.setText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Unrecognized"));
                                            ProjectChooserAccessory.this.jLabelProjectName.setEnabled(true);
                                            ProjectChooserAccessory.this.jTextFieldProjectName.setEnabled(true);
                                        }
                                    }
                                    catch (IOException iOException) {
                                        String string = iOException.toString();
                                        ErrorManager.Annotation[] annotationArray = ErrorManager.getDefault().findAnnotations((Throwable)iOException);
                                        for (int i = 0; i < annotationArray.length; ++i) {
                                            if (annotationArray[i].getLocalizedMessage() == null) continue;
                                            string = annotationArray[i].getLocalizedMessage();
                                            break;
                                        }
                                        ProjectChooserAccessory.this.jTextFieldProjectName.setText(string);
                                        ProjectChooserAccessory.this.jTextFieldProjectName.setCaretPosition(0);
                                        Color color = UIManager.getColor("nb.errorForeground");
                                        if (color != null) {
                                            ProjectChooserAccessory.this.jTextFieldProjectName.setForeground(color);
                                        }
                                        ProjectChooserAccessory.this.jLabelProjectName.setEnabled(true);
                                        ProjectChooserAccessory.this.jTextFieldProjectName.setEnabled(true);
                                    }
                                }
                            }
                        }
                    });
                }
            });
        } else if ("directoryChanged".equals(propertyChangeEvent.getPropertyName())) {
            this.setAccessoryEnablement(false, 0);
        }
    }

    private static boolean isProjectDir(File file) {
        FileObject fileObject;
        boolean bl = false;
        if (file != null && (fileObject = ProjectChooserAccessory.convertToValidDir(file)) != null) {
            bl = Utilities.isUnix() && fileObject.getParent() != null && fileObject.getParent().getParent() == null ? false : ProjectManager.getDefault().isProject(fileObject);
        }
        return bl;
    }

    private static FileObject convertToValidDir(File file) {
        File file2 = new File(file.getPath());
        if (file2 == null || file2.getParent() == null) {
            return null;
        }
        if (!file2.isDirectory()) {
            return null;
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        return fileObject;
    }

    private static Project getProject(File file) {
        return OpenProjectList.fileToProject(file);
    }

    private void setAccessoryEnablement(boolean bl, int n) {
        this.jLabelProjectName.setEnabled(bl);
        this.jTextFieldProjectName.setEnabled(bl);
        this.jTextFieldProjectName.setForeground(null);
        this.jCheckBoxSubprojects.setEnabled(bl);
        this.jScrollPaneSubprojects.setEnabled(bl);
        if (n <= 1) {
            if (this.tempSetAsMain != null) {
                this.jCheckBoxMain.setSelected(this.tempSetAsMain);
                this.tempSetAsMain = null;
            }
            this.jCheckBoxMain.setEnabled(bl);
        } else if (this.tempSetAsMain == null) {
            this.tempSetAsMain = this.jCheckBoxMain.isSelected();
            this.jCheckBoxMain.setSelected(false);
            this.jCheckBoxMain.setEnabled(false);
        }
    }

    static void addSubprojects(Project project, List<Project> list, Map<Project, Set<? extends Project>> map) {
        Set<Object> set = map.get(project);
        if (set == null) {
            SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            set = subprojectProvider != null ? subprojectProvider.getSubprojects() : Collections.emptySet();
            map.put(project, (Set<? extends Project>)set);
        }
        for (Project project2 : set) {
            if (list.contains(project2)) continue;
            list.add(project2);
            ProjectChooserAccessory.addSubprojects(project2, list, map);
        }
    }

    private static String relativizePath(File file, File file2) {
        if (file == null || file2 == null) {
            return null;
        }
        if (!CollocationQuery.areCollocated((File)file, (File)file2)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        File file3 = file;
        String string = file2.getAbsolutePath();
        while (!string.startsWith(ProjectChooserAccessory.slashify(file3.getAbsolutePath()))) {
            if ((file3 = file3.getParentFile()) == null) {
                return null;
            }
            if (file3.equals(file2)) {
                stringBuffer.append("..");
                return stringBuffer.toString();
            }
            stringBuffer.append("../");
        }
        URI uRI = file3.toURI().relativize(file2.toURI());
        assert (!uRI.isAbsolute()) : uRI + " from " + file + " and " + file2 + " with common root " + file3;
        stringBuffer.append(uRI.getPath());
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '/') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static String slashify(String string) {
        if (string.endsWith(File.separator)) {
            return string;
        }
        return string + File.separatorChar;
    }

    public static JFileChooser createProjectChooser(boolean bl) {
        File file;
        ProjectManager.getDefault().clearNonProjectCache();
        OpenProjectListSettings openProjectListSettings = OpenProjectListSettings.getInstance();
        ProjectFileChooser projectFileChooser = new ProjectFileChooser();
        projectFileChooser.setFileSelectionMode(1);
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            projectFileChooser.putClientProperty("GTKFileChooser.showDirectoryIcons", Boolean.TRUE);
        }
        projectFileChooser.setApproveButtonText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"BTN_PrjChooser_ApproveButtonText"));
        projectFileChooser.setApproveButtonMnemonic(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"MNM_PrjChooser_ApproveButtonText").charAt(0));
        projectFileChooser.setApproveButtonToolTipText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"BTN_PrjChooser_ApproveButtonTooltipText"));
        projectFileChooser.setDialogTitle(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Title"));
        projectFileChooser.setAcceptAllFileFilterUsed(false);
        projectFileChooser.setFileFilter(ProjectDirFilter.INSTANCE);
        projectFileChooser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AN_ProjectChooserAccessory"));
        projectFileChooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AD_ProjectChooserAccessory"));
        if (bl) {
            projectFileChooser.setAccessory(new ProjectChooserAccessory(projectFileChooser, openProjectListSettings.isOpenSubprojects(), openProjectListSettings.isOpenAsMain()));
        }
        File file2 = null;
        String string = openProjectListSettings.getLastOpenProjectDir();
        if (string != null && (file = new File(string)).exists() && file.isDirectory()) {
            file2 = file;
        }
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)projectFileChooser, file2);
        projectFileChooser.setFileView(new ProjectFileView(projectFileChooser.getFileSystemView()));
        return projectFileChooser;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.modelUpdater = null;
        this.subprojectsCache = null;
        this.updateSubprojectsTask = null;
        this.RP.stop();
    }

    private static class MergedIcon
    implements Icon {
        private Icon icon1;
        private Icon icon2;
        private int xMerge;
        private int yMerge;

        MergedIcon(Icon icon, Icon icon2, int n, int n2) {
            this.icon1 = icon;
            this.icon2 = icon2;
            if (n == -1) {
                n = icon.getIconWidth() - icon2.getIconWidth();
            }
            if (n2 == -1) {
                n2 = icon.getIconHeight() - icon2.getIconHeight();
            }
            this.xMerge = n;
            this.yMerge = n2;
        }

        public int getIconHeight() {
            return Math.max(this.icon1.getIconHeight(), this.yMerge + this.icon2.getIconHeight());
        }

        public int getIconWidth() {
            return Math.max(this.icon1.getIconWidth(), this.yMerge + this.icon2.getIconWidth());
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon1.paintIcon(component, graphics, n, n2);
            this.icon2.paintIcon(component, graphics, n + this.xMerge, n2 + this.yMerge);
        }
    }

    private class ModelUpdater
    implements Runnable {
        volatile List<Project> projects;
        private DefaultListModel subprojectsToSet;

        private ModelUpdater() {
        }

        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                Iterator iterator;
                List<Project> list = this.projects;
                if (list == null) {
                    return;
                }
                Map map = ProjectChooserAccessory.this.subprojectsCache;
                if (map == null) {
                    return;
                }
                ProjectChooserAccessory.this.jListSubprojects.setListData(new String[]{NbBundle.getMessage(ProjectChooserAccessory.class, (String)"MSG_PrjChooser_WaitMessage")});
                ArrayList<Project> arrayList = new ArrayList<Project>(list.size() * 5);
                for (Project object2 : list) {
                    ProjectChooserAccessory.addSubprojects(object2, arrayList, map);
                }
                ArrayList arrayList2 = new ArrayList(arrayList.size());
                if (!arrayList.isEmpty()) {
                    String string = NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_SubprojectName_Format");
                    iterator = list.size() == 1 ? FileUtil.toFile((FileObject)list.get(0).getProjectDirectory()) : null;
                    for (Project project : arrayList) {
                        FileObject fileObject = project.getProjectDirectory();
                        String string2 = null;
                        if (iterator != null) {
                            string2 = ProjectChooserAccessory.relativizePath(iterator, FileUtil.toFile((FileObject)fileObject));
                        }
                        if (string2 == null) {
                            string2 = FileUtil.getFileDisplayName((FileObject)fileObject);
                        }
                        String string3 = MessageFormat.format(string, ProjectUtils.getInformation((Project)project).getDisplayName(), string2);
                        arrayList2.add(string3);
                    }
                    Collections.sort(arrayList2, Collator.getInstance());
                }
                if (list != this.projects) {
                    return;
                }
                DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
                iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    defaultListModel.addElement(string);
                }
                this.subprojectsToSet = defaultListModel;
                SwingUtilities.invokeLater(this);
                return;
            }
            if (this.projects == null) {
                ListModel listModel = ProjectChooserAccessory.this.jListSubprojects.getModel();
                if (listModel instanceof DefaultListModel) {
                    ((DefaultListModel)listModel).clear();
                } else {
                    ProjectChooserAccessory.this.jListSubprojects.setListData(new String[0]);
                }
                ProjectChooserAccessory.this.jCheckBoxSubprojects.setEnabled(false);
            } else {
                ProjectChooserAccessory.this.jListSubprojects.setModel(this.subprojectsToSet);
                ProjectChooserAccessory.this.jCheckBoxSubprojects.setEnabled(!this.subprojectsToSet.isEmpty());
                this.projects = null;
            }
        }
    }

    private static class ProjectDirFilter
    extends FileFilter {
        private static final FileFilter INSTANCE = new ProjectDirFilter();

        private ProjectDirFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }

        public String getDescription() {
            return NbBundle.getMessage(ProjectDirFilter.class, (String)"LBL_PrjChooser_ProjectDirectoryFilter_Name");
        }
    }

    private static class ProjectFileChooser
    extends JFileChooser {
        private ProjectFileChooser() {
        }

        public void approveSelection() {
            File file = FileUtil.normalizeFile((File)this.getSelectedFile());
            if (ProjectChooserAccessory.isProjectDir(file) && ProjectChooserAccessory.getProject(file) != null) {
                super.approveSelection();
            } else {
                this.setCurrentDirectory(file);
            }
        }
    }

    private static class ProjectFileView
    extends FileView {
        private static final Icon BADGE = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/projectBadge.gif"));
        private static final Icon EMPTY = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/empty.gif"));
        private FileSystemView fsv;
        private Icon lastOriginal;
        private Icon lastMerged;

        public ProjectFileView(FileSystemView fileSystemView) {
            this.fsv = fileSystemView;
        }

        public Icon getIcon(File file) {
            if (!file.exists()) {
                return null;
            }
            File file2 = FileUtil.normalizeFile((File)file);
            Icon icon = this.fsv.getSystemIcon(file2);
            if (icon == null) {
                icon = EMPTY;
            }
            if (ProjectChooserAccessory.isProjectDir(file2)) {
                if (icon.equals(this.lastOriginal)) {
                    return this.lastMerged;
                }
                this.lastOriginal = icon;
                this.lastMerged = new MergedIcon(icon, BADGE, -1, -1);
                return this.lastMerged;
            }
            return icon;
        }
    }
}

