/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.ExitDialog;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtilities {
    static final String OPEN_FILES_NS = "http://www.netbeans.org/ns/projectui-open-files/1";
    static final String OPEN_FILES_ELEMENT = "open-files";
    static final String FILE_ELEMENT = "file";
    static OpenCloseProjectDocument OPEN_CLOSE_PROJECT_DOCUMENT_IMPL = new OpenCloseProjectDocument(){

        @Override
        public boolean open(FileObject fileObject) {
            DataObject dataObject;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                assert (false) : "DataObject must exist for " + fileObject;
                return false;
            }
            EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
            OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
            if (editCookie != null) {
                editCookie.edit();
            } else if (openCookie != null) {
                openCookie.open();
            } else {
                if (ERR.isLoggable(1)) {
                    ERR.log("No EditCookie nor OpenCookie for " + dataObject);
                }
                return false;
            }
            return true;
        }

        @Override
        public Map<Project, SortedSet<String>> close(final Project[] projectArray, final boolean bl) {
            final Wrapper wrapper = new Wrapper();
            wrapper.urls4project = new HashMap<Project, SortedSet<String>>();
            if (SwingUtilities.isEventDispatchThread()) {
                this.doClose(projectArray, bl, wrapper);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            this.doClose(projectArray, bl, wrapper);
                        }
                    });
                }
                catch (Exception exception) {
                    ERR.notify(1, (Throwable)exception);
                }
            }
            return wrapper.urls4project;
        }

        private void doClose(Project[] projectArray, boolean bl, Wrapper wrapper) {
            Project project;
            DataObject dataObject;
            List<Project> list = Arrays.asList(projectArray);
            HashSet<DataObject> hashSet = new HashSet<DataObject>();
            HashSet<TopComponent> hashSet2 = new HashSet<TopComponent>();
            for (TopComponent topComponent : WindowManager.getDefault().getRegistry().getOpened()) {
                Project project2;
                if (!(topComponent instanceof CloneableTopComponent) || topComponent instanceof ExplorerManager.Provider || (dataObject = (DataObject)topComponent.getLookup().lookup(DataObject.class)) == null || !list.contains(project2 = FileOwnerQuery.getOwner((FileObject)(project = dataObject.getPrimaryFile())))) continue;
                if (bl) {
                    hashSet.add(dataObject);
                    hashSet2.add(topComponent);
                } else if (!dataObject.isModified()) {
                    hashSet2.add(topComponent);
                }
                if (!wrapper.urls4project.containsKey(project2)) {
                    wrapper.urls4project.put(project2, new TreeSet());
                }
                URL uRL = null;
                try {
                    uRL = dataObject.getPrimaryFile().getURL();
                    wrapper.urls4project.get(project2).add(uRL.toExternalForm());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    assert (false) : "FileStateInvalidException in " + dataObject.getPrimaryFile();
                }
            }
            if (bl) {
                for (TopComponent topComponent : DataObject.getRegistry().getModifiedSet()) {
                    dataObject = topComponent.getPrimaryFile();
                    project = FileOwnerQuery.getOwner((FileObject)dataObject);
                    if (!list.contains(project) || hashSet.contains(topComponent)) continue;
                    hashSet.add((DataObject)topComponent);
                }
            }
            if (!bl || !hashSet.isEmpty() && ExitDialog.showDialog(hashSet)) {
                for (TopComponent topComponent : hashSet2) {
                    topComponent.close();
                }
            } else if (!hashSet.isEmpty()) {
                wrapper.urls4project = null;
            }
        }
    };
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(ProjectUtilities.class.getName());

    private ProjectUtilities() {
    }

    public static void selectAndExpandProject(final Project project) {
        SwingUtilities.invokeLater(new Runnable(){
            final ProjectTab ptLogial = ProjectTab.findDefault("projectTabLogical_tc");

            public void run() {
                Node node = this.ptLogial.getExplorerManager().getRootContext();
                Node node2 = null;
                for (Node node3 : node.getChildren().getNodes()) {
                    Project project2 = (Project)node3.getLookup().lookup(Project.class);
                    if (project2 == null || !project2.getProjectDirectory().equals(project.getProjectDirectory())) continue;
                    node2 = node3;
                    break;
                }
                if (node2 == null) {
                    node2 = node.getChildren().findChild(ProjectUtils.getInformation((Project)project).getName());
                }
                if (node2 != null) {
                    try {
                        this.ptLogial.getExplorerManager().setSelectedNodes(new Node[]{node2});
                        this.ptLogial.expandNode(node2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public static void openAndSelectNewObject(final DataObject dataObject) {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                Node node = dataObject.getNodeDelegate();
                Action action = node.getPreferredAction();
                if (action instanceof ContextAwareAction) {
                    action = ((ContextAwareAction)action).createContextAwareInstance(node.getLookup());
                }
                if (action != null) {
                    action.actionPerformed(new ActionEvent(node, 1001, ""));
                }
                final ProjectTab projectTab = ProjectTab.findDefault("projectTabLogical_tc");
                final ProjectTab projectTab2 = ProjectTab.findDefault("projectTab_tc");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        boolean bl = projectTab.selectNode(dataObject.getPrimaryFile());
                        if (!bl) {
                            projectTab2.selectNode(dataObject.getPrimaryFile());
                        }
                    }
                });
            }
        });
    }

    public static void makeProjectTabVisible(boolean bl) {
        ProjectTab projectTab = ProjectTab.findDefault("projectTabLogical_tc");
        projectTab.open();
        if (bl) {
            projectTab.requestActive();
        } else {
            projectTab.requestVisible();
        }
    }

    public static String canUseFileName(FileObject fileObject, String string, String string2, String string3, boolean bl) {
        assert (string2 != null);
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        if (bl) {
            if (File.separatorChar == '\\') {
                n = 3;
                bl3 = true;
                bl2 = true;
            } else {
                n = 1;
                bl2 = true;
            }
        }
        if (!bl2 && string2.indexOf(47) != -1 || !bl3 && string2.indexOf(92) != -1) {
            assert (n == 0 || n == 1) : "Invalid error variant: " + n;
            return NbBundle.getMessage(ProjectUtilities.class, (String)"MSG_not_valid_filename", (Object)string2, (Object)new Integer(n));
        }
        if (fileObject == null) {
            return NbBundle.getMessage(ProjectUtilities.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!fileObject.canWrite()) {
            return NbBundle.getMessage(ProjectUtilities.class, (String)"MSG_fs_is_readonly");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            if (!bl3 && string.indexOf(92) != -1) {
                return NbBundle.getMessage(ProjectUtilities.class, (String)"MSG_not_valid_folder", (Object)string, (Object)new Integer(1));
            }
            stringBuffer.append(string);
            stringBuffer.append('/');
        }
        stringBuffer.append(string2);
        if (string3 != null && string3.length() != 0) {
            stringBuffer.append('.');
            stringBuffer.append(string3);
        }
        if (fileObject.getFileObject(stringBuffer.toString()) != null) {
            return NbBundle.getMessage(ProjectUtilities.class, (String)"MSG_file_already_exist", (Object)string2);
        }
        return null;
    }

    public static boolean closeAllDocuments(Project[] projectArray, boolean bl) {
        if (projectArray == null) {
            throw new IllegalArgumentException("No projects are specified.");
        }
        if (projectArray.length == 0) {
            return true;
        }
        Map<Project, SortedSet<String>> map = OPEN_CLOSE_PROJECT_DOCUMENT_IMPL.close(projectArray, bl);
        if (map != null) {
            for (Map.Entry<Project, SortedSet<String>> entry : map.entrySet()) {
                ProjectUtilities.storeProjectOpenFiles(entry.getKey(), entry.getValue());
            }
        }
        return map != null;
    }

    private static void storeProjectOpenFiles(Project project, SortedSet<String> sortedSet) {
        AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
        if (auxiliaryConfiguration != null) {
            auxiliaryConfiguration.removeConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS, false);
            Document document = XMLUtil.createDocument((String)OPEN_FILES_ELEMENT, (String)OPEN_FILES_NS, null, null);
            Element element = document.createElementNS(OPEN_FILES_NS, OPEN_FILES_ELEMENT);
            for (String string : sortedSet) {
                Element element2 = element.getOwnerDocument().createElement(FILE_ELEMENT);
                element2.appendChild(element2.getOwnerDocument().createTextNode(string));
                element.appendChild(element2);
            }
            auxiliaryConfiguration.putConfigurationFragment(element, false);
        }
    }

    public static void openProjectFiles(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration;
        boolean bl = ERR.isLoggable(1);
        if (bl) {
            ERR.log("Trying to open files from " + project + "...");
        }
        if ((auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class)) == null) {
            if (bl) {
                ERR.log("No AuxiliaryConfiguration in " + project);
            }
            return;
        }
        Element element = auxiliaryConfiguration.getConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS, false);
        if (element == null) {
            if (bl) {
                ERR.log("No open-files in private.xml");
            }
            return;
        }
        NodeList nodeList = element.getElementsByTagName(FILE_ELEMENT);
        if (nodeList == null) {
            if (bl) {
                ERR.log("No file in open-files");
            }
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            FileObject fileObject;
            String string = nodeList.item(i).getChildNodes().item(0).getNodeValue();
            if (bl) {
                ERR.log("Will try to open " + string);
            }
            try {
                fileObject = URLMapper.findFileObject((URL)new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                assert (false) : "MalformedURLException in " + string;
                continue;
            }
            if (fileObject == null) {
                if (!bl) continue;
                ERR.log("Could not find " + string);
                continue;
            }
            OPEN_CLOSE_PROJECT_DOCUMENT_IMPL.open(fileObject);
        }
        auxiliaryConfiguration.removeConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface OpenCloseProjectDocument {
        public boolean open(FileObject var1);

        public Map<Project, SortedSet<String>> close(Project[] var1, boolean var2);
    }

    public static class WaitCursor
    implements Runnable {
        private boolean show;

        private WaitCursor(boolean bl) {
            this.show = bl;
        }

        public static void show() {
            WaitCursor.invoke(new WaitCursor(true));
        }

        public static void hide() {
            WaitCursor.invoke(new WaitCursor(false));
        }

        private static void invoke(WaitCursor waitCursor) {
            if (SwingUtilities.isEventDispatchThread()) {
                waitCursor.run();
            } else {
                SwingUtilities.invokeLater(waitCursor);
            }
        }

        public void run() {
            try {
                JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
                Component component = jFrame.getGlassPane();
                component.setVisible(this.show);
                component.setCursor(this.show ? Cursor.getPredefinedCursor(3) : null);
            }
            catch (NullPointerException nullPointerException) {
                ErrorManager.getDefault().notify(1, (Throwable)nullPointerException);
            }
        }
    }

    private static class Wrapper {
        Map<Project, SortedSet<String>> urls4project;

        private Wrapper() {
        }
    }
}

