/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.SimpleTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class SimpleTargetChooserPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private SimpleTargetChooserPanelGUI gui;
    private Project project;
    private SourceGroup[] folders;
    private WizardDescriptor.Panel bottomPanel;
    private WizardDescriptor wizard;
    private boolean isFolder;

    SimpleTargetChooserPanel(Project project, SourceGroup[] sourceGroupArray, WizardDescriptor.Panel panel, boolean bl) {
        this.folders = sourceGroupArray;
        this.project = project;
        this.bottomPanel = panel;
        if (panel != null) {
            panel.addChangeListener((ChangeListener)this);
        }
        this.isFolder = bl;
        this.gui = null;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new SimpleTargetChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.isFolder);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        HelpCtx helpCtx;
        if (this.bottomPanel != null && (helpCtx = this.bottomPanel.getHelp()) != null) {
            return helpCtx;
        }
        return null;
    }

    public boolean isValid() {
        boolean bl;
        boolean bl2 = bl = this.gui != null && this.gui.getTargetName() != null && (this.bottomPanel == null || this.bottomPanel.isValid());
        if (!bl) {
            return false;
        }
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wizard);
        String string = ProjectUtilities.canUseFileName(this.gui.getTargetGroup().getRootFolder(), this.gui.getTargetFolder(), this.gui.getTargetName(), fileObject.getExt(), this.isFolder);
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
        return string == null;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        SimpleTargetChooserPanel simpleTargetChooserPanel = this;
        synchronized (simpleTargetChooserPanel) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void readSettings(Object object) {
        this.wizard = (WizardDescriptor)object;
        if (this.gui == null) {
            this.getComponent();
        }
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        String string = Templates.getTargetName((WizardDescriptor)this.wizard);
        this.gui.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), fileObject, string);
        Object object2 = this.gui.getClientProperty("NewFileWizard_Title");
        if (object2 != null) {
            this.wizard.putProperty("NewFileWizard_Title", object2);
        }
        this.wizard.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getBundle(SimpleTargetChooserPanel.class).getString("LBL_TemplatesPanel_Name"), NbBundle.getBundle(SimpleTargetChooserPanel.class).getString("LBL_SimpleTargetChooserPanel_Name")});
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings(object);
        }
    }

    public void storeSettings(Object object) {
        if (WizardDescriptor.PREVIOUS_OPTION.equals(((WizardDescriptor)object).getValue())) {
            return;
        }
        if (!((WizardDescriptor)object).getValue().equals(WizardDescriptor.CANCEL_OPTION) && this.isValid()) {
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings(object);
            }
            FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wizard);
            String string = this.gui.getTargetName();
            if (string.indexOf(47) > 0) {
                string = string.substring(string.lastIndexOf(47) + 1);
            }
            FileObject fileObject2 = this.getTargetFolderFromGUI();
            try {
                Templates.setTargetFolder((WizardDescriptor)((WizardDescriptor)object), (FileObject)fileObject2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 4096, null, NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_Cannot_Create_Folder", (Object)this.gui.getTargetFolder()), null, null);
                throw illegalArgumentException;
            }
            Templates.setTargetName((WizardDescriptor)((WizardDescriptor)object), (String)string);
        }
        ((WizardDescriptor)object).putProperty("NewFileWizard_Title", null);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }

    private FileObject getTargetFolderFromGUI() {
        Object object;
        FileObject fileObject = this.gui.getTargetGroup().getRootFolder();
        String string = this.gui.getTargetFolder();
        String string2 = this.gui.getTargetName();
        if (string2.indexOf(47) > 0) {
            object = string2.substring(0, string2.lastIndexOf(47));
            string = string == null || "".equals(string) ? object : string + '/' + (String)object;
        }
        if ((object = string == null ? fileObject : fileObject.getFileObject(string)) == null) {
            try {
                object = FileUtil.createFolder((FileObject)fileObject, (String)string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return object;
    }
}

