/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.TemplatesPanelGUI;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.AsyncGUIJob;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class TemplatesPanel
implements WizardDescriptor.Panel {
    private ArrayList<ChangeListener> listeners;
    private TemplatesPanelGUI panel;
    private WarmupJob warmUp;
    private boolean warmUpActive;
    private boolean needsReselect = false;

    public void readSettings(Object object) {
        TemplateWizard templateWizard = (TemplateWizard)object;
        templateWizard.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(0));
        templateWizard.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getBundle(TemplatesPanel.class).getString("LBL_TemplatesPanel_Name"), NbBundle.getBundle(TemplatesPanel.class).getString("LBL_TemplatesPanel_Dots")});
        FileObject fileObject = (FileObject)templateWizard.getProperty("templatesFolder");
        String string = (String)templateWizard.getProperty("PRESELECT_CATEGORY");
        if (fileObject != null && fileObject.isFolder() && (templateWizard.getTemplate() == null || string != null || this.needsReselect)) {
            String string2 = (String)templateWizard.getProperty("PRESELECT_TEMPLATE");
            String string3 = OpenProjectListSettings.getInstance().getLastSelectedProjectCategory();
            String string4 = OpenProjectListSettings.getInstance().getLastSelectedProjectType();
            String string5 = string2 == null ? (string != null ? null : string4) : (string != null ? string2 : string4);
            TemplatesPanelGUI templatesPanelGUI = (TemplatesPanelGUI)this.getComponent();
            if (this.isWarmUpActive()) {
                WarmupJob warmupJob = this.getWarmUp();
                warmupJob.setTemplatesFolder(fileObject);
                warmupJob.setSelectedCategory(string != null ? string : string3);
                warmupJob.setSelectedTemplate(string5);
            } else {
                templatesPanelGUI.setTemplatesFolder(fileObject);
                templatesPanelGUI.setSelectedCategoryByName(string != null ? string : string3);
                templatesPanelGUI.setSelectedTemplateByName(string5);
            }
        }
        ((WizardDescriptor)object).putProperty("NewProjectWizard_Title", null);
    }

    public void storeSettings(Object object) {
        TemplateWizard templateWizard = (TemplateWizard)object;
        String string = (String)templateWizard.getProperty("PRESELECT_CATEGORY");
        TemplatesPanelGUI templatesPanelGUI = (TemplatesPanelGUI)this.getComponent();
        FileObject fileObject = templatesPanelGUI.getSelectedTemplate();
        if (fileObject != null) {
            try {
                templateWizard.setTemplate(DataObject.find((FileObject)fileObject));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
        }
        if (string == null) {
            String string2 = templatesPanelGUI.getSelectedCategoryName();
            if (string2 != null) {
                OpenProjectListSettings.getInstance().setLastSelectedProjectCategory(string2);
            }
            if ((string2 = templatesPanelGUI.getSelectedTemplateName()) != null) {
                OpenProjectListSettings.getInstance().setLastSelectedProjectType(string2);
            }
            this.needsReselect = false;
        } else {
            this.needsReselect = true;
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(changeListener);
    }

    public boolean isValid() {
        return ((TemplatesPanelGUI)this.getComponent()).getSelectedTemplate() != null;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(TemplatesPanel.class);
    }

    public synchronized Component getComponent() {
        if (this.panel == null) {
            Builder builder = new Builder();
            this.panel = new TemplatesPanelGUI(builder);
            Utilities.attachInitJob((Component)this.panel, (AsyncGUIJob)this.getWarmUp());
            this.warmUpActive = true;
            this.panel.setName(NbBundle.getBundle(TemplatesPanel.class).getString("LBL_TemplatesPanel_Name"));
        }
        return this.panel;
    }

    private synchronized WarmupJob getWarmUp() {
        if (this.warmUp == null) {
            this.warmUp = new WarmupJob();
        }
        return this.warmUp;
    }

    private synchronized boolean isWarmUpActive() {
        return this.warmUpActive;
    }

    private class Builder
    implements TemplatesPanelGUI.Builder {
        private Builder() {
        }

        public Children createCategoriesChildren(DataFolder dataFolder) {
            assert (dataFolder != null) : "Folder cannot be null.";
            return new CategoriesChildren(dataFolder);
        }

        public Children createTemplatesChildren(DataFolder dataFolder) {
            return new TemplateChildren(dataFolder);
        }

        public String getCategoriesName() {
            return NbBundle.getMessage(TemplatesPanel.class, (String)"CTL_Categories");
        }

        public String getTemplatesName() {
            return NbBundle.getMessage(TemplatesPanel.class, (String)"CTL_Projects");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireChange() {
            Iterator iterator = null;
            Object object = this;
            synchronized (object) {
                if (TemplatesPanel.this.listeners == null) {
                    return;
                }
                iterator = ((ArrayList)TemplatesPanel.this.listeners.clone()).iterator();
            }
            object = new ChangeEvent(this);
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CategoriesChildren
    extends Children.Keys<DataObject> {
        private DataFolder root;

        public CategoriesChildren(DataFolder dataFolder) {
            this.root = dataFolder;
        }

        protected void addNotify() {
            this.setKeys(this.root.getChildren());
        }

        protected void removeNotify() {
            this.setKeys(new DataObject[0]);
        }

        protected Node[] createNodes(DataObject dataObject) {
            if (dataObject instanceof DataFolder) {
                DataFolder dataFolder = (DataFolder)dataObject;
                int n = 0;
                for (DataObject dataObject2 : dataFolder.getChildren()) {
                    n = 1;
                    if (!dataObject2.getPrimaryFile().isFolder()) continue;
                    n = 2;
                    break;
                }
                if (n == 1) {
                    return new Node[]{new FilterNode(dataObject.getNodeDelegate(), Children.LEAF)};
                }
                if (n == 2) {
                    return new Node[]{new FilterNode(dataObject.getNodeDelegate(), (Children)new CategoriesChildren((DataFolder)dataObject))};
                }
            }
            return new Node[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TemplateChildren
    extends Children.Keys<DataObject> {
        private DataFolder folder;

        public TemplateChildren(DataFolder dataFolder) {
            this.folder = dataFolder;
        }

        protected void addNotify() {
            this.setKeys(this.folder.getChildren());
        }

        protected void removeNotify() {
            this.setKeys(new DataObject[0]);
        }

        protected Node[] createNodes(DataObject dataObject) {
            if (dataObject.isTemplate()) {
                return new Node[]{new FilterNode(dataObject.getNodeDelegate(), Children.LEAF)};
            }
            return new Node[0];
        }
    }

    private class WarmupJob
    implements AsyncGUIJob {
        private FileObject templatesFolder;
        private String category;
        private String template;

        private WarmupJob() {
        }

        public void construct() {
            TemplatesPanel.this.panel.warmUp(this.templatesFolder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            Cursor cursor = null;
            try {
                cursor = TemplatesPanel.this.panel.getCursor();
                TemplatesPanel.this.panel.setCursor(Cursor.getPredefinedCursor(3));
                TemplatesPanel.this.panel.doFinished(this.templatesFolder, this.category, this.template);
            }
            finally {
                if (cursor != null) {
                    TemplatesPanel.this.panel.setCursor(cursor);
                }
                TemplatesPanel templatesPanel = TemplatesPanel.this;
                synchronized (templatesPanel) {
                    TemplatesPanel.this.warmUpActive = false;
                }
            }
        }

        void setTemplatesFolder(FileObject fileObject) {
            this.templatesFolder = fileObject;
        }

        void setSelectedCategory(String string) {
            this.category = string;
        }

        void setSelectedTemplate(String string) {
            this.template = string;
        }
    }
}

