/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveConfigAction
extends CallableSystemAction
implements ContextAwareAction {
    private static final Logger LOGGER = Logger.getLogger(ActiveConfigAction.class.getName());
    private static final DefaultComboBoxModel EMPTY_MODEL = new DefaultComboBoxModel();
    private static final Object CUSTOMIZE_ENTRY = new Object();
    private final PropertyChangeListener lst;
    private final JComboBox configListCombo;
    private boolean listeningToCombo = true;
    private Project currentProject;
    private ProjectConfigurationProvider pcp;
    private JPanel toolbarPanel;

    public ActiveConfigAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.configListCombo = new JComboBox();
        this.configListCombo.setRenderer(new ConfigCellRenderer());
        this.configListCombo.setToolTipText(Actions.cutAmpersand((String)this.getName()));
        this.configurationsListChanged(null);
        this.configListCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ActiveConfigAction.this.listeningToCombo) {
                    return;
                }
                Object object = ActiveConfigAction.this.configListCombo.getSelectedItem();
                if (object == CUSTOMIZE_ENTRY) {
                    ActiveConfigAction.this.activeConfigurationChanged(ActiveConfigAction.this.pcp != null ? ActiveConfigAction.getActiveConfiguration(ActiveConfigAction.this.pcp) : null);
                    ActiveConfigAction.this.pcp.customize();
                } else if (object != null) {
                    ActiveConfigAction.this.activeConfigurationSelected((ProjectConfiguration)object);
                }
            }
        });
        this.lst = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("configurations".equals(propertyChangeEvent.getPropertyName())) {
                    ActiveConfigAction.this.configurationsListChanged(ActiveConfigAction.getConfigurations(ActiveConfigAction.this.pcp));
                } else if ("activeConfiguration".equals(propertyChangeEvent.getPropertyName())) {
                    ActiveConfigAction.this.activeConfigurationChanged(ActiveConfigAction.getActiveConfiguration(ActiveConfigAction.this.pcp));
                }
            }
        };
        this.activeProjectChanged(OpenProjectList.getDefault().getMainProject());
        OpenProjectList.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("MainProject".equals(propertyChangeEvent.getPropertyName())) {
                    ActiveConfigAction.this.activeProjectChanged(OpenProjectList.getDefault().getMainProject());
                }
            }
        });
    }

    private synchronized void configurationsListChanged(Collection<? extends ProjectConfiguration> collection) {
        Serializable serializable;
        LOGGER.log(Level.FINER, "configurationsListChanged: {0}", collection);
        if (collection == null) {
            this.configListCombo.setModel(EMPTY_MODEL);
            this.configListCombo.setEnabled(false);
        } else {
            serializable = new DefaultComboBoxModel<Object>(collection.toArray());
            if (this.pcp.hasCustomizer()) {
                ((DefaultComboBoxModel)serializable).addElement((Object)CUSTOMIZE_ENTRY);
            }
            this.configListCombo.setModel(serializable);
            this.configListCombo.setEnabled(true);
            if (null != this.toolbarPanel) {
                this.toolbarPanel.setVisible(true);
            }
        }
        if (null != this.toolbarPanel && null != this.toolbarPanel.getParent()) {
            serializable = this.toolbarPanel.getParent();
            ((Container)serializable).invalidate();
            ((Component)serializable).repaint();
        }
        if (this.pcp != null) {
            this.activeConfigurationChanged(ActiveConfigAction.getActiveConfiguration(this.pcp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void activeConfigurationChanged(ProjectConfiguration projectConfiguration) {
        block4: {
            LOGGER.log(Level.FINER, "activeConfigurationChanged: {0}", projectConfiguration);
            this.listeningToCombo = false;
            try {
                this.configListCombo.setSelectedIndex(-1);
                if (projectConfiguration == null) break block4;
                ComboBoxModel comboBoxModel = this.configListCombo.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    if (!projectConfiguration.equals(comboBoxModel.getElementAt(i))) continue;
                    this.configListCombo.setSelectedIndex(i);
                    break;
                }
            }
            finally {
                this.listeningToCombo = true;
            }
        }
    }

    private synchronized void activeConfigurationSelected(ProjectConfiguration projectConfiguration) {
        LOGGER.log(Level.FINER, "activeConfigurationSelected: {0}", projectConfiguration);
        if (this.pcp != null && projectConfiguration != null && !projectConfiguration.equals(ActiveConfigAction.getActiveConfiguration(this.pcp))) {
            try {
                ActiveConfigAction.setActiveConfiguration(this.pcp, projectConfiguration);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ActiveConfigAction.class);
    }

    public String getName() {
        return NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.label");
    }

    public void performAction() {
        assert (false);
    }

    public Component getToolbarPresenter() {
        this.toolbarPanel = new JPanel(new GridBagLayout());
        this.toolbarPanel.setOpaque(false);
        this.toolbarPanel.setMaximumSize(new Dimension(150, 80));
        this.toolbarPanel.setMinimumSize(new Dimension(150, 0));
        this.toolbarPanel.setPreferredSize(new Dimension(150, 23));
        this.toolbarPanel.add((Component)this.configListCombo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(1, 6, 1, 5), 0, 0));
        this.toolbarPanel.setEnabled(this.configListCombo.getItemCount() > 0);
        return this.toolbarPanel;
    }

    public JMenuItem getMenuPresenter() {
        return new ConfigMenu(null);
    }

    private synchronized void activeProjectChanged(Project project) {
        LOGGER.log(Level.FINER, "activeProjectChanged: {0} -> {1}", new Object[]{this.currentProject, project});
        if (this.currentProject != project) {
            if (this.pcp != null) {
                this.pcp.removePropertyChangeListener(this.lst);
            }
            this.currentProject = project;
            if (this.currentProject != null) {
                this.pcp = (ProjectConfigurationProvider)this.currentProject.getLookup().lookup(ProjectConfigurationProvider.class);
                if (this.pcp != null) {
                    this.pcp.addPropertyChangeListener(this.lst);
                }
            } else {
                this.pcp = null;
            }
            this.configurationsListChanged(this.pcp == null ? null : ActiveConfigAction.getConfigurations(this.pcp));
        }
    }

    public Action createContextAwareInstance(final Lookup lookup) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A
        extends AbstractAction
        implements Presenter.Popup {
            A() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                assert (false);
            }

            public JMenuItem getPopupPresenter() {
                return new ConfigMenu(lookup);
            }
        }
        return new A();
    }

    private static Collection<? extends ProjectConfiguration> getConfigurations(final ProjectConfigurationProvider<?> projectConfigurationProvider) {
        return (Collection)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Collection<? extends ProjectConfiguration>>(){

            public Collection<? extends ProjectConfiguration> run() {
                return projectConfigurationProvider.getConfigurations();
            }
        });
    }

    private static ProjectConfiguration getActiveConfiguration(final ProjectConfigurationProvider<?> projectConfigurationProvider) {
        return (ProjectConfiguration)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ProjectConfiguration>(){

            public ProjectConfiguration run() {
                return projectConfigurationProvider.getActiveConfiguration();
            }
        });
    }

    private static void setActiveConfiguration(ProjectConfigurationProvider<?> projectConfigurationProvider, final ProjectConfiguration projectConfiguration) throws IOException {
        final ProjectConfigurationProvider<?> projectConfigurationProvider2 = projectConfigurationProvider;
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    projectConfigurationProvider2.setActiveConfiguration(projectConfiguration);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private static class ConfigCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private Border defaultBorder = this.getBorder();

        public ConfigCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            String string = null;
            if (object instanceof ProjectConfiguration) {
                string = ((ProjectConfiguration)object).getDisplayName();
                this.setBorder(this.defaultBorder);
            } else if (object == CUSTOMIZE_ENTRY) {
                string = Actions.cutAmpersand((String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.customize"));
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlDkShadow")), this.defaultBorder));
            } else {
                assert (object == null);
                string = null;
                this.setBorder(this.defaultBorder);
            }
            this.setText(string);
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    class ConfigMenu
    extends JMenu
    implements DynamicMenuContent {
        private final Lookup context;

        public ConfigMenu(Lookup lookup) {
            this.context = lookup;
            if (lookup != null) {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.context.label"));
            } else {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)ActiveConfigAction.this.getName());
            }
        }

        public JComponent[] getMenuPresenters() {
            Collection collection;
            this.removeAll();
            Object object = this.context != null ? ((collection = this.context.lookupAll(Project.class)).size() == 1 ? (ProjectConfigurationProvider)((Project)collection.iterator().next()).getLookup().lookup(ProjectConfigurationProvider.class) : null) : ActiveConfigAction.this.pcp;
            if (object != null) {
                boolean bl = false;
                ProjectConfiguration projectConfiguration = ActiveConfigAction.getActiveConfiguration(object);
                for (final ProjectConfiguration projectConfiguration2 : ActiveConfigAction.getConfigurations(object)) {
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(projectConfiguration2.getDisplayName(), projectConfiguration2.equals(projectConfiguration));
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ActiveConfigAction.this.activeConfigurationSelected(projectConfiguration2);
                        }
                    });
                    this.add(jRadioButtonMenuItem);
                    bl = true;
                }
                if (object.hasCustomizer()) {
                    if (bl) {
                        this.addSeparator();
                    }
                    bl = true;
                    JMenuItem jMenuItem = new JMenuItem();
                    Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.customize"));
                    jMenuItem.addActionListener(new ActionListener((ProjectConfigurationProvider)object){
                        final /* synthetic */ ProjectConfigurationProvider val$pcp;
                        {
                            this.val$pcp = projectConfigurationProvider;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            this.val$pcp.customize();
                        }
                    });
                    this.add(jMenuItem);
                }
                this.setEnabled(bl);
            } else {
                this.setEnabled(false);
            }
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return this.getMenuPresenters();
        }
    }
}

