/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class CloseProject
extends ProjectAction
implements PropertyChangeListener,
Presenter.Popup {
    private static final String namePattern = NbBundle.getMessage(CloseProject.class, (String)"LBL_CloseProjectAction_Name");
    private static final String namePatternPopup = NbBundle.getMessage(CloseProject.class, (String)"LBL_CloseProjectAction_Popup_Name");
    private String popupName;
    private PropertyChangeListener wpcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault());

    public CloseProject() {
        this((Lookup)null);
    }

    public CloseProject(Lookup lookup) {
        super((String)null, namePattern, null, lookup);
        OpenProjectList.getDefault().addPropertyChangeListener(this.wpcl);
        this.refresh(this.getLookup());
    }

    protected void actionPerformed(Lookup lookup) {
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, null);
        OpenProjectList.getDefault().close(projectArray, true);
    }

    public void refresh(Lookup lookup) {
        super.refresh(lookup);
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, null);
        if (projectArray.length == 0 || !OpenProjectList.getDefault().isOpen(projectArray[0])) {
            this.setEnabled(false);
            this.popupName = ActionsUtil.formatProjectSensitiveName(namePatternPopup, new Project[0]);
        } else {
            this.setEnabled(true);
            this.popupName = ActionsUtil.formatProjectSensitiveName(namePatternPopup, projectArray);
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new CloseProject(lookup);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.refresh(this.getLookup());
    }

    public JMenuItem getPopupPresenter() {
        JMenuItem jMenuItem = new JMenuItem(this);
        jMenuItem.setIcon(null);
        jMenuItem.setText(this.popupName);
        return jMenuItem;
    }
}

