/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.NoMainProjectWarning;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Actions;
import org.openide.awt.MouseUtils;
import org.openide.awt.ToolbarPool;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public class MainProjectAction
extends BasicAction
implements Presenter.Toolbar,
PropertyChangeListener {
    private String command;
    private ProjectActionPerformer performer;
    private String name;
    private static final boolean SHOW_CONFIG_DROPDOWN = Boolean.getBoolean("org.netbeans.modules.project.ui.actions.MainProjectAction.SHOW_CONFIG_DROPDOWN");
    private static final String PREFERRED_ICON_SIZE = "PreferredIconSize";

    public MainProjectAction(ProjectActionPerformer projectActionPerformer, String string, Icon icon) {
        this(null, projectActionPerformer, string, icon);
    }

    public MainProjectAction(String string, String string2, Icon icon) {
        this(string, null, string2, icon);
    }

    public MainProjectAction(String string, ProjectActionPerformer projectActionPerformer, String string2, Icon icon) {
        this.command = string;
        this.performer = projectActionPerformer;
        this.name = string2;
        this.setDisplayName(string2);
        if (icon != null) {
            this.setSmallIcon(icon);
        }
        this.refreshView();
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Project project = OpenProjectList.getDefault().getMainProject();
        if (project == null) {
            if (this.showNoMainProjectWarning(OpenProjectList.getDefault().getOpenProjects(), this.name)) {
                return;
            }
            project = OpenProjectList.getDefault().getMainProject();
        }
        if (this.command != null) {
            ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
            if (Arrays.asList(actionProvider.getSupportedActions()).contains(this.command)) {
                actionProvider.invokeAction(this.command, Lookup.EMPTY);
            } else {
                Toolkit.getDefaultToolkit().beep();
                this.refreshView();
            }
        } else {
            this.performer.perform(project);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "MainProject" || propertyChangeEvent.getPropertyName() == "OpenProjects") {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    MainProjectAction.this.refreshView();
                }
            });
        }
    }

    private void refreshView() {
        boolean bl;
        Project project = OpenProjectList.getDefault().getMainProject();
        boolean bl2 = bl = OpenProjectList.getDefault().getOpenProjects().length == 0;
        if (this.command == null) {
            this.setEnabled(this.performer.enable(project));
        } else if (project == null) {
            this.setEnabled(!bl);
        } else if (ActionsUtil.commandSupported(project, this.command, Lookup.EMPTY)) {
            this.setEnabled(!bl);
        } else {
            this.setEnabled(false);
        }
    }

    private boolean showNoMainProjectWarning(Project[] projectArray, String string) {
        boolean bl;
        final JButton jButton = new JButton(NbBundle.getMessage(NoMainProjectWarning.class, (String)"LBL_NoMainClassWarning_ChooseMainProject_OK"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NoMainProjectWarning.class, (String)"AD_NoMainClassWarning_ChooseMainProject_OK"));
        final NoMainProjectWarning noMainProjectWarning = new NoMainProjectWarning(projectArray);
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        noMainProjectWarning.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)changeEvent.getSource()))) {
                    if (noMainProjectWarning.getSelectedProject() != null) {
                        jButton.doClick();
                    }
                } else {
                    jButton.setEnabled(noMainProjectWarning.getSelectedProject() != null);
                }
            }
        });
        jButton.setEnabled(noMainProjectWarning.getSelectedProject() != null);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)noMainProjectWarning, string == null ? NbBundle.getMessage(NoMainProjectWarning.class, (String)"CTL_NoMainProjectWarning_Title") : Actions.cutAmpersand((String)string), true, objectArray, objectArray[0], 0, null, null);
        dialogDescriptor.setMessageType(1);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != objectArray[0]) {
            bl = true;
        } else {
            Project project = noMainProjectWarning.getSelectedProject();
            OpenProjectList.getDefault().setMainProject(project);
            bl = false;
        }
        dialog.dispose();
        return bl;
    }

    public Component getToolbarPresenter() {
        final JButton jButton = new JButton();
        Actions.connect((AbstractButton)jButton, (Action)this);
        if (!SHOW_CONFIG_DROPDOWN) {
            return jButton;
        }
        final JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.addPropertyChangeListener(PREFERRED_ICON_SIZE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jButton.putClientProperty(MainProjectAction.PREFERRED_ICON_SIZE, jPanel.getClientProperty(MainProjectAction.PREFERRED_ICON_SIZE));
            }
        });
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)jButton, "Center");
        ConfigButton configButton = new ConfigButton(jButton.getPreferredSize().height);
        jPanel.add((Component)configButton, "After");
        return jPanel;
    }

    private static final class ArrowIcon
    implements Icon {
        private static final int SIZE = 6;
        private static final int HEIGHT = ToolbarPool.getDefault().getPreferredIconSize();
        private static final int PAD = 3;

        private ArrowIcon() {
        }

        public int getIconWidth() {
            return 17;
        }

        public int getIconHeight() {
            return Math.max(12, HEIGHT);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.BLACK);
            int n3 = 3;
            int n4 = (graphics.getClipBounds().height - 6) / 2;
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.fillPolygon(new int[]{n3, n3 + 12 - 2, n3 + 6 - 1}, new int[]{n4, n4, n4 + 6 - 1}, 3);
        }
    }

    private final class ConfigButton
    extends JButton
    implements PropertyChangeListener,
    ActionListener {
        private final PropertyChangeListener pcl;
        private JPopupMenu menu;

        public ConfigButton(int n) {
            super(new ArrowIcon());
            this.pcl = WeakListeners.propertyChange((PropertyChangeListener)this, null);
            OpenProjectList.getDefault().addPropertyChangeListener(this.pcl);
            this.propertyChange(null);
            this.addActionListener(this);
            this.setPreferredSize(new Dimension(this.getIcon().getIconWidth(), n));
            this.setFocusPainted(false);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string;
            String string2 = string = propertyChangeEvent != null ? propertyChangeEvent.getPropertyName() : null;
            if (string == null || string.equals("MainProject") || string.equals("configurations")) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        ProjectConfigurationProvider projectConfigurationProvider;
                        ActionProvider actionProvider;
                        boolean bl = false;
                        Project project = OpenProjectList.getDefault().getMainProject();
                        if (project != null && (actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class)) != null && Arrays.asList(actionProvider.getSupportedActions()).contains(MainProjectAction.this.command) && (projectConfigurationProvider = (ProjectConfigurationProvider)project.getLookup().lookup(ProjectConfigurationProvider.class)) != null) {
                            projectConfigurationProvider.removePropertyChangeListener(ConfigButton.this.pcl);
                            projectConfigurationProvider.addPropertyChangeListener(ConfigButton.this.pcl);
                            bl = projectConfigurationProvider.configurationsAffectAction(MainProjectAction.this.command) && projectConfigurationProvider.getConfigurations().size() > 1;
                        }
                        ConfigButton.this.setVisible(bl);
                    }
                });
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.menu != null) {
                this.menu.setVisible(false);
                this.menu = null;
                return;
            }
            final Project project = OpenProjectList.getDefault().getMainProject();
            ProjectConfigurationProvider projectConfigurationProvider = (ProjectConfigurationProvider)project.getLookup().lookup(ProjectConfigurationProvider.class);
            this.menu = new JPopupMenu();
            for (final ProjectConfiguration projectConfiguration : projectConfigurationProvider.getConfigurations()) {
                JMenuItem jMenuItem = new JMenuItem(projectConfiguration.getDisplayName());
                this.menu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ConfigButton.this.menu = null;
                        ((ActionProvider)project.getLookup().lookup(ActionProvider.class)).invokeAction(MainProjectAction.this.command, Lookups.singleton((Object)projectConfiguration));
                    }
                });
            }
            this.menu.show(this, 0, this.getSize().height);
        }
    }
}

