/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ui.NewProjectWizard;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class NewProject
extends BasicAction {
    private static final Icon ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/newProject.gif"));
    private static final String NAME = NbBundle.getMessage(NewProject.class, (String)"LBL_NewProjectAction_Name");
    private static final String _SHORT_DESCRIPTION = NbBundle.getMessage(NewProject.class, (String)"LBL_NewProjectAction_Tooltip");
    private boolean isPreselect = false;
    private RequestProcessor.Task bodyTask;

    public NewProject() {
        super(NAME, ICON);
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/newProject.gif");
        this.putValue("ShortDescription", _SHORT_DESCRIPTION);
        this.bodyTask = new RequestProcessor("NewProjectBody").create(new Runnable(){

            public void run() {
                NewProject.this.doPerform();
            }
        });
    }

    public static NewProject newSample() {
        NewProject newProject = new NewProject();
        newProject.setDisplayName("New Sample");
        newProject.isPreselect = true;
        return newProject;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.bodyTask.schedule(0);
        if ("waitFinished".equals(actionEvent.getActionCommand())) {
            this.bodyTask.waitFinished();
        }
    }

    NewProjectWizard prepareWizardDescriptor(FileObject fileObject) {
        NewProjectWizard newProjectWizard = new NewProjectWizard(fileObject);
        if (this.isPreselect) {
            newProjectWizard.putProperty("PRESELECT_CATEGORY", this.getValue("PRESELECT_CATEGORY"));
            newProjectWizard.putProperty("PRESELECT_TEMPLATE", this.getValue("PRESELECT_TEMPLATE"));
        } else {
            newProjectWizard.putProperty("PRESELECT_CATEGORY", null);
            newProjectWizard.putProperty("PRESELECT_TEMPLATE", null);
        }
        FileObject fileObject2 = (FileObject)this.getValue("existingSourcesFolder");
        if (fileObject2 != null) {
            newProjectWizard.putProperty("existingSourcesFolder", fileObject2);
        }
        return newProjectWizard;
    }

    private void doPerform() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Project");
        final NewProjectWizard newProjectWizard = this.prepareWizardDescriptor(fileObject);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Set set = newProjectWizard.instantiate();
                    Object object = newProjectWizard.getProperty("setAsMain");
                    boolean bl = true;
                    if (object instanceof Boolean) {
                        bl = (Boolean)object;
                    }
                    boolean bl2 = bl;
                    ProjectManager.getDefault().clearNonProjectCache();
                    ProjectUtilities.WaitCursor.show();
                    if (set != null && !set.isEmpty()) {
                        LinkedList<DataObject> linkedList = new LinkedList<DataObject>();
                        LinkedList<Project> linkedList2 = new LinkedList<Project>();
                        for (Object object2 : set) {
                            FileObject fileObject;
                            DataObject dataObject;
                            block19: {
                                if (object2 instanceof DataObject) {
                                    dataObject = (DataObject)object2;
                                    fileObject = dataObject.getPrimaryFile();
                                } else {
                                    if (object2 instanceof FileObject) {
                                        fileObject = (FileObject)object2;
                                        try {
                                            dataObject = DataObject.find((FileObject)fileObject);
                                            break block19;
                                        }
                                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                                            ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
                                            continue;
                                        }
                                    }
                                    ErrorManager.getDefault().log(16, "Found unrecognized object " + object2 + " in result set from instantiate()");
                                    continue;
                                }
                            }
                            if (fileObject.isFolder()) {
                                try {
                                    Project project = ProjectManager.getDefault().findProject(fileObject);
                                    if (project != null) {
                                        linkedList2.add(project);
                                        continue;
                                    }
                                    linkedList.add(dataObject);
                                }
                                catch (IOException iOException) {
                                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                                }
                                continue;
                            }
                            linkedList.add(dataObject);
                        }
                        Iterator iterator = linkedList2.size() > 0 ? (Project)linkedList2.get(0) : null;
                        OpenProjectList.getDefault().open(linkedList2.toArray(new Project[0]), false, true);
                        if (bl2 && iterator != null) {
                            OpenProjectList.getDefault().setMainProject((Project)iterator);
                        }
                        if (!Boolean.getBoolean("project.tab.no.selection")) {
                            ProjectUtilities.makeProjectTabVisible(true);
                        }
                        if (linkedList.isEmpty() && iterator != null) {
                            ProjectUtilities.selectAndExpandProject(iterator);
                        } else {
                            Object object2;
                            object2 = linkedList.iterator();
                            while (object2.hasNext()) {
                                ProjectUtilities.openAndSelectNewObject((DataObject)object2.next());
                            }
                        }
                    }
                    ProjectUtilities.WaitCursor.hide();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        });
    }
}

