/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.openide.ErrorManager;
import org.openide.awt.DynamicMenuContent;
import org.openide.loaders.DataFolder;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public final class OpenProjectFolderAction
extends AbstractAction
implements ContextAwareAction {
    public OpenProjectFolderAction() {
        super(NbBundle.getMessage(OpenProjectFolderAction.class, (String)"OpenProjectFolderAction.LBL_action"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAction(lookup);
    }

    private final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private final Set<Project> projects = new HashSet<Project>();

        public ContextAction(Lookup lookup) {
            for (Object object : lookup.lookupAll(DataFolder.class)) {
                Project project = null;
                try {
                    project = ProjectManager.getDefault().findProject(object.getPrimaryFile());
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
                if (project == null) continue;
                this.projects.add(project);
            }
            this.projects.removeAll(Arrays.asList(OpenProjectList.getDefault().getOpenProjects()));
            int n = this.projects.size();
            if (n == 1) {
                Object object;
                object = ProjectUtils.getInformation((Project)this.projects.iterator().next()).getDisplayName();
                this.putValue("Name", NbBundle.getMessage(OpenProjectFolderAction.class, (String)"OpenProjectFolderAction.LBL_menu_one", (Object)object));
            } else if (n > 1) {
                this.putValue("Name", NbBundle.getMessage(OpenProjectFolderAction.class, (String)"OpenProjectFolderAction.LBL_menu_multiple", (Object)new Integer(n)));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    OpenProjectList.getDefault().open(ContextAction.this.projects.toArray(new Project[ContextAction.this.projects.size()]), false, true);
                }
            });
        }

        public JMenuItem getPopupPresenter() {
            class Presenter
            extends JMenuItem
            implements DynamicMenuContent {
                public Presenter() {
                    super(ContextAction.this);
                }

                public JComponent[] getMenuPresenters() {
                    if (!ContextAction.this.projects.isEmpty()) {
                        return new JComponent[]{this, null};
                    }
                    return new JComponent[0];
                }

                public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
                    return this.getMenuPresenters();
                }
            }
            return new Presenter();
        }
    }
}

