/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;

public class ProjectAction
extends LookupSensitiveAction
implements Presenter.Menu,
ContextAwareAction {
    private String command;
    private ProjectActionPerformer performer;
    private String namePattern;
    private String presenterName;
    private JMenuItem menuPresenter;

    public ProjectAction(String string, String string2, Icon icon, Lookup lookup) {
        this(string, null, string2, icon, lookup);
    }

    public ProjectAction(ProjectActionPerformer projectActionPerformer, String string, Icon icon, Lookup lookup) {
        this(null, projectActionPerformer, string, icon, lookup);
    }

    private ProjectAction(String string, ProjectActionPerformer projectActionPerformer, String string2, Icon icon, Lookup lookup) {
        super(icon, lookup, new Class[]{Project.class, DataObject.class});
        this.command = string;
        if (string != null) {
            ActionsUtil.SHORCUTS_MANAGER.registerAction(string, this);
        }
        this.performer = projectActionPerformer;
        this.namePattern = string2;
        this.presenterName = ActionsUtil.formatName(this.getNamePattern(), 0, "");
        this.setDisplayName(this.presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)this.presenterName));
    }

    public void putValue(String string, Object object) {
        super.putValue(string, object);
        if (string == "AcceleratorKey") {
            ActionsUtil.SHORCUTS_MANAGER.registerShortcut(this.command, object);
            if (this.menuPresenter != null) {
                this.menuPresenter.setAccelerator((KeyStroke)object);
            }
        }
    }

    protected void actionPerformed(Lookup lookup) {
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, this.command);
        if (projectArray.length == 1) {
            if (this.command != null) {
                ActionProvider actionProvider = (ActionProvider)projectArray[0].getLookup().lookup(ActionProvider.class);
                actionProvider.invokeAction(this.command, Lookup.EMPTY);
            } else if (this.performer != null) {
                this.performer.perform(projectArray[0]);
            }
        }
    }

    protected void refresh(Lookup lookup) {
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, this.command);
        if (this.command != null) {
            this.setEnabled(projectArray.length == 1);
            this.presenterName = ActionsUtil.formatProjectSensitiveName(this.namePattern, projectArray);
        } else if (this.performer != null && projectArray.length == 1) {
            this.setEnabled(this.performer.enable(projectArray[0]));
            this.presenterName = ActionsUtil.formatProjectSensitiveName(this.namePattern, projectArray);
        } else {
            this.setEnabled(false);
            this.presenterName = ActionsUtil.formatProjectSensitiveName(this.namePattern, projectArray);
        }
        this.setLocalizedTextToMenuPresented(this.presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)this.presenterName));
    }

    protected final String getCommand() {
        return this.command;
    }

    protected final String getNamePattern() {
        return this.namePattern;
    }

    protected final void setLocalizedTextToMenuPresented(String string) {
        if (this.menuPresenter != null) {
            Mnemonics.setLocalizedText((AbstractButton)this.menuPresenter, (String)string);
        }
    }

    public JMenuItem getMenuPresenter() {
        if (this.menuPresenter == null) {
            this.menuPresenter = new JMenuItem(this);
            Icon icon = null;
            if (!Boolean.TRUE.equals(this.getValue("noIconInMenu"))) {
                icon = (Icon)this.getValue("SmallIcon");
            }
            this.menuPresenter.setIcon(icon);
            Mnemonics.setLocalizedText((AbstractButton)this.menuPresenter, (String)this.presenterName);
        }
        return this.menuPresenter;
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ProjectAction(this.command, this.performer, this.namePattern, (Icon)this.getValue("SmallIcon"), lookup);
    }
}

