/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.actions.CloseProject;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public class SelectNodeAction
extends LookupSensitiveAction
implements Presenter.Menu,
Presenter.Popup {
    private static final Icon SELECT_IN_PROJECTS_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/projectTab.gif"));
    private static final Icon SELECT_IN_FILES_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/filesTab.gif"));
    private static final String SELECT_IN_PROJECTS_NAME = NbBundle.getMessage(CloseProject.class, (String)"LBL_SelectInProjectsAction_Name");
    private static final String SELECT_IN_FILES_NAME = NbBundle.getMessage(CloseProject.class, (String)"LBL_SelectInFilesAction_Name");
    private static final String SELECT_IN_PROJECTS_NAME_MENU = NbBundle.getMessage(CloseProject.class, (String)"LBL_SelectInProjectsAction_MenuName");
    private static final String SELECT_IN_FILES_NAME_MENU = NbBundle.getMessage(CloseProject.class, (String)"LBL_SelectInFilesAction_MenuName");
    private static final String SELECT_IN_PROJECTS_NAME_MAIN_MENU = NbBundle.getMessage(CloseProject.class, (String)"LBL_SelectInProjectsAction_MainMenuName");
    private static final String SELECT_IN_FILES_NAME_MAIN_MENU = NbBundle.getMessage(CloseProject.class, (String)"LBL_SelectInFilesAction_MainMenuName");
    private String command;
    private ProjectActionPerformer performer;
    private String namePattern;
    private String findIn;

    public static Action inProjects() {
        SelectNodeAction selectNodeAction = new SelectNodeAction(SELECT_IN_PROJECTS_ICON, SELECT_IN_PROJECTS_NAME);
        selectNodeAction.findIn = "projectTabLogical_tc";
        return selectNodeAction;
    }

    public static Action inFiles() {
        SelectNodeAction selectNodeAction = new SelectNodeAction(SELECT_IN_FILES_ICON, SELECT_IN_FILES_NAME);
        selectNodeAction.findIn = "projectTab_tc";
        return selectNodeAction;
    }

    public SelectNodeAction(Icon icon, String string) {
        super(icon, null, new Class[]{DataObject.class, FileObject.class});
        this.setDisplayName(string);
    }

    private SelectNodeAction(String string, ProjectActionPerformer projectActionPerformer, String string2, Icon icon, Lookup lookup) {
        super(icon, lookup, new Class[]{Project.class, DataObject.class, FileObject.class});
        this.command = string;
        this.performer = projectActionPerformer;
        this.namePattern = string2;
        this.refresh(this.getLookup());
    }

    protected void actionPerformed(Lookup lookup) {
        FileObject fileObject = this.getFileFromLookup(lookup);
        if (fileObject != null) {
            ProjectTab projectTab = ProjectTab.findDefault(this.findIn);
            projectTab.selectNodeAsync(fileObject);
        }
    }

    protected void refresh(Lookup lookup) {
        FileObject fileObject = this.getFileFromLookup(lookup);
        this.setEnabled(fileObject != null);
    }

    protected final String getCommand() {
        return this.command;
    }

    protected final String getNamePattern() {
        return this.namePattern;
    }

    public JMenuItem getMenuPresenter() {
        if ("projectTabLogical_tc".equals(this.findIn)) {
            return this.buildPresenter(SELECT_IN_PROJECTS_NAME_MAIN_MENU);
        }
        return this.buildPresenter(SELECT_IN_FILES_NAME_MAIN_MENU);
    }

    public JMenuItem getPopupPresenter() {
        if ("projectTabLogical_tc".equals(this.findIn)) {
            return this.buildPresenter(SELECT_IN_PROJECTS_NAME_MENU);
        }
        return this.buildPresenter(SELECT_IN_FILES_NAME_MENU);
    }

    private FileObject getFileFromLookup(Lookup lookup) {
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        if (fileObject != null) {
            return fileObject;
        }
        DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
        return dataObject == null ? null : dataObject.getPrimaryFile();
    }

    private JMenuItem buildPresenter(String string) {
        JMenuItem jMenuItem = new JMenuItem(this);
        jMenuItem.setText(string);
        jMenuItem.setIcon(null);
        return jMenuItem;
    }
}

