/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.groups.AdHocGroupEditPanel;
import org.netbeans.modules.project.ui.groups.AdHocGroupEditPanelBasic;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.openide.filesystems.FileStateInvalidException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdHocGroup
extends Group {
    private static final Logger LOG = Logger.getLogger(AdHocGroup.class.getName());
    private static final String KEY_AUTO_SYNCH = "autoSynch";
    static final String KIND = "adHoc";

    public static AdHocGroup create(String string, boolean bl) {
        String string2 = AdHocGroup.sanitizeNameAndUniquifyForId(string);
        LOG.log(Level.FINE, "Creating: {0}", string2);
        Preferences preferences = NODE.node(string2);
        preferences.put("name", string);
        preferences.put("kind", KIND);
        preferences.putBoolean(KEY_AUTO_SYNCH, bl);
        return new AdHocGroup(string2);
    }

    AdHocGroup(String string) {
        super(string);
    }

    @Override
    protected void findProjects(Set<Project> set, ProgressHandle progressHandle, int n, int n2) {
        String string = this.prefs().get("path", "");
        if (string.length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(" ")) {
                Project project = AdHocGroup.projectForPath(string2);
                if (project == null) continue;
                if (progressHandle != null) {
                    n += (n2 - n) / stringArray.length;
                    progressHandle.progress(AdHocGroup.progressMessage(project), n);
                }
                set.add(project);
            }
        }
    }

    public void setProjects(Set<Project> set) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Project project : set) {
            try {
                treeSet.add(project.getProjectDirectory().getURL().toExternalForm());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                LOG.log(Level.WARNING, null, fileStateInvalidException);
            }
        }
        this.prefs().put("path", AdHocGroup.joinPaths(treeSet));
        LOG.log(Level.FINE, "updating projects for {0} to {1}", new Object[]{this.id, set});
    }

    private static String joinPaths(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : collection) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public boolean isAutoSynch() {
        return this.prefs().getBoolean(KEY_AUTO_SYNCH, false);
    }

    public void setAutoSynch(boolean bl) {
        this.prefs().putBoolean(KEY_AUTO_SYNCH, bl);
    }

    public void synch() {
        OpenProjects openProjects = OpenProjects.getDefault();
        this.setProjects(new HashSet<Project>(Arrays.asList(openProjects.getOpenProjects())));
        this.setMainProject(openProjects.getMainProject());
    }

    @Override
    public GroupEditPanel createPropertiesPanel() {
        return Group.isAdvancedMode() ? new AdHocGroupEditPanel(this) : new AdHocGroupEditPanelBasic(this);
    }

    @Override
    protected void closed() {
        if (this.isAutoSynch()) {
            this.setProjects(new HashSet<Project>(Arrays.asList(OpenProjects.getDefault().getOpenProjects())));
        }
        super.closed();
    }

    @Override
    public boolean isPristine() {
        if (this.isAutoSynch()) {
            return true;
        }
        return super.isPristine();
    }

    @Override
    protected String toString(boolean bl) {
        return super.toString(bl) + (this.isAutoSynch() ? "" : "[!autoSynch]");
    }
}

