/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.groups.AbstractNewGroupPanel;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.netbeans.modules.project.ui.groups.NewGroupPanel;
import org.netbeans.modules.project.ui.groups.NewGroupPanelBasic;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class GroupsMenu
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup {
    private static final RequestProcessor RP = new RequestProcessor(GroupsMenu.class.getName());

    public GroupsMenu() {
        super(NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.label"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (false);
    }

    public JMenuItem getMenuPresenter() {
        return new Menu();
    }

    public JMenuItem getPopupPresenter() {
        return new Menu();
    }

    private static void newGroup() {
        final AbstractNewGroupPanel abstractNewGroupPanel = Group.isAdvancedMode() ? new NewGroupPanel() : new NewGroupPanelBasic();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)abstractNewGroupPanel, NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.new_title"));
        dialogDescriptor.setOptionType(2);
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(GroupsMenu.class));
        final JButton jButton = new JButton(NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.new_create"));
        jButton.setDefaultCapable(true);
        jButton.setEnabled(abstractNewGroupPanel.isReady());
        abstractNewGroupPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("ready".equals(propertyChangeEvent.getPropertyName())) {
                    jButton.setEnabled(abstractNewGroupPanel.isReady());
                }
            }
        });
        JButton jButton2 = new JButton(NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.new_cancel"));
        dialogDescriptor.setOptions(new Object[]{jButton, jButton2});
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object.equals(jButton)) {
            final Group group = abstractNewGroupPanel.create();
            RP.post(new Runnable(){

                public void run() {
                    Group.setActiveGroup(group);
                }
            });
        }
    }

    private static void openProperties(Group group) {
        GroupEditPanel groupEditPanel = group.createPropertiesPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)groupEditPanel, NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.properties_title"));
        dialogDescriptor.setOptionType(2);
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(GroupsMenu.class));
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object.equals(NotifyDescriptor.OK_OPTION)) {
            groupEditPanel.applyChanges();
        }
    }

    private static class Menu
    extends JMenu
    implements DynamicMenuContent {
        Menu() {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.label"));
        }

        public JComponent[] getMenuPresenters() {
            this.removeAll();
            final Group group = Group.getActiveGroup();
            for (final Group group2 : Group.allGroups()) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(group2.getName());
                if (group2.equals(group)) {
                    jRadioButtonMenuItem.setSelected(true);
                    if (group2.isPristine() && Group.isAdvancedMode()) {
                        jRadioButtonMenuItem.setEnabled(false);
                    }
                }
                jRadioButtonMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RP.post(new Runnable(){

                            public void run() {
                                Group.setActiveGroup(group2);
                            }
                        });
                    }
                });
                this.add(jRadioButtonMenuItem);
            }
            Object object = new JRadioButtonMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)object, (String)NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.no_group"));
            if (group == null) {
                ((AbstractButton)object).setSelected(true);
                if (OpenProjects.getDefault().getOpenProjects().length == 0 && Group.isAdvancedMode()) {
                    ((JMenuItem)object).setEnabled(false);
                }
            }
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RP.post(new Runnable(){

                        public void run() {
                            Group.setActiveGroup(null);
                        }
                    });
                }
            });
            this.add((JMenuItem)object);
            this.addSeparator();
            object = new JMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)object, (String)NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.new_group"));
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GroupsMenu.newGroup();
                }
            });
            this.add((JMenuItem)object);
            if (group != null) {
                object = new JMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)object, (String)NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.properties", (Object)group.getName()));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        GroupsMenu.openProperties(group);
                    }
                });
                this.add((JMenuItem)object);
                object = new JMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)object, (String)NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.remove", (Object)group.getName()));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        group.destroy();
                    }
                });
                this.add((JMenuItem)object);
            }
            object = new JCheckBoxMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)object, (String)NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.advanced"));
            ((AbstractButton)object).setSelected(Group.isAdvancedMode());
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Group.setAdvancedMode(!Group.isAdvancedMode());
                }
            });
            this.add((JMenuItem)object);
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return this.getMenuPresenters();
        }
    }
}

