/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.netbeans.modules.project.ui.groups.SubprojectsGroupEditPanel;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubprojectsGroup
extends Group {
    private static final Logger LOG = Logger.getLogger(SubprojectsGroup.class.getName());
    static final String KIND = "subprojects";

    public static SubprojectsGroup create(Project project) throws FileStateInvalidException {
        String string = project.getProjectDirectory().getURL().toExternalForm();
        String string2 = SubprojectsGroup.sanitizeNameAndUniquifyForId(ProjectUtils.getInformation((Project)project).getName());
        LOG.log(Level.FINE, "Creating: {0}", string2);
        Preferences preferences = NODE.node(string2);
        preferences.put("kind", KIND);
        preferences.put("path", string);
        preferences.put("main", string);
        return new SubprojectsGroup(string2);
    }

    SubprojectsGroup(String string) {
        super(string);
    }

    @Override
    protected String getNameOrNull() {
        Project project;
        String string = super.getNameOrNull();
        if (string == null && (project = SubprojectsGroup.projectForPath(this.prefs().get("path", null))) != null) {
            return ProjectUtils.getInformation((Project)project).getDisplayName();
        }
        return string;
    }

    @Override
    protected void findProjects(Set<Project> set, ProgressHandle progressHandle, int n, int n2) {
        Project project = SubprojectsGroup.projectForPath(this.prefs().get("path", null));
        if (project != null) {
            SubprojectsGroup.visitSubprojects(project, set, progressHandle, new int[]{n, n2});
        }
    }

    private static void visitSubprojects(Project project, Set<Project> set, ProgressHandle progressHandle, int[] nArray) {
        if (set.add(project)) {
            SubprojectProvider subprojectProvider;
            if (progressHandle != null) {
                nArray[0] = nArray[0] + 1;
                progressHandle.progress(SubprojectsGroup.progressMessage(project), Math.min(nArray[0], nArray[1]));
            }
            if ((subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class)) != null) {
                for (Project project2 : subprojectProvider.getSubprojects()) {
                    SubprojectsGroup.visitSubprojects(project2, set, progressHandle, nArray);
                }
            }
        }
    }

    public FileObject getMasterProjectDirectory() {
        String string = this.prefs().get("path", null);
        if (string != null && string.length() > 0) {
            try {
                return URLMapper.findFileObject((URL)new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                LOG.log(Level.WARNING, null, malformedURLException);
            }
        }
        return null;
    }

    @Override
    public GroupEditPanel createPropertiesPanel() {
        return new SubprojectsGroupEditPanel(this);
    }
}

