/*
 * Decompiled with CFR 0.152.
 */
package gjava.runner;

import java.applet.AudioClip;

public class TimedAudioClip
implements AudioClip {
    private AudioClip myClip;
    private long myPlayTime;
    private long myDuration;
    private boolean myIsLooping = false;

    public TimedAudioClip(AudioClip clip, long duration) {
        if (clip == null) {
            throw new IllegalArgumentException("null AudioClip passed");
        }
        if (duration < 0L) {
            throw new IllegalArgumentException("negative duration passed");
        }
        this.myClip = clip;
        this.myDuration = duration;
    }

    public TimedAudioClip(AudioClip clip) {
        this(clip, 0L);
    }

    @Override
    public void play() {
        this.myPlayTime = System.currentTimeMillis();
        this.myClip.play();
    }

    @Override
    public void loop() {
        this.myIsLooping = true;
        this.myClip.loop();
    }

    @Override
    public void stop() {
        this.myIsLooping = false;
        this.myClip.stop();
    }

    public void playAndWait() {
        this.play();
        while (this.isPlaying()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
    }

    public AudioClip getClip() {
        return this.myClip;
    }

    public long getDuration() {
        return this.myDuration;
    }

    public boolean isPlaying() {
        return this.myIsLooping || this.myPlayTime + this.myDuration > System.currentTimeMillis();
    }
}

