/*
 * Decompiled with CFR 0.152.
 */
package org.gmj.gmjfilesupport;

import com.sun.tools.javac.Javac;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.gjava.runner.GameSettings;
import org.gmj.gmjfilesupport.JGMLogicalView;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import sun.tools.jar.Main;

public final class JGMProject
implements Project {
    public static final String ROOMS_DIR = "rooms";
    public static final String IMAGES_DIR = "images";
    public static final String ACTORS_DIR = "actors";
    public static String gametype = "Embed";
    public static String initres;
    private final FileObject projectDir;
    LogicalViewProvider logicalView = new JGMLogicalView(this);
    private final ProjectState state;
    private Lookup lkp;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public JGMProject(FileObject projectDir, ProjectState state) {
        this.projectDir = projectDir;
        this.state = state;
    }

    public FileObject getProjectDirectory() {
        return this.projectDir;
    }

    FileObject getRoomsFolder(boolean create) {
        FileObject result = this.projectDir.getFileObject(ROOMS_DIR);
        if (result == null && create) {
            try {
                result = this.projectDir.createFolder(ROOMS_DIR);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
        return result;
    }

    FileObject getImagesFolder(boolean create) {
        FileObject result = this.projectDir.getFileObject(IMAGES_DIR);
        if (result == null && create) {
            try {
                result = this.projectDir.createFolder(IMAGES_DIR);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
        return result;
    }

    public Lookup getLookup() {
        if (this.lkp == null) {
            this.lkp = Lookups.fixed((Object[])new Object[]{this, this.state, new ActionProviderImpl(), this.loadProperties(), new Info(), this.logicalView});
        } else {
            ErrorManager.getDefault().log("Error: Didn't load Lookup!");
        }
        return this.lkp;
    }

    private Properties loadProperties() {
        FileObject fob = this.projectDir.getFileObject("JGMproject/project.settings");
        NotifyProperties properties = new NotifyProperties(this.state);
        if (fob != null) {
            try {
                properties.load(fob.getInputStream());
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return properties;
    }

    private final class Info
    implements ProjectInformation {
        private Info() {
        }

        public Icon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)"org/gmj/gmjfilesupport/room.png"));
        }

        public String getName() {
            return JGMProject.this.getProjectDirectory().getName();
        }

        public String getDisplayName() {
            return this.getName();
        }

        public void addPropertyChangeListener(PropertyChangeListener pcl) {
        }

        public void removePropertyChangeListener(PropertyChangeListener pcl) {
        }

        public Project getProject() {
            return JGMProject.this;
        }
    }

    private final class ActionProviderImpl
    implements ActionProvider {
        public BufferedWriter Gamesettings;
        public BufferedWriter Basicgame;
        public BufferedWriter Global_java;
        public BufferedWriter Filename_java;
        FileWriter BasicgameFW = null;
        FileWriter Global_javaFW = null;
        FileWriter Filename_javaFW;

        private ActionProviderImpl() {
        }

        public String[] getSupportedActions() {
            return new String[]{"build", "clean", "run.single", "run"};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
            Project pro = OpenProjects.getDefault().getMainProject();
            int idx = Arrays.asList(this.getSupportedActions()).indexOf(string);
            Process p = null;
            switch (idx) {
                case 0: {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                        }
                    });
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    final DataObject ob = (DataObject)lookup.lookup(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = JGMProject.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    if (ob == null) break;
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            if (ob.isValid()) {
                                // empty if block
                            }
                        }
                    });
                    break;
                }
                case 3: {
                    PrintStream printStream = null;
                    final InputOutput io = IOProvider.getDefault().getIO("Run", true);
                    if (p != null) {
                        p.destroy();
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            io.getOut().println("Building and runnning project...");
                            io.getOut().println("Generating java files...");
                            io.select();
                            io.getOut().close();
                        }
                    });
                    try {
                        String thisline;
                        this.copyFiles();
                        this.openfiles();
                        this.closeJava();
                        printStream = new PrintStream(new File(pro.getProjectDirectory().getPath() + "gjavalog"));
                        System.setErr(printStream);
                        Javac j = new Javac();
                        j.javac(new String[]{"-classpath", pro.getProjectDirectory().getPath(), pro.getProjectDirectory().getPath() + "/org/gjava/runner"});
                        j.javac(new String[]{"-classpath", pro.getProjectDirectory().getPath(), pro.getProjectDirectory().getPath() + "/" + pro.getProjectDirectory().getName() + ".java"});
                        FileInputStream fstream = new FileInputStream(new File(pro.getProjectDirectory().getPath() + "gjavalog"));
                        BufferedReader in = new BufferedReader(new InputStreamReader(fstream));
                        while ((thisline = in.readLine()) != null) {
                            io.getErr().println(thisline);
                        }
                        io.getOut().println("Finished compiling");
                        FileWriter manifestFW = new FileWriter(pro.getProjectDirectory().getPath() + "/manifest.txt");
                        BufferedWriter manifest = new BufferedWriter(manifestFW);
                        this.print(manifest, "Manifest-Version: 1.0");
                        this.print(manifest, "Main-Class: " + pro.getProjectDirectory().getName());
                        this.print(manifest, "Created-By: 1.2 (Sun Microsystems Inc.)");
                        manifest.close();
                        FileWriter htmlFW = new FileWriter(pro.getProjectDirectory().getPath() + File.separator + pro.getProjectDirectory().getName() + ".html");
                        BufferedWriter html = new BufferedWriter(htmlFW);
                        this.print(html, "<html>");
                        this.print(html, "<body>");
                        this.print(html, "Please wait while the game loads below...");
                        this.print(html, "<applet code=" + pro.getProjectDirectory().getName() + ".class ");
                        this.print(html, "  Archive = \"" + pro.getProjectDirectory().getName() + ".jar\"");
                        this.print(html, "        width=640 height=640>");
                        this.print(html, "</applet>");
                        this.print(html, "<br>Made with <b>G-java (www.g-java.com)</b>");
                        this.print(html, "</body>");
                        this.print(html, "</html>");
                        html.close();
                        File ff = new File(pro.getProjectDirectory().getPath() + pro.getProjectDirectory().getName() + ".jar");
                        if (ff.exists()) {
                            System.out.println("exists");
                        }
                        if (ff.delete()) {
                            System.out.println("deleted");
                        }
                        String[] args = new String[]{"cfm", pro.getProjectDirectory().getPath() + File.separator + pro.getProjectDirectory().getName() + ".jar", pro.getProjectDirectory().getPath() + File.separator + "manifest.txt", "-C", pro.getProjectDirectory().getPath(), pro.getProjectDirectory().getName() + ".class", "-C", pro.getProjectDirectory().getPath(), "org"};
                        Main jar = new Main(printStream, printStream, "cfm " + pro.getProjectDirectory().getName() + ".jar manifest.txt *.class org");
                        jar.run(args);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        try {
                            printStream.close();
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    io.getOut().close();
                    io.getErr().close();
                    io.getOut().println("Running jar as application...");
                    try {
                        p = Runtime.getRuntime().exec("Java -jar \"" + pro.getProjectDirectory().getPath() + File.separator + pro.getProjectDirectory().getName() + ".jar\"");
                        break;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }

        public void print(BufferedWriter file, String printString) throws IOException {
            file.write(printString);
            file.newLine();
        }

        public void openfiles() {
            Project pro = OpenProjects.getDefault().getMainProject();
            try {
                this.BasicgameFW = new FileWriter(pro.getProjectDirectory().getPath() + "/org/gjava/runner/basicgame.java");
                this.Global_javaFW = new FileWriter(pro.getProjectDirectory().getPath() + "/org/gjava/runner/Global.java");
                this.Filename_javaFW = new FileWriter(pro.getProjectDirectory().getPath() + "/" + pro.getProjectDirectory().getName() + ".java");
            }
            catch (Exception e) {
                this.msgbox("Error opening output file. " + e.getMessage(), 0);
            }
            this.Basicgame = new BufferedWriter(this.BasicgameFW);
            this.Global_java = new BufferedWriter(this.Global_javaFW);
            this.Filename_java = new BufferedWriter(this.Filename_javaFW);
            try {
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "// basicgame.java");
                this.print(this.Basicgame, "// by TGMG");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "// import the required classes");
                this.print(this.Basicgame, "package org.gjava.runner;");
                this.print(this.Basicgame, "import java.awt.*;");
                this.print(this.Basicgame, "import java.awt.event.*;");
                this.print(this.Basicgame, "import javax.swing.*;");
                this.print(this.Basicgame, "import java.io.*;");
                this.print(this.Basicgame, "import java.util.*;");
                this.print(this.Basicgame, "import java.net.*;");
                this.print(this.Basicgame, "import java.applet.*;");
                this.print(this.Basicgame, "import java.lang.reflect.InvocationTargetException;");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "// the main class");
                this.print(this.Basicgame, "public class basicgame {");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "//The Game Settings");
                this.print(this.Basicgame, "GameSettings gs = new GameSettings();");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "public static JFrame f;");
                this.print(this.Basicgame, "public static URL u;");
                this.print(this.Basicgame, "public static String Runningas;");
                this.print(this.Basicgame, "public static RoomPanel Current_room;");
                this.print(this.Basicgame, "public static JApplet Eapplet;");
                this.print(this.Basicgame, "public static int mouse;");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "// Declare the reasources");
                this.print(this.Basicgame, "//  G-java replace with res **101**");
                this.writeBasicgame();
                this.print(this.Global_java, "/////////////////////////////////");
                this.print(this.Global_java, "// Global.java by Gm_guru");
                this.print(this.Global_java, "// written for g-java 1.08+");
                this.print(this.Global_java, "/////////////////////////////////");
                this.print(this.Global_java, "package org.gjava.runner;");
                this.print(this.Global_java, "public class Global {");
                this.print(this.Global_java, "    // all global variables here");
                this.createFilenameJava();
                this.writeloadrooms();
            }
            catch (Exception e) {
                this.msgbox("Error writing to output file. " + e.getMessage(), 0);
                this.closeJava();
            }
        }

        private void writeBasicgame() {
            try {
                this.print(this.Basicgame, "public basicgame(URL u) {");
                this.print(this.Basicgame, "    // if it is an applet");
                this.print(this.Basicgame, "    this.Runningas = \"Applet\";");
                this.print(this.Basicgame, " this.mouse = 30;");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "    this.u = u;");
                this.print(this.Basicgame, "     // load Functions");
                this.print(this.Basicgame, "     Functions func = new Functions();");
                this.print(this.Basicgame, "     // create a new frame that will be the game window");
                this.print(this.Basicgame, "new load_Rooms(0);");
                this.print(this.Basicgame, " }");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "public basicgame(URL u, JApplet embed) {");
                this.print(this.Basicgame, "    // if it is an embedded applet");
                this.print(this.Basicgame, "    this.Runningas = \"EApplet\"; ");
                this.print(this.Basicgame, " this.mouse = 0;");
                this.print(this.Basicgame, "    Eapplet = embed;");
                this.print(this.Basicgame, "    this.u = u;");
                this.print(this.Basicgame, "     // load Functions");
                this.print(this.Basicgame, "     Functions func = new Functions();");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "new load_Rooms(0,embed);");
                this.print(this.Basicgame, "   ");
                this.print(this.Basicgame, " }");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "public basicgame() {");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "    // if it is an application");
                this.print(this.Basicgame, "    this.Runningas = \"Application\";");
                this.print(this.Basicgame, " this.mouse = 30;");
                this.print(this.Basicgame, "     // load Functions");
                this.print(this.Basicgame, "     Functions func = new Functions();");
                this.print(this.Basicgame, "   // create a new frame that will be the game window");
                this.print(this.Basicgame, "   JFrame f = new Room(332,92, false, gs.Outsidecolor);");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "   // center the room onscreen");
                this.print(this.Basicgame, "   Room.center(f);");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "   f.getContentPane().add(\"Center\",new StartPanel(f, gs.loading_image));");
                this.print(this.Basicgame, "   f.setVisible(true);");
                this.print(this.Basicgame, "}");
                this.print(this.Basicgame, "");
                this.print(this.Basicgame, "// Replace with ResourceCreate");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void msgbox(String message, int icon) {
            JOptionPane.showMessageDialog(null, message, "G-java", icon);
        }

        private void copy(String from, String to, boolean relativepath) throws Exception {
            int len;
            InputStream in;
            if (relativepath) {
                GameSettings gs = new GameSettings();
                in = gs.getClass().getResourceAsStream(from);
            } else {
                in = new FileInputStream(new File(from));
            }
            FileOutputStream out = new FileOutputStream(new File(to));
            byte[] b = new byte[1024];
            while ((len = in.read(b)) > 0) {
                ((OutputStream)out).write(b, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }

        private void copyFiles() {
            try {
                Project pro = OpenProjects.getDefault().getMainProject();
                String path = pro.getProjectDirectory().getPath() + "/org/gjava/runner/";
                this.copy("dialog.png", path + "dialog.png", true);
                this.copy("sprite.class", path + "sprite.class", true);
                this.copy("Path.class", path + "Path.class", true);
                this.copy("loading.png", path + "loading.png", true);
                this.copy("StartPanel.class", path + "StartPanel.class", true);
                this.copy("font.class", path + "font.class", true);
                this.copy("Background.class", path + "Background.class", true);
                this.copy("Functions.class", path + "Functions.class", true);
                this.copy("Functions.java", path + "Functions.java", true);
                this.copy("Actor.class", path + "Actor.class", true);
                this.copy("Runner.class", path + "Runner.class", true);
                this.copy("sound.class", path + "sound.class", true);
                this.copy("Room.class", path + "Room.class", true);
                this.copy("MessageBox.class", path + "MessageBox.class", true);
                this.copy("RoomPanel.class", path + "RoomPanel.class", true);
                this.copy("tile.class", path + "tile.class", true);
                this.copy("ImageCanvas.class", path + "ImageCanvas.class", true);
                this.copy("basicgame.class", path + "basicgame.class", true);
                this.copy("Game_Information.class", path + "Game_Information.class", true);
                this.copy("TimedAudioClip.class", path + "TimedAudioClip.class", true);
                this.copy("Timeline.class", path + "Timeline.class", true);
                this.copy("Variable.class", path + "Variable.class", true);
                this.copy("GameSettings.class", path + "GameSettings.class", true);
                this.copy("Global.class", path + "Global.class", true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void writeloadrooms() throws IOException {
            String roomstr = "";
            String eroomstr = "";
            String firstroom = "";
            String lastroom = "";
            String roomarray = "public static int getroom[]= {";
            Project pro = OpenProjects.getDefault().getMainProject();
            this.print(this.Basicgame, "}");
            this.Basicgame.close();
            this.BasicgameFW = new FileWriter(pro.getProjectDirectory().getPath() + "/org/gjava/runner/load_Rooms.java");
            this.Basicgame = new BufferedWriter(this.BasicgameFW);
            int subi = 0;
            Enumeration e = pro.getProjectDirectory().getFileObject(JGMProject.ROOMS_DIR).getChildren(true);
            while (e.hasMoreElements()) {
                FileObject f = (FileObject)e.nextElement();
                roomstr = roomstr + "    if (roomid ==  " + subi + ") {\n\n";
                eroomstr = eroomstr + "    if (roomid ==  " + subi + ") {\n\n";
                String currentroom = "" + subi;
                roomstr = roomstr + "rooms[" + currentroom + "] = new " + f.getName() + "(Room," + currentroom + ",roomid);\n basicgame.Current_room = rooms[" + currentroom + "];\n Room.setSize(rooms[" + currentroom + "].Width,rooms[" + currentroom + "].Height);\n Room.getContentPane().add( rooms[" + currentroom + "]);\n Room.validate();\n }";
                eroomstr = eroomstr + "rooms[" + currentroom + "] = new " + f.getName() + "(Room," + currentroom + ",roomid);\n basicgame.Current_room = rooms[" + currentroom + "];\n maingamep.getContentPane().add( rooms[" + currentroom + "]);\n }";
                if (subi == 0) {
                    firstroom = "0";
                    roomarray = roomarray + firstroom;
                } else {
                    roomarray = roomarray + "," + subi;
                }
                ++subi;
            }
            lastroom = "" + subi;
            this.print(this.Basicgame, "package org.gjava.runner;");
            this.print(this.Basicgame, "import java.awt.*;");
            this.print(this.Basicgame, "import java.awt.event.*;");
            this.print(this.Basicgame, "import javax.swing.*;");
            this.print(this.Basicgame, "import java.io.*;");
            this.print(this.Basicgame, "import java.util.*;");
            this.print(this.Basicgame, "import java.net.*;");
            this.print(this.Basicgame, "import java.applet.*;");
            this.print(this.Basicgame, "public class load_Rooms {");
            this.print(this.Basicgame, "public JFrame Room;");
            this.print(this.Basicgame, "public int firstroom = 0; ");
            this.print(this.Basicgame, "public int lastroom = " + lastroom + "; ");
            this.print(this.Basicgame, "public JApplet maingamep;");
            this.print(this.Basicgame, "public RoomPanel[] rooms = new RoomPanel[" + subi + 1 + "];");
            this.print(this.Basicgame, "public int roomid;");
            this.print(this.Basicgame, "public Image GIcon;");
            this.print(this.Basicgame, roomarray + "};");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "load_Rooms(int roomid) {");
            this.print(this.Basicgame, "    JFrame room = new Room(332,92,true, Color.black);");
            this.print(this.Basicgame, "if (basicgame.Runningas == \"Application\") {");
            this.print(this.Basicgame, "    StartPanel.loadingframe.dispose();");
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "//GIcon = new ImageIcon(getClass().getResource(\"icon.png\") ).getImage();");
            this.print(this.Basicgame, "//room.setIconImage(GIcon);");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "    room.setVisible(true);");
            this.print(this.Basicgame, "    this.Room = room;");
            this.print(this.Basicgame, "    this.roomid = roomid;");
            this.print(this.Basicgame, "    change_room(roomid);");
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "load_Rooms(int roomid,JApplet maingamep) {");
            this.print(this.Basicgame, "//it is embedded");
            this.print(this.Basicgame, "this.maingamep = maingamep;");
            this.print(this.Basicgame, "change_room(roomid,maingamep);");
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "public  boolean if_prev_room(int roomid) {");
            this.print(this.Basicgame, "if (roomid == firstroom) { return false; } else { return true; }");
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "public boolean if_next_room(int roomid) {");
            this.print(this.Basicgame, "if (roomid == lastroom) { return false; } else { return true; }");
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "public void prev_room(int roomid,JApplet maingamep) {");
            this.print(this.Basicgame, "        int gjavai = 0;");
            this.print(this.Basicgame, "        while (gjavai < getroom.length) {");
            this.print(this.Basicgame, "        if (getroom[gjavai] == roomid) { change_room(getroom[gjavai-1],maingamep); } gjavai++;");
            this.print(this.Basicgame, "    }");
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "public void prev_room(int roomid) {");
            this.print(this.Basicgame, "        int gjavai = 0;");
            this.print(this.Basicgame, "        while (gjavai < getroom.length) {");
            this.print(this.Basicgame, "        if (getroom[gjavai] == roomid) { change_room(getroom[gjavai-1]); } gjavai++;");
            this.print(this.Basicgame, "    }");
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "public void restart_room(int roomid,JApplet maingamep) {");
            this.print(this.Basicgame, "int locali = basicgame.Current_room.roomid;");
            this.print(this.Basicgame, "        remove_room(basicgame.Current_room.id);");
            this.print(this.Basicgame, "        change_room(locali,maingamep);");
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "public void restart_room(int roomid) {");
            this.print(this.Basicgame, "int locali = basicgame.Current_room.roomid;");
            this.print(this.Basicgame, "        remove_room(basicgame.Current_room.id);");
            this.print(this.Basicgame, "        change_room(locali);");
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "public void next_room(int roomid,JApplet maingamep) {");
            this.print(this.Basicgame, "        int gjavai = 0;");
            this.print(this.Basicgame, "        while (gjavai < getroom.length) {");
            this.print(this.Basicgame, "        if (getroom[gjavai] == roomid) { change_room(getroom[gjavai+1],maingamep); } gjavai++;");
            this.print(this.Basicgame, "    }");
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "public void next_room(int roomid) {");
            this.print(this.Basicgame, "        int gjavai = 0;");
            this.print(this.Basicgame, "        while (gjavai < getroom.length) {");
            this.print(this.Basicgame, "        if (getroom[gjavai] == roomid) { change_room(getroom[gjavai+1]); } gjavai++;");
            this.print(this.Basicgame, "    }");
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "public void change_room(int roomid,JApplet maingamep) {");
            this.print(this.Basicgame, eroomstr);
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "public void remove_room(int roomid) {");
            this.print(this.Basicgame, "//basicgame.close_sounds();");
            this.print(this.Basicgame, "if (basicgame.Runningas != \"EApplet\") {");
            this.print(this.Basicgame, "Room.removeKeyListener((KeyListener)rooms[roomid]);");
            this.print(this.Basicgame, "Room.removeMouseListener((MouseListener)rooms[roomid]);");
            this.print(this.Basicgame, "Room.remove(rooms[roomid]);");
            this.print(this.Basicgame, "} else {");
            this.print(this.Basicgame, "  // remove from embeded applet");
            this.print(this.Basicgame, "maingamep.removeKeyListener((KeyListener)rooms[roomid]);");
            this.print(this.Basicgame, "maingamep.removeMouseListener((MouseListener)rooms[roomid]);");
            this.print(this.Basicgame, "maingamep.remove(rooms[roomid]);");
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "public void change_room(int roomid) {");
            this.print(this.Basicgame, roomstr);
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "}");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "");
            this.print(this.Basicgame, "}");
        }

        private boolean closeJava() {
            try {
                this.Filename_java.close();
                this.Basicgame.close();
                this.print(this.Global_java, "}");
                this.Global_java.close();
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        private void createFilenameJava() throws IOException {
            Project pro = OpenProjects.getDefault().getMainProject();
            this.print(this.Filename_java, "// " + pro.getProjectDirectory().getName() + ".java");
            this.print(this.Filename_java, "// by G-java");
            this.print(this.Filename_java, "");
            this.print(this.Filename_java, "/*");
            this.print(this.Filename_java, "/ Made in Game Maker 6.0 www.gamemaker.nl");
            this.print(this.Filename_java, "/ Converted using G-java 1.08+ www.g-java.com");
            this.print(this.Filename_java, "/ This program can be run as an applet or an application!");
            this.print(this.Filename_java, "*/");
            this.print(this.Filename_java, "");
            this.print(this.Filename_java, "import org.gjava.runner.basicgame;");
            this.print(this.Filename_java, "import java.awt.*;");
            this.print(this.Filename_java, "import javax.swing.*;");
            this.print(this.Filename_java, "import java.net.*;");
            this.print(this.Filename_java, "");
            this.print(this.Filename_java, "public class " + pro.getProjectDirectory().getName() + " extends JApplet  {");
            this.print(this.Filename_java, "");
            this.print(this.Filename_java, "boolean loading = true;");
            this.print(this.Filename_java, "public Image loadingImage;");
            this.print(this.Filename_java, "");
            if (gametype == "Popup") {
                this.print(this.Filename_java, "    public void stop() {");
                this.print(this.Filename_java, "     // basicgame.close_sounds();");
                this.print(this.Filename_java, "    }");
                this.print(this.Filename_java, "    public void init() {");
                this.print(this.Filename_java, "    showStatus( \"Made in G-java - www.g-java.com\");");
                this.print(this.Filename_java, "        if(!isGreaterThanJDK14())");
                this.print(this.Filename_java, "        {");
                this.print(this.Filename_java, "            URL upgradeTarget;");
                this.print(this.Filename_java, "            try{");
                this.print(this.Filename_java, "                String targetURL = \"http://www.netsoc.tcd.ie/~duncan/dev/java/upgrade.html\";");
                this.print(this.Filename_java, "                 System.out.println(\"Sorry you need java version 1.4+ to run this program. Redirecting to \"+targetURL+\" for a later version of java\");");
                this.print(this.Filename_java, "                 getAppletContext().showDocument(new URL(targetURL));");
                this.print(this.Filename_java, "");
                this.print(this.Filename_java, "             }catch(MalformedURLException mfe)");
                this.print(this.Filename_java, "             {");
                this.print(this.Filename_java, "                 System.err.println(\"Malformed URL exception caught:\"+mfe);");
                this.print(this.Filename_java, "             }");
                this.print(this.Filename_java, "");
                this.print(this.Filename_java, "         }");
                this.print(this.Filename_java, "         ");
                this.print(this.Filename_java, "         URL u = getDocumentBase();");
                this.print(this.Filename_java, "                ");
                this.print(this.Filename_java, "         new basicgame(u);");
                this.print(this.Filename_java, "         ");
                this.print(this.Filename_java, "     }");
                this.print(this.Filename_java, "");
                this.print(this.Filename_java, "    public static void main(String args[]) {");
                this.print(this.Filename_java, "    ");
                this.print(this.Filename_java, "        // check if the user is using 1.4 or higher");
                this.print(this.Filename_java, "        if(!isGreaterThanJDK14())");
                this.print(this.Filename_java, "        {");
                this.print(this.Filename_java, "        JOptionPane.showMessageDialog(null,\"Please download the latest version of java.\");");
                this.print(this.Filename_java, "");
                this.print(this.Filename_java, "        }");
                this.print(this.Filename_java, "        ");
                this.print(this.Filename_java, "        new basicgame();");
                this.print(this.Filename_java, "        ");
                this.print(this.Filename_java, "    }");
                this.print(this.Filename_java, " public void paint( Graphics g ) {");
                this.print(this.Filename_java, "  loadingImage  = new ImageIcon(getClass().getResource(\"org/gjava/runner/loading.png\")).getImage();");
                this.print(this.Filename_java, "  //if the game is loading");
                this.print(this.Filename_java, "       g.drawImage(loadingImage,0,0, null);");
                this.print(this.Filename_java, "     if (loading) {");
                this.print(this.Filename_java, "     }");
                this.print(this.Filename_java, "  }");
            }
            if (gametype == "Embed") {
                this.print(this.Filename_java, "    public void init() {");
                this.print(this.Filename_java, "showStatus( \"Made in G-java - www.g-java.com\");");
                this.print(this.Filename_java, "        if(!isGreaterThanJDK14())");
                this.print(this.Filename_java, "        {");
                this.print(this.Filename_java, "            URL upgradeTarget;");
                this.print(this.Filename_java, "            try{");
                this.print(this.Filename_java, "                String targetURL = \"http://www.netsoc.tcd.ie/~duncan/dev/java/upgrade.html\";");
                this.print(this.Filename_java, "                 System.out.println(\"Sorry you need java version 1.4+ to run this program. Redirecting to \"+targetURL+\" for a later version of java\");");
                this.print(this.Filename_java, "                 getAppletContext().showDocument(new URL(targetURL));");
                this.print(this.Filename_java, "");
                this.print(this.Filename_java, "             }catch(MalformedURLException mfe)");
                this.print(this.Filename_java, "             {");
                this.print(this.Filename_java, "                 System.err.println(\"Malformed URL exception caught:\"+mfe);");
                this.print(this.Filename_java, "             }");
                this.print(this.Filename_java, "");
                this.print(this.Filename_java, "         }");
                this.print(this.Filename_java, "         ");
                this.print(this.Filename_java, "     }");
                this.print(this.Filename_java, "");
                this.print(this.Filename_java, "    public static void main(String args[]) {");
                this.print(this.Filename_java, "    ");
                this.print(this.Filename_java, "        // check if the user is using 1.4 or higher");
                this.print(this.Filename_java, "        if(!isGreaterThanJDK14())");
                this.print(this.Filename_java, "        {");
                this.print(this.Filename_java, "        JOptionPane.showMessageDialog(null,\"Please download the latest version of java.\");");
                this.print(this.Filename_java, "");
                this.print(this.Filename_java, "        }");
                this.print(this.Filename_java, "        ");
                this.print(this.Filename_java, "        basicgame gme = new basicgame();");
                this.print(this.Filename_java, "        ");
                this.print(this.Filename_java, "    }");
                this.print(this.Filename_java, "public void paint( Graphics g ) {");
                this.print(this.Filename_java, "         loadingImage  = new ImageIcon(getClass().getResource(\"gjava/runner/loading.png\")).getImage();");
                this.print(this.Filename_java, "      g.drawImage(loadingImage,0,0, null);");
                this.print(this.Filename_java, " //if the game is loading");
                this.print(this.Filename_java, "    if (loading) {");
                this.print(this.Filename_java, "         //load the sprites");
                this.print(this.Filename_java, "        // basicgame.load_Sprites();");
                this.print(this.Filename_java, "         //load the sounds");
                this.print(this.Filename_java, "        // basicgame.load_Sounds();");
                this.print(this.Filename_java, "         // load all backgrounds here");
                this.print(this.Filename_java, "        // basicgame.load_Backgrounds();");
                this.print(this.Filename_java, "         // load all paths here");
                this.print(this.Filename_java, "        // basicgame.load_Paths();");
                this.print(this.Filename_java, "         // load all fonts here");
                this.print(this.Filename_java, "        // basicgame.load_Fonts();");
                this.print(this.Filename_java, "         // load all timelines here");
                this.print(this.Filename_java, "        // basicgame.load_Timelines();");
                this.print(this.Filename_java, "         loading = false;");
                this.print(this.Filename_java, "         URL u = getDocumentBase();");
                this.print(this.Filename_java, "                ");
                this.print(this.Filename_java, "         basicgame gme = new basicgame(u,this);");
                this.print(this.Filename_java, "    }");
                this.print(this.Filename_java, " }");
            }
            this.print(this.Filename_java, "    private static boolean isGreaterThanJDK14()");
            this.print(this.Filename_java, "    {");
            this.print(this.Filename_java, "        /*");
            this.print(this.Filename_java, "            (taken from http://h21007.www2.hp.com/dspp/tech/tech_TechDocumentDetailPage_IDX/1,1701,2156,00.html):");
            this.print(this.Filename_java, "");
            this.print(this.Filename_java, "            java.class.version property values:");
            this.print(this.Filename_java, "        ");
            this.print(this.Filename_java, "            JDK 1.1 45.3");
            this.print(this.Filename_java, "            JDK 1.2 46.0");
            this.print(this.Filename_java, "            JDK 1.3 47.0");
            this.print(this.Filename_java, "            JDK 1.4 48.0");
            this.print(this.Filename_java, "");
            this.print(this.Filename_java, "        */");
            this.print(this.Filename_java, "        String v = System.getProperty(\"java.class.version\");");
            this.print(this.Filename_java, "        String v2 = System.getProperty(\"java.version\");");
            this.print(this.Filename_java, "        System.out.println(\"java.class.version:\"+v);");
            this.print(this.Filename_java, "        System.out.println(\"java.version:\"+v2);");
            this.print(this.Filename_java, "        System.out.println(\"Made in G-java : WwW.G-jAvA.CoM\");");
            this.print(this.Filename_java, "        try{");
            this.print(this.Filename_java, "            return (Double.valueOf(v).doubleValue() >= 47.0);");
            this.print(this.Filename_java, "        }catch(NumberFormatException nfe)");
            this.print(this.Filename_java, "        {");
            this.print(this.Filename_java, "        }");
            this.print(this.Filename_java, "        return false;");
            this.print(this.Filename_java, "");
            this.print(this.Filename_java, "    }");
            this.print(this.Filename_java, "}");
        }

        public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
            boolean result;
            int idx = Arrays.asList(this.getSupportedActions()).indexOf(string);
            switch (idx) {
                case 0: {
                    if (OpenProjects.getDefault().getMainProject() == null) {
                        result = false;
                        break;
                    }
                    result = false;
                    break;
                }
                case 1: {
                    result = false;
                    break;
                }
                case 2: {
                    DataObject ob = (DataObject)lookup.lookup(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = JGMProject.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    if (ob != null) {
                        FileObject file = ob.getPrimaryFile();
                        result = "text/x-povray".equals(file.getMIMEType());
                        break;
                    }
                    result = false;
                    break;
                }
                case 3: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }
    }

    private static class NotifyProperties
    extends Properties {
        private final ProjectState state;

        NotifyProperties(ProjectState state) {
            this.state = state;
        }

        public Object put(Object key, Object val) {
            Object result = super.put(key, val);
            if (result == null != (val == null) || result != null && val != null && !val.equals(result)) {
                this.state.markModified();
            }
            return result;
        }
    }
}

