/*
 * Decompiled with CFR 0.152.
 */
package org.gmj.gmjfilesupport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.gmj.gmjfilesupport.JGMProject;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JGMProjectFactory
implements ProjectFactory {
    public static final String PROJECT_DIR = "JGMproject";
    public static final String PROJECT_PROPFILE = "project.settings";

    public boolean isProject(FileObject projectDirectory) {
        return projectDirectory.getFileObject(PROJECT_DIR) != null;
    }

    public Project loadProject(FileObject dir, ProjectState state) throws IOException {
        return this.isProject(dir) ? new JGMProject(dir, state) : null;
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
        FileObject projectRoot = project.getProjectDirectory();
        if (projectRoot.getFileObject(PROJECT_DIR) == null) {
            throw new IOException("Project dir " + projectRoot.getPath() + " deleted," + " cannot save project");
        }
        ((JGMProject)project).getRoomsFolder(true);
        String propsPath = "JGMproject/project.settings";
        FileObject propertiesFile = projectRoot.getFileObject(propsPath);
        if (propertiesFile == null) {
            propertiesFile = projectRoot.createData(propsPath);
        }
        Properties properties = (Properties)project.getLookup().lookup(Properties.class);
        File f = FileUtil.toFile((FileObject)propertiesFile);
        properties.store(new FileOutputStream(f), "NetBeans JGM Project Properties");
    }
}

