/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lexer.editorbridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.MarkFactory;
import org.netbeans.modules.lexer.editorbridge.LexerEditorKit;
import org.openide.util.Lookup;

final class LexerLayer
extends DrawLayer.AbstractLayer {
    public static final String NAME = "lexer-layer";
    public static final int VISIBILITY = 1050;
    private static final Coloring NULL_COLORING = new Coloring();
    private final JTextComponent component;
    private Listener listener;
    private TokenHierarchy listenerHierarchy;
    private Stack<TokenSequence> pastSequences;
    private TokenSequence tokenSequence;
    private boolean moveNext = true;
    private boolean goToEmbed = true;
    private int tokenEndOffset;
    private Coloring coloring;
    private boolean active;

    public LexerLayer(JTextComponent jTextComponent) {
        super(NAME);
        assert (jTextComponent != null);
        this.component = jTextComponent;
        Document document = jTextComponent.getDocument();
        jTextComponent.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("document".equals(propertyChangeEvent.getPropertyName()) && LexerLayer.this.listenerHierarchy != null) {
                    LexerLayer.this.listenerHierarchy.removeTokenHierarchyListener((TokenHierarchyListener)LexerLayer.this.listener);
                    LexerLayer.this.listenerHierarchy = null;
                }
            }
        });
    }

    public boolean extendsEOL() {
        return true;
    }

    public void init(DrawContext drawContext) {
        this.coloring = null;
        this.tokenEndOffset = 0;
        int n = drawContext.getStartOffset();
        TokenHierarchy tokenHierarchy = this.tokenHierarchy();
        boolean bl = this.active = tokenHierarchy != null;
        if (this.active) {
            this.pastSequences = new Stack();
            this.tokenSequence = tokenHierarchy.tokenSequence();
            this.tokenSequence.move(n);
            if (this.tokenSequence.moveNext()) {
                this.updateTokenEndOffsetAndColoring(n);
            } else {
                this.active = false;
            }
        }
    }

    public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
        return this.active;
    }

    public void updateContext(DrawContext drawContext) {
        if (this.coloring != null) {
            this.coloring.apply(drawContext);
        }
        int n = drawContext.getFragmentOffset() + drawContext.getFragmentLength();
        while (this.active && n >= this.tokenEndOffset) {
            if (!this.moveNext || this.tokenSequence.moveNext()) {
                this.updateTokenEndOffsetAndColoring(-1);
                continue;
            }
            if (this.pastSequences.isEmpty()) {
                this.active = false;
                continue;
            }
            this.tokenSequence = this.pastSequences.pop();
            if (this.tokenSequence.offset() + this.tokenSequence.token().length() <= this.tokenEndOffset) continue;
            this.goToEmbed = false;
            this.moveNext = false;
        }
    }

    private TokenHierarchy tokenHierarchy() {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.component.getDocument());
        if (tokenHierarchy != null && this.listenerHierarchy == null) {
            if (this.listener == null) {
                this.listener = new Listener();
            }
            this.listenerHierarchy = tokenHierarchy;
            this.listenerHierarchy.addTokenHierarchyListener((TokenHierarchyListener)this.listener);
        }
        return tokenHierarchy;
    }

    private void updateTokenEndOffsetAndColoring(int n) {
        LanguagePath languagePath;
        TokenSequence tokenSequence;
        int n2 = this.tokenSequence.offset();
        boolean bl = this.tokenSequence.offset() < n;
        Token token = this.tokenSequence.token();
        LanguagePath languagePath2 = this.tokenSequence.languagePath();
        boolean bl2 = false;
        while (n2 == this.tokenSequence.offset() && this.goToEmbed && (tokenSequence = this.tokenSequence.embedded()) != null) {
            bl2 = true;
            if (n == -1) {
                if (!tokenSequence.moveNext()) break;
                this.pastSequences.push(this.tokenSequence);
                this.tokenSequence = tokenSequence;
                continue;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) break;
            this.pastSequences.push(this.tokenSequence);
            this.tokenSequence = tokenSequence;
        }
        this.goToEmbed = true;
        if (n2 == this.tokenSequence.offset() || bl) {
            tokenSequence = this.tokenSequence.token();
            this.tokenEndOffset = this.tokenSequence.offset() + tokenSequence.length();
            languagePath = this.tokenSequence.languagePath();
            this.moveNext = true;
        } else {
            tokenSequence = token;
            this.tokenEndOffset = this.tokenSequence.offset();
            languagePath = languagePath2;
            this.moveNext = !bl2;
        }
        this.setNextActivityChangeOffset(this.tokenEndOffset);
        this.coloring = this.findColoring(tokenSequence.id(), languagePath);
    }

    private Coloring findColoring(TokenId tokenId, LanguagePath languagePath) {
        MimePath mimePath = this.languagePathToMimePathHack(languagePath);
        Lookup lookup = MimeLookup.getLookup((MimePath)mimePath);
        FontColorSettings fontColorSettings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        AttributeSet attributeSet = this.findFontAndColors(fontColorSettings, tokenId, languagePath.innerLanguage());
        return attributeSet == null ? NULL_COLORING : Coloring.fromAttributeSet((AttributeSet)attributeSet);
    }

    private void dumpAttribs(AttributeSet attributeSet, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Attribs for token '");
        stringBuilder.append(string);
        stringBuilder.append("', language '");
        stringBuilder.append(string2);
        stringBuilder.append("' = {");
        if (attributeSet != null) {
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Object object = attributeSet.getAttribute(obj);
                stringBuilder.append("'" + obj + "' = '" + object + "'");
                if (!enumeration.hasMoreElements()) continue;
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append("} LexerLayer.this = ");
        stringBuilder.append(this.toString());
        System.out.println(stringBuilder.toString());
    }

    private MimePath languagePathToMimePathHack(LanguagePath languagePath) {
        String string = this.getMimeType(this.component);
        if (languagePath.size() == 1) {
            return MimePath.parse((String)string);
        }
        if (languagePath.size() > 1) {
            return MimePath.parse((String)(string + "/" + languagePath.subPath(1).mimePath()));
        }
        throw new IllegalStateException("LanguagePath should not be empty.");
    }

    private String getMimeType(JTextComponent jTextComponent) {
        Object object = jTextComponent.getDocument().getProperty("mimeType");
        if (object instanceof String) {
            return (String)object;
        }
        return jTextComponent.getUI().getEditorKit(jTextComponent).getContentType();
    }

    private String updateColoringName(String string) {
        String string2;
        EditorKit editorKit = this.component.getUI().getEditorKit(this.component);
        if (editorKit instanceof LexerEditorKit && (string2 = ((LexerEditorKit)((Object)editorKit)).updateColoringName(string)) != null) {
            string = string2;
        }
        return string;
    }

    private AttributeSet findFontAndColors(FontColorSettings fontColorSettings, TokenId tokenId, Language language) {
        AttributeSet attributeSet;
        block2: {
            String string;
            Object object;
            String string2 = tokenId.name();
            attributeSet = fontColorSettings.getTokenFontColors(this.updateColoringName(string2));
            if (attributeSet == null && (object = tokenId.primaryCategory()) != null) {
                attributeSet = fontColorSettings.getTokenFontColors(this.updateColoringName((String)object));
            }
            if (attributeSet != null) break block2;
            object = language.nonPrimaryTokenCategories(tokenId);
            Iterator iterator = object.iterator();
            while (iterator.hasNext() && (attributeSet = fontColorSettings.getTokenFontColors(this.updateColoringName(string = (String)iterator.next()))) == null) {
            }
        }
        return attributeSet;
    }

    private final class Listener
    implements TokenHierarchyListener {
        private Listener() {
        }

        public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
            TextUI textUI = LexerLayer.this.component.getUI();
            int n = tokenHierarchyEvent.affectedStartOffset();
            int n2 = Math.max(tokenHierarchyEvent.affectedEndOffset(), n + 1);
            textUI.damageRange(LexerLayer.this.component, n, n2);
        }
    }
}

