/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.codetemplates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.util.NbBundle;

class CodeTemplatesModel
implements TableModelListener {
    private List languages = new ArrayList();
    private Map languageToMimeType = new HashMap();
    private Set modifiedLanguages = new HashSet();
    private Map languageToModel = new HashMap();
    private Map modelToLanguage = new HashMap();
    private KeyStroke expander;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$BaseOptions;

    CodeTemplatesModel() {
        Vector<String> vector = new Vector<String>();
        vector.add(CodeTemplatesModel.loc("Abbreviation_Title"));
        vector.add(CodeTemplatesModel.loc("Expanded_Text_Title"));
        Set set = EditorSettings.getDefault().getAllMimeTypes();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.isCompoundMimeType(string)) continue;
            BaseOptions baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)string)).lookup(class$org$netbeans$modules$editor$options$BaseOptions == null ? CodeTemplatesModel.class$("org.netbeans.modules.editor.options.BaseOptions") : class$org$netbeans$modules$editor$options$BaseOptions);
            if (baseOptions == null) continue;
            String string2 = EditorSettings.getDefault().getLanguageName(string);
            this.languages.add(string2);
            Collections.sort(this.languages);
            this.languageToMimeType.put(string2, string);
            Map map = baseOptions.getAbbrevMap();
            ArrayList arrayList = new ArrayList();
            Object object = map.keySet().iterator();
            while (object.hasNext()) {
                String string3 = (String)object.next();
                Vector<String> vector2 = new Vector<String>(2);
                vector2.add(string3);
                vector2.add((String)map.get(string3));
                arrayList.add(vector2);
            }
            Collections.sort(arrayList, new MComparator());
            object = new DefaultTableModel(new Vector(arrayList), vector){

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            ((AbstractTableModel)object).addTableModelListener(this);
            this.modelToLanguage.put(object, string2);
            this.languageToModel.put(string2, object);
        }
        this.expander = BaseOptions.getCodeTemplateExpandKey();
    }

    private boolean isCompoundMimeType(String string) {
        int n = string.lastIndexOf(43);
        return n != -1 && n < string.length() - 1;
    }

    List getLanguages() {
        return Collections.unmodifiableList(this.languages);
    }

    String getMimeType(String string) {
        return (String)this.languageToMimeType.get(string);
    }

    DefaultTableModel getTableModel(String string) {
        return (DefaultTableModel)this.languageToModel.get(string);
    }

    void addRow(String string, String string2, String string3) {
        DefaultTableModel defaultTableModel = this.getTableModel(string);
        Vector<String> vector = new Vector<String>();
        vector.add(string2);
        vector.add(string3);
        defaultTableModel.insertRow(0, vector);
        this.modifiedLanguages.add(string);
    }

    void removeRow(String string, int n) {
        DefaultTableModel defaultTableModel = this.getTableModel(string);
        defaultTableModel.removeRow(n);
        this.modifiedLanguages.add(string);
    }

    void saveChanges() {
        Iterator iterator = this.modifiedLanguages.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.languageToMimeType.get(string);
            BaseOptions baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)string2)).lookup(class$org$netbeans$modules$editor$options$BaseOptions == null ? CodeTemplatesModel.class$("org.netbeans.modules.editor.options.BaseOptions") : class$org$netbeans$modules$editor$options$BaseOptions);
            DefaultTableModel defaultTableModel = this.getTableModel(string);
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                hashMap.put(defaultTableModel.getValueAt(i, 0), defaultTableModel.getValueAt(i, 1));
            }
            baseOptions.setAbbrevMap(hashMap);
        }
        if (this.expander != null && !BaseOptions.getCodeTemplateExpandKey().equals(this.expander)) {
            BaseOptions.setCodeTemplateExpandKey((KeyStroke)this.expander);
        }
    }

    boolean isChanged() {
        return !this.modifiedLanguages.isEmpty() || !BaseOptions.getCodeTemplateExpandKey().equals(this.expander);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)tableModelEvent.getSource();
        String string = (String)this.modelToLanguage.get(defaultTableModel);
        this.modifiedLanguages.add(string);
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)CodeTemplatesModel.class, (String)string);
    }

    KeyStroke getExpander() {
        return this.expander;
    }

    void setExpander(KeyStroke keyStroke) {
        this.expander = keyStroke;
    }

    private static class MComparator
    implements Comparator {
        private MComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = (String)((Vector)object).get(0);
            String string2 = (String)((Vector)object2).get(0);
            return string.compareTo(string2);
        }
    }
}

