/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.codetemplates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.options.codetemplates.CodeTemplatesModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CodeTemplatesPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private CodeTemplatesModel model;
    private Lookup lookup;
    private int lastIndex = -1;
    private JButton bNew;
    private JButton bRemove;
    private JComboBox cbExpandTemplateOn;
    private JComboBox cbLanguage;
    private JEditorPane epExpandedText;
    private JLabel lExpandedText;
    private JLabel lExplandTemplateOn;
    private JLabel lLanguage;
    private JLabel lTemplates;
    private JScrollPane spExpandedText;
    private JScrollPane spTemplates;
    private JTable tTemplates;
    static /* synthetic */ Class class$java$lang$String;

    public CodeTemplatesPanel() {
        this.initComponents();
        CodeTemplatesPanel.loc(this.lLanguage, "Language");
        CodeTemplatesPanel.loc(this.lTemplates, "Templates");
        CodeTemplatesPanel.loc(this.bNew, "New");
        CodeTemplatesPanel.loc(this.bRemove, "Remove");
        this.cbExpandTemplateOn.addItem(CodeTemplatesPanel.loc("SPACE"));
        this.cbExpandTemplateOn.addItem(CodeTemplatesPanel.loc("S-SPACE"));
        this.cbExpandTemplateOn.addItem(CodeTemplatesPanel.loc("TAB"));
        this.cbExpandTemplateOn.addItem(CodeTemplatesPanel.loc("ENTER"));
        CodeTemplatesPanel.loc(this.lExpandedText, "Expanded_Text");
        CodeTemplatesPanel.loc(this.lExplandTemplateOn, "ExpandTemplateOn");
        this.bRemove.setEnabled(false);
        JLabel jLabel = new JLabel();
        this.tTemplates.getTableHeader().setReorderingAllowed(false);
        this.tTemplates.getSelectionModel().setSelectionMode(0);
        Font font = this.tTemplates.getFont();
        JLabel jLabel2 = new JLabel();
        jLabel2.setLabelFor(this.tTemplates);
        JLabel jLabel3 = new JLabel();
        jLabel3.setLabelFor(this.epExpandedText);
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)CodeTemplatesPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(CodeTemplatesPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(CodeTemplatesPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)CodeTemplatesPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)CodeTemplatesPanel.loc("CTL_" + string));
        }
    }

    void update() {
        this.model = new CodeTemplatesModel();
        this.cbLanguage.removeActionListener(this);
        this.bNew.removeActionListener(this);
        this.bRemove.removeActionListener(this);
        this.cbExpandTemplateOn.removeActionListener(this);
        this.tTemplates.getSelectionModel().removeListSelectionListener(this);
        this.cbLanguage.removeAllItems();
        ArrayList arrayList = new ArrayList(this.model.getLanguages());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.cbLanguage.addItem(iterator.next());
        }
        KeyStroke keyStroke = this.model.getExpander();
        if (KeyStroke.getKeyStroke(32, 1).equals(keyStroke)) {
            this.cbExpandTemplateOn.setSelectedIndex(1);
        } else if (KeyStroke.getKeyStroke(9, 0).equals(keyStroke)) {
            this.cbExpandTemplateOn.setSelectedIndex(2);
        } else if (KeyStroke.getKeyStroke(10, 0).equals(keyStroke)) {
            this.cbExpandTemplateOn.setSelectedIndex(3);
        } else {
            this.cbExpandTemplateOn.setSelectedIndex(0);
        }
        this.cbLanguage.addActionListener(this);
        this.bNew.addActionListener(this);
        this.bRemove.addActionListener(this);
        this.cbExpandTemplateOn.addActionListener(this);
        this.tTemplates.getSelectionModel().addListSelectionListener(this);
        this.cbLanguage.setSelectedItem("Java");
    }

    void applyChanges() {
        if (this.model != null) {
            this.saveCurrentTemplate();
            this.model.saveChanges();
        }
    }

    void cancel() {
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        return this.model.isChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cbLanguage) {
            this.saveCurrentTemplate();
            final String string = (String)this.cbLanguage.getSelectedItem();
            final DefaultTableModel defaultTableModel = this.model.getTableModel(string);
            this.tTemplates.setModel(defaultTableModel);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CodeTemplatesPanel.this.epExpandedText.setEditorKit(CloneableEditorSupport.getEditorKit((String)CodeTemplatesPanel.this.model.getMimeType(string)));
                    if (defaultTableModel.getRowCount() > 0) {
                        CodeTemplatesPanel.this.lastIndex = -1;
                        CodeTemplatesPanel.this.tTemplates.getSelectionModel().setSelectionInterval(0, 0);
                        CodeTemplatesPanel.this.lastIndex = 0;
                    } else {
                        CodeTemplatesPanel.this.lastIndex = -1;
                    }
                }
            });
        } else if (actionEvent.getSource() == this.bNew) {
            this.saveCurrentTemplate();
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(CodeTemplatesPanel.loc("CTL_Enter_template_name"), CodeTemplatesPanel.loc("CTL_New_template_dialog_title"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.InputLine.OK_OPTION) {
                String string = inputLine.getInputText().trim();
                if (string.length() == 0) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CodeTemplatesPanel.loc("CTL_Empty_template_name"), 0));
                } else {
                    String string2;
                    int n;
                    TableModel tableModel = this.tTemplates.getModel();
                    int n2 = tableModel.getRowCount();
                    for (n = 0; n < n2; ++n) {
                        string2 = (String)tableModel.getValueAt(n, 0);
                        if (!string.equals(string2)) continue;
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CodeTemplatesPanel.loc("CTL_Duplicate_template_name"), 0));
                        break;
                    }
                    if (n == n2) {
                        string2 = (String)this.cbLanguage.getSelectedItem();
                        this.lastIndex = -1;
                        this.model.addRow(string2, string, "");
                        this.tTemplates.getSelectionModel().setSelectionInterval(0, 0);
                        this.spTemplates.getVerticalScrollBar().setValue(0);
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CodeTemplatesPanel.this.epExpandedText.requestFocus();
                }
            });
        } else if (actionEvent.getSource() == this.bRemove) {
            String string = (String)this.cbLanguage.getSelectedItem();
            int n = this.tTemplates.getSelectedRow();
            this.model.removeRow(string, n);
            this.lastIndex = -1;
            if (n < this.tTemplates.getModel().getRowCount()) {
                this.tTemplates.getSelectionModel().setSelectionInterval(n, n);
            } else if (this.tTemplates.getModel().getRowCount() > 0) {
                this.tTemplates.getSelectionModel().setSelectionInterval(this.tTemplates.getModel().getRowCount() - 1, this.tTemplates.getModel().getRowCount() - 1);
            } else {
                this.bRemove.setEnabled(false);
            }
        } else if (actionEvent.getSource() == this.cbExpandTemplateOn) {
            switch (this.cbExpandTemplateOn.getSelectedIndex()) {
                case 0: {
                    this.model.setExpander(KeyStroke.getKeyStroke(32, 0));
                    break;
                }
                case 1: {
                    this.model.setExpander(KeyStroke.getKeyStroke(32, 1));
                    break;
                }
                case 2: {
                    this.model.setExpander(KeyStroke.getKeyStroke(9, 0));
                    break;
                }
                case 3: {
                    this.model.setExpander(KeyStroke.getKeyStroke(10, 0));
                }
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.tTemplates.getSelectedRow();
        if (n < 0) {
            this.epExpandedText.setText("");
            this.bRemove.setEnabled(false);
            this.lastIndex = -1;
            return;
        }
        this.saveCurrentTemplate();
        TableModel tableModel = this.tTemplates.getModel();
        this.bRemove.setEnabled(true);
        String string = (String)tableModel.getValueAt(n, 1);
        this.epExpandedText.setText(string);
        this.lastIndex = n;
    }

    void setLookup(Lookup lookup) {
        this.lookup = lookup;
    }

    void saveCurrentTemplate() {
        TableModel tableModel = this.tTemplates.getModel();
        if (this.lastIndex < 0) {
            return;
        }
        if (this.epExpandedText.getText().equals(tableModel.getValueAt(this.lastIndex, 1))) {
            return;
        }
        tableModel.setValueAt(this.epExpandedText.getText(), this.lastIndex, 1);
        this.firePropertyChange("changed", null, null);
    }

    private void initComponents() {
        this.lLanguage = new JLabel();
        this.cbLanguage = new JComboBox();
        this.lTemplates = new JLabel();
        this.spTemplates = new JScrollPane();
        this.tTemplates = new JTable();
        this.bNew = new JButton();
        this.bRemove = new JButton();
        this.lExpandedText = new JLabel();
        this.spExpandedText = new JScrollPane();
        this.epExpandedText = new JEditorPane();
        this.lExplandTemplateOn = new JLabel();
        this.cbExpandTemplateOn = new JComboBox();
        this.lLanguage.setLabelFor(this.cbLanguage);
        this.lLanguage.setText("Language:");
        this.lTemplates.setLabelFor(this.tTemplates);
        this.lTemplates.setText("Templates:");
        this.tTemplates.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Abbreviation", "Expanded Text"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CodeTemplatesPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CodeTemplatesPanel.class$("java.lang.String")) : class$java$lang$String};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.spTemplates.setViewportView(this.tTemplates);
        this.bNew.setText("New");
        this.bRemove.setText("Remove");
        this.lExpandedText.setLabelFor(this.epExpandedText);
        this.lExpandedText.setText("Expanded Text:");
        this.spExpandedText.setViewportView(this.epExpandedText);
        this.lExplandTemplateOn.setLabelFor(this.cbExpandTemplateOn);
        this.lExplandTemplateOn.setText("Expand Template on:");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lLanguage).addPreferredGap(0).add((Component)this.cbLanguage, -2, -1, -2)).add((Component)this.lTemplates).add((Component)this.lExpandedText).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lExplandTemplateOn).addPreferredGap(0).add((Component)this.cbExpandTemplateOn, -2, -1, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.spExpandedText, -1, 329, Short.MAX_VALUE).add(1, (Component)this.spTemplates, -1, 329, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.bRemove, -1, -1, Short.MAX_VALUE).add((Component)this.bNew, -1, 81, Short.MAX_VALUE)).add(10, 10, 10))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lLanguage).add((Component)this.cbLanguage, -2, -1, -2)).addPreferredGap(0).add((Component)this.lTemplates).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.bNew).addPreferredGap(0).add((Component)this.bRemove)).add((Component)this.spTemplates, -1, 132, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.lExpandedText).addPreferredGap(0).add((Component)this.spExpandedText, -1, 63, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lExplandTemplateOn).add((Component)this.cbExpandTemplateOn, -2, -1, -2))));
    }
}

