/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.options.colors.AnnotationsPanel;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.HighlightingPanel;
import org.netbeans.modules.options.colors.SyntaxColoringPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FontAndColorsPanel
extends JPanel
implements ActionListener {
    private SyntaxColoringPanel syntaxColoringPanel;
    private HighlightingPanel highlightingPanel;
    private AnnotationsPanel annotationsPanel;
    private ColorModel colorModel;
    private String currentProfile;
    private boolean listen = false;
    private JButton bDelete;
    private JButton bDuplicate;
    private JComboBox cbProfile;
    private JLabel lProfile;
    private JTabbedPane tpCustomizers;

    public FontAndColorsPanel() {
        this.initComponents();
        this.cbProfile.getAccessibleContext().setAccessibleName(FontAndColorsPanel.loc("AN_Profiles"));
        this.cbProfile.getAccessibleContext().setAccessibleDescription(FontAndColorsPanel.loc("AD_Profiles"));
        this.bDelete.getAccessibleContext().setAccessibleName(FontAndColorsPanel.loc("AN_Delete"));
        this.bDelete.getAccessibleContext().setAccessibleDescription(FontAndColorsPanel.loc("AD_Delete"));
        this.bDuplicate.getAccessibleContext().setAccessibleName(FontAndColorsPanel.loc("AN_Clone"));
        this.bDuplicate.getAccessibleContext().setAccessibleDescription(FontAndColorsPanel.loc("AD_Clone"));
        this.tpCustomizers.getAccessibleContext().setAccessibleName(FontAndColorsPanel.loc("AN_Categories"));
        this.tpCustomizers.getAccessibleContext().setAccessibleDescription(FontAndColorsPanel.loc("AD_Categories"));
        this.syntaxColoringPanel = new SyntaxColoringPanel(this);
        this.highlightingPanel = new HighlightingPanel();
        this.annotationsPanel = new AnnotationsPanel();
        this.cbProfile.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!FontAndColorsPanel.this.listen) {
                    return;
                }
                FontAndColorsPanel.this.setCurrentProfile((String)FontAndColorsPanel.this.cbProfile.getSelectedItem());
            }
        });
        FontAndColorsPanel.loc(this.bDuplicate, "CTL_Create_New");
        this.bDuplicate.addActionListener(this);
        FontAndColorsPanel.loc(this.bDelete, "CTL_Delete");
        this.bDelete.addActionListener(this);
        this.tpCustomizers.addTab(FontAndColorsPanel.loc("Syntax_coloring_tab"), this.syntaxColoringPanel);
        this.tpCustomizers.addTab(FontAndColorsPanel.loc("Editor_tab"), this.highlightingPanel);
        this.tpCustomizers.addTab(FontAndColorsPanel.loc("Annotations_tab"), this.annotationsPanel);
        this.tpCustomizers.setMnemonicAt(0, FontAndColorsPanel.loc("Syntax_coloring_tab_mnemonic").charAt(0));
        this.tpCustomizers.setMnemonicAt(1, FontAndColorsPanel.loc("Editor_tab_mnemonic").charAt(0));
        this.tpCustomizers.setMnemonicAt(2, FontAndColorsPanel.loc("Annotations_tab_mnemonic").charAt(0));
    }

    private void initComponents() {
        this.lProfile = new JLabel();
        this.cbProfile = new JComboBox();
        this.tpCustomizers = new JTabbedPane();
        this.bDuplicate = new JButton();
        this.bDelete = new JButton();
        this.lProfile.setText("Profile:");
        this.bDuplicate.setText("Duplicate...");
        this.bDelete.setText("Delete");
        this.bDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontAndColorsPanel.this.bDeleteActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lProfile).addPreferredGap(0).add((Component)this.cbProfile, 0, 195, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.bDuplicate).addPreferredGap(0).add((Component)this.bDelete)).add((Component)this.tpCustomizers, -1, 427, Short.MAX_VALUE));
        groupLayout.linkSize(new Component[]{this.bDelete, this.bDuplicate}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lProfile).add((Component)this.bDelete).add((Component)this.bDuplicate).add((Component)this.cbProfile, -2, -1, -2)).addPreferredGap(0).add((Component)this.tpCustomizers, -1, 287, Short.MAX_VALUE)));
    }

    private void bDeleteActionPerformed(ActionEvent actionEvent) {
    }

    private void setCurrentProfile(String string) {
        if (this.colorModel.isCustomProfile(string)) {
            FontAndColorsPanel.loc(this.bDelete, "CTL_Delete");
        } else {
            FontAndColorsPanel.loc(this.bDelete, "CTL_Restore");
        }
        this.currentProfile = string;
        this.highlightingPanel.setCurrentProfile(this.currentProfile);
        this.syntaxColoringPanel.setCurrentProfile(this.currentProfile);
        this.annotationsPanel.setCurrentProfile(this.currentProfile);
    }

    private void deleteCurrentProfile() {
        String string = (String)this.cbProfile.getSelectedItem();
        this.highlightingPanel.deleteProfile(string);
        this.syntaxColoringPanel.deleteProfile(string);
        this.annotationsPanel.deleteProfile(string);
        if (this.colorModel.isCustomProfile(string)) {
            this.cbProfile.removeItem(string);
            this.cbProfile.setSelectedIndex(0);
        }
    }

    void update() {
        if (this.colorModel == null) {
            this.colorModel = new ColorModel();
        }
        this.highlightingPanel.update(this.colorModel);
        this.syntaxColoringPanel.update(this.colorModel);
        this.annotationsPanel.update(this.colorModel);
        this.currentProfile = this.colorModel.getCurrentProfile();
        if (this.colorModel.isCustomProfile(this.currentProfile)) {
            FontAndColorsPanel.loc(this.bDelete, "CTL_Delete");
        } else {
            FontAndColorsPanel.loc(this.bDelete, "CTL_Restore");
        }
        this.listen = false;
        Iterator iterator = this.colorModel.getProfiles().iterator();
        this.cbProfile.removeAllItems();
        while (iterator.hasNext()) {
            this.cbProfile.addItem(iterator.next());
        }
        this.listen = true;
        this.cbProfile.setSelectedItem(this.currentProfile);
    }

    void applyChanges() {
        this.highlightingPanel.applyChanges();
        this.syntaxColoringPanel.applyChanges();
        this.annotationsPanel.applyChanges();
        if (this.colorModel == null) {
            return;
        }
        this.colorModel.setCurrentProfile(this.currentProfile);
    }

    void cancel() {
        this.highlightingPanel.cancel();
        this.syntaxColoringPanel.cancel();
        this.annotationsPanel.cancel();
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        if (this.currentProfile != null && this.colorModel != null && !this.currentProfile.equals(this.colorModel.getCurrentProfile())) {
            return true;
        }
        if (this.highlightingPanel.isChanged()) {
            return true;
        }
        if (this.syntaxColoringPanel.isChanged()) {
            return true;
        }
        return this.annotationsPanel.isChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        if (actionEvent.getSource() == this.bDuplicate) {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(FontAndColorsPanel.loc("CTL_Create_New_Profile_Message"), FontAndColorsPanel.loc("CTL_Create_New_Profile_Title"));
            inputLine.setInputText(this.currentProfile);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (inputLine.getValue() == NotifyDescriptor.OK_OPTION) {
                String string = inputLine.getInputText();
                Iterator iterator = this.colorModel.getProfiles().iterator();
                while (iterator.hasNext()) {
                    if (!string.equals(iterator.next())) continue;
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)FontAndColorsPanel.loc("CTL_Duplicate_Profile_Name"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return;
                }
                this.setCurrentProfile(string);
                this.listen = false;
                this.cbProfile.addItem(inputLine.getInputText());
                this.cbProfile.setSelectedItem(inputLine.getInputText());
                this.listen = true;
            }
            return;
        }
        if (actionEvent.getSource() == this.bDelete) {
            this.deleteCurrentProfile();
            return;
        }
    }

    Collection getDefaults() {
        return this.syntaxColoringPanel.getAllLanguages();
    }

    Collection getHighlights() {
        return this.highlightingPanel.getHighlightings();
    }

    Collection getSyntaxColorings() {
        return this.syntaxColoringPanel.getSyntaxColorings();
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)FontAndColorsPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)FontAndColorsPanel.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)FontAndColorsPanel.loc(string));
        }
    }
}

