/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.text.IndentEngine;
import org.openide.util.Lookup;

class IndentationModel {
    private boolean originalExpandedTabs = this.isExpandTabs();
    private boolean originalAddStar = this.getJavaFormatLeadingStarInComment();
    private boolean originalNewLine = this.getJavaFormatNewlineBeforeBrace();
    private boolean originalSpace = this.getJavaFormatSpaceBeforeParenthesis();
    private int originalStatementIndent = this.getJavaFormatStatementContinuationIndent();
    private int originalIndent = this.getSpacesPerTab();
    private boolean changed = false;
    private IndentEngine javaIndentEngine = null;
    private ClassLoader classLoader;

    IndentationModel() {
    }

    boolean isExpandTabs() {
        return (Boolean)this.getParameter("isExpandTabs", Boolean.FALSE);
    }

    void setExpandTabs(boolean bl) {
        this.setParameter("setExpandTabs", bl, Boolean.TYPE);
        this.updateChanged();
    }

    boolean getJavaFormatLeadingStarInComment() {
        return (Boolean)this.getParameter("getJavaFormatLeadingStarInComment", Boolean.FALSE);
    }

    void setJavaFormatLeadingStarInComment(boolean bl) {
        this.setParameter("setJavaFormatLeadingStarInComment", bl, Boolean.TYPE);
        this.updateChanged();
    }

    boolean getJavaFormatSpaceBeforeParenthesis() {
        return (Boolean)this.getParameter("getJavaFormatSpaceBeforeParenthesis", Boolean.FALSE);
    }

    void setJavaFormatSpaceBeforeParenthesis(boolean bl) {
        this.setParameter("setJavaFormatSpaceBeforeParenthesis", bl, Boolean.TYPE);
        this.updateChanged();
    }

    boolean getJavaFormatNewlineBeforeBrace() {
        return (Boolean)this.getParameter("getJavaFormatNewlineBeforeBrace", Boolean.FALSE);
    }

    void setJavaFormatNewlineBeforeBrace(boolean bl) {
        this.setParameter("setJavaFormatNewlineBeforeBrace", bl, Boolean.TYPE);
        this.updateChanged();
    }

    Integer getJavaFormatStatementContinuationIndent() {
        return (Integer)this.getParameter("getJavaFormatStatementContinuationIndent", new Integer(4));
    }

    void setJavaFormatStatementContinuationIndent(Integer n) {
        if (n > 0) {
            this.setParameter("setJavaFormatStatementContinuationIndent", n, Integer.TYPE);
        }
        this.updateChanged();
    }

    Integer getSpacesPerTab() {
        return (Integer)this.getParameter("getSpacesPerTab", new Integer(4));
    }

    void setSpacesPerTab(Integer n) {
        if (n > 0) {
            this.setParameter("setSpacesPerTab", n, Integer.TYPE);
        }
        this.updateChanged();
    }

    boolean isChanged() {
        return this.changed;
    }

    void applyChanges() {
        this.applyParameterToAll("setJavaFormatLeadingStarInComment", this.getJavaFormatLeadingStarInComment(), Boolean.TYPE);
        this.applyParameterToAll("setJavaFormatNewlineBeforeBrace", this.getJavaFormatNewlineBeforeBrace(), Boolean.TYPE);
        this.applyParameterToAll("setJavaFormatSpaceBeforeParenthesis", this.getJavaFormatSpaceBeforeParenthesis(), Boolean.TYPE);
        this.applyParameterToAll("setJavaFormatStatementContinuationIndent", this.getJavaFormatStatementContinuationIndent(), Integer.TYPE);
        this.applyParameterToAll("setExpandTabs", this.isExpandTabs(), Boolean.TYPE);
        this.applyParameterToAll("setSpacesPerTab", this.getSpacesPerTab(), Integer.TYPE);
    }

    void revertChanges() {
        if (!this.changed) {
            return;
        }
        if (this.getJavaFormatLeadingStarInComment() != this.originalAddStar) {
            this.setJavaFormatLeadingStarInComment(this.originalAddStar);
        }
        if (this.getJavaFormatNewlineBeforeBrace() != this.originalNewLine) {
            this.setJavaFormatNewlineBeforeBrace(this.originalNewLine);
        }
        if (this.getJavaFormatSpaceBeforeParenthesis() != this.originalSpace) {
            this.setJavaFormatSpaceBeforeParenthesis(this.originalSpace);
        }
        if (this.isExpandTabs() != this.originalExpandedTabs) {
            this.setExpandTabs(this.originalExpandedTabs);
        }
        if (this.getJavaFormatStatementContinuationIndent() != this.originalStatementIndent && this.originalStatementIndent > 0) {
            this.setJavaFormatStatementContinuationIndent(new Integer(this.originalStatementIndent));
        }
        if (this.getSpacesPerTab() != this.originalIndent && this.originalIndent > 0) {
            this.setSpacesPerTab(new Integer(this.originalIndent));
        }
    }

    private void updateChanged() {
        this.changed = this.isExpandTabs() != this.originalExpandedTabs || this.getJavaFormatLeadingStarInComment() != this.originalAddStar || this.getJavaFormatNewlineBeforeBrace() != this.originalNewLine || this.getJavaFormatSpaceBeforeParenthesis() != this.originalSpace || this.getJavaFormatStatementContinuationIndent() != this.originalStatementIndent || this.getSpacesPerTab() != this.originalIndent;
    }

    private IndentEngine getDefaultIndentEngine() {
        if (this.javaIndentEngine == null) {
            BaseOptions baseOptions = IndentationModel.getOptions("text/x-java");
            if (baseOptions == null) {
                baseOptions = IndentationModel.getOptions("text/plain");
            }
            this.javaIndentEngine = baseOptions == null ? null : baseOptions.getIndentEngine();
        }
        return this.javaIndentEngine;
    }

    private Object getParameter(String string, Object object) {
        IndentEngine indentEngine = this.getDefaultIndentEngine();
        if (indentEngine != null) {
            try {
                Method method = indentEngine.getClass().getMethod(string, new Class[0]);
                return method.invoke((Object)indentEngine, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    private void setParameter(String string, Object object, Class clazz) {
        IndentEngine indentEngine = this.getDefaultIndentEngine();
        if (indentEngine != null) {
            try {
                Method method = indentEngine.getClass().getMethod(string, clazz);
                method.invoke((Object)indentEngine, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void applyParameterToAll(String string, Object object, Class clazz) {
        Object object2;
        BaseOptions baseOptions;
        Object object3;
        HashSet<IndentEngine> hashSet = new HashSet<IndentEngine>();
        Set set = EditorSettings.getDefault().getMimeTypes();
        Object object4 = set.iterator();
        while (object4.hasNext()) {
            object3 = (String)object4.next();
            baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)object3)).lookup(class$org$netbeans$modules$editor$options$BaseOptions == null ? IndentationModel.class$("org.netbeans.modules.editor.options.BaseOptions") : class$org$netbeans$modules$editor$options$BaseOptions);
            if (baseOptions == null) continue;
            object2 = baseOptions.getIndentEngine();
            hashSet.add((IndentEngine)object2);
            try {
                GenericDeclaration genericDeclaration;
                if (baseOptions.getClass().getName().equals("org.netbeans.modules.java.editor.options.JavaOptions") && !object2.getClass().getName().equals("org.netbeans.modules.editor.java.JavaIndentEngine")) {
                    genericDeclaration = this.getClassLoader().loadClass("org.netbeans.modules.editor.java.JavaIndentEngine");
                    object2 = (IndentEngine)Lookup.getDefault().lookup(genericDeclaration);
                    baseOptions.setIndentEngine((IndentEngine)object2);
                }
                if (baseOptions.getClass().getName().equals("org.netbeans.modules.web.core.syntax.JSPOptions") && !object2.getClass().getName().equals("org.netbeans.modules.web.core.syntax.JspIndentEngine")) {
                    genericDeclaration = this.getClassLoader().loadClass("org.netbeans.modules.web.core.syntax.JspIndentEngine");
                    object2 = (IndentEngine)Lookup.getDefault().lookup(genericDeclaration);
                    baseOptions.setIndentEngine((IndentEngine)object2);
                }
                genericDeclaration = object2.getClass().getMethod(string, clazz);
                ((Method)genericDeclaration).invoke(object2, object);
            }
            catch (Exception exception) {}
        }
        object4 = Lookup.getDefault().lookupAll(IndentEngine.class);
        object3 = object4.iterator();
        while (object3.hasNext()) {
            baseOptions = (IndentEngine)object3.next();
            if (hashSet.contains(baseOptions)) continue;
            try {
                object2 = baseOptions.getClass().getMethod(string, clazz);
                ((Method)object2).invoke((Object)baseOptions, object);
            }
            catch (Exception exception) {}
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        }
        return this.classLoader;
    }

    private static BaseOptions getOptions(String string) {
        return (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)string)).lookup(BaseOptions.class);
    }
}

