/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.CompoundAction;
import org.netbeans.modules.options.keymap.EditorBridge;
import org.netbeans.modules.options.keymap.LayersBridge;

public class KeymapModel {
    private static final Logger LOG = Logger.getLogger(KeymapModel.class.getName());
    private LayersBridge layersBridge = new LayersBridge();
    private EditorBridge editorBridge = new EditorBridge();
    private Map categoryToActions = new HashMap();
    private Map keyMaps = new HashMap();
    private Map keyMapDefaults = new HashMap();
    private Map sharedActions = new HashMap();

    public KeymapModel() {
        Iterator iterator = this.getActionCategories().iterator();
        while (iterator.hasNext()) {
            this.getActions((String)iterator.next());
        }
    }

    public Set getActionCategories() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.layersBridge.getActions().keySet());
        hashSet.addAll(this.editorBridge.getActions().keySet());
        return Collections.unmodifiableSet(hashSet);
    }

    public Set getActions(String string) {
        if (!this.categoryToActions.containsKey(string)) {
            Set set = new HashSet();
            Set set2 = (Set)this.layersBridge.getActions().get(string);
            if (set2 != null) {
                set.addAll(set2);
            }
            if ((set2 = (Set)this.editorBridge.getActions().get(string)) != null) {
                set = this.mergeActions(set2, set);
            }
            this.categoryToActions.put(string, set);
        }
        return (Set)this.categoryToActions.get(string);
    }

    public void refreshActions() {
        this.categoryToActions = new HashMap();
        this.editorBridge.refreshActions();
    }

    public String getCurrentProfile() {
        return this.editorBridge.getCurrentProfile();
    }

    public void setCurrentProfile(String string) {
        this.editorBridge.setCurrentProfile(string);
    }

    public List getProfiles() {
        return this.layersBridge.getProfiles();
    }

    public boolean isCustomProfile(String string) {
        return this.editorBridge.isCustomProfile(string);
    }

    public Map getKeymap(String string) {
        if (!this.keyMaps.containsKey(string)) {
            this.keyMaps.put(string, this.mergeShortcuts(this.editorBridge.readKeymap(string), this.layersBridge.getKeymap(string)));
        }
        return (Map)this.keyMaps.get(string);
    }

    public Map getKeymapDefaults(String string) {
        if (!this.keyMapDefaults.containsKey(string)) {
            this.keyMapDefaults.put(string, this.mergeShortcuts(this.editorBridge.readKeymapDefaults(string), this.layersBridge.getKeymapDefaults(string)));
        }
        return (Map)this.keyMapDefaults.get(string);
    }

    public void deleteProfile(String string) {
        this.layersBridge.deleteProfile(string);
        this.editorBridge.deleteProfile(string);
    }

    public void changeKeymap(String string, Map map) {
        this.log("changeKeymap.actionToShortcuts", map.entrySet());
        HashMap hashMap = new HashMap(this.getKeymap(string));
        hashMap.putAll(map);
        this.keyMaps.put(string, hashMap);
        this.log("changeKeymap.m", hashMap.entrySet());
        this.layersBridge.saveKeymap(string, hashMap);
        this.editorBridge.saveKeymap(string, hashMap);
    }

    private void log(String string, Collection collection) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        LOG.fine(string);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            LOG.fine("  " + e);
        }
    }

    private Set mergeActions(Collection collection, Collection collection2) {
        String string;
        ActionImpl actionImpl;
        Iterator iterator;
        HashSet<ActionImpl> hashSet = new HashSet<ActionImpl>();
        HashMap<String, ActionImpl> hashMap = new HashMap<String, ActionImpl>();
        if (collection != null) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                actionImpl = (ActionImpl)iterator.next();
                string = actionImpl.getDelegatingActionId();
                if (string != null) {
                    hashMap.put(string, actionImpl);
                    continue;
                }
                hashSet.add(actionImpl);
            }
        }
        if (collection2 != null) {
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                actionImpl = (ActionImpl)iterator.next();
                string = actionImpl.getId();
                if (!hashMap.containsKey(string)) {
                    hashSet.add(actionImpl);
                    continue;
                }
                ActionImpl actionImpl2 = (ActionImpl)hashMap.remove(string);
                CompoundAction compoundAction = new CompoundAction(actionImpl2, actionImpl);
                hashSet.add(compoundAction);
                this.sharedActions.put(actionImpl2, compoundAction);
                this.sharedActions.put(actionImpl, compoundAction);
            }
        }
        hashSet.addAll(hashMap.values());
        return hashSet;
    }

    private Map mergeShortcuts(Map map, Map map2) {
        Set set;
        ActionImpl actionImpl;
        HashMap<ActionImpl, Set> hashMap = new HashMap<ActionImpl, Set>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            actionImpl = (ActionImpl)iterator.next();
            set = (Set)map.get(actionImpl);
            if (this.sharedActions.containsKey(actionImpl)) {
                actionImpl = (CompoundAction)this.sharedActions.get(actionImpl);
            }
            hashMap.put(actionImpl, set);
        }
        iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            actionImpl = (ActionImpl)iterator.next();
            set = (Set)map2.get(actionImpl);
            if (this.sharedActions.containsKey(actionImpl)) {
                actionImpl = (CompoundAction)this.sharedActions.get(actionImpl);
            }
            hashMap.put(actionImpl, set);
        }
        return hashMap;
    }
}

