/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.KeymapPanel;
import org.netbeans.modules.options.keymap.ShortcutsDialog;
import org.netbeans.modules.options.keymap.Utils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class KeymapViewModel
implements TreeModel,
ShortcutsDialog.ShortcutsFinder {
    private Vector listeners = new Vector();
    private String currentProfile;
    private KeymapModel model = new KeymapModel();
    private Map categoryToActionsCache = new HashMap();
    private Map modifiedProfiles = new HashMap();
    private Set deletedProfiles = new HashSet();
    private Map shortcutsCache = new HashMap();
    static final ActionsComparator actionsComparator = new ActionsComparator();
    private Map categories;

    public KeymapViewModel() {
        this.currentProfile = this.model.getCurrentProfile();
    }

    public Object getRoot() {
        return "";
    }

    public Object getChild(Object object, int n) {
        return this.getItems((String)object).get(n);
    }

    public int getChildCount(Object object) {
        if (object instanceof String) {
            return this.getItems((String)object).size();
        }
        return 0;
    }

    public boolean isLeaf(Object object) {
        return !(object instanceof String);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getIndexOfChild(Object object, Object object2) {
        return this.getItems((String)object).indexOf(object2);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    private void treeChanged() {
        final Vector vector = (Vector)this.listeners.clone();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{""});
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    ((TreeModelListener)vector.get(i)).treeNodesChanged(treeModelEvent);
                }
            }
        });
    }

    private void nodeChanged(final TreePath treePath) {
        final Vector vector = (Vector)this.listeners.clone();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    ((TreeModelListener)vector.get(i)).treeNodesChanged(treeModelEvent);
                }
            }
        });
    }

    public Map getCategories() {
        if (this.categories == null) {
            this.categories = new TreeMap();
            ArrayList arrayList = new ArrayList(this.model.getActionCategories());
            Collections.sort(arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    ArrayList<String> arrayList2 = (ArrayList<String>)this.categories.get(string2);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<String>();
                        this.categories.put(string2, arrayList2);
                    }
                    String string4 = string2 = string2.length() == 0 ? string3 : string2 + '/' + string3;
                    if (!arrayList2.isEmpty() && arrayList2.get(arrayList2.size() - 1).equals(string2)) continue;
                    arrayList2.add(string2);
                }
            }
        }
        return this.categories;
    }

    public List getItems(String string) {
        ArrayList arrayList = (ArrayList)this.categoryToActionsCache.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            List list = (List)this.getCategories().get(string);
            if (list != null) {
                arrayList.addAll(list);
            }
            ArrayList arrayList2 = new ArrayList(this.model.getActions(string));
            Collections.sort(arrayList2, new ActionsComparator());
            arrayList.addAll(arrayList2);
            this.categoryToActionsCache.put(string, arrayList);
        }
        return arrayList;
    }

    List getProfiles() {
        HashSet hashSet = new HashSet(this.model.getProfiles());
        hashSet.addAll(this.modifiedProfiles.keySet());
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }

    boolean isCustomProfile(String string) {
        return this.model.isCustomProfile(string);
    }

    void deleteProfile(String string) {
        if (this.model.isCustomProfile(string)) {
            this.deletedProfiles.add(string);
            this.modifiedProfiles.remove(string);
        } else {
            Map map = this.model.getKeymapDefaults(string);
            map = KeymapViewModel.convertFromEmacs(map);
            this.modifiedProfiles.put(string, map);
            this.treeChanged();
        }
    }

    String getCurrentProfile() {
        return this.currentProfile;
    }

    void setCurrentProfile(String string) {
        this.currentProfile = string;
        this.treeChanged();
    }

    void cloneProfile(String string) {
        HashMap hashMap = new HashMap();
        this.cloneProfile("", hashMap);
        this.modifiedProfiles.put(string, hashMap);
    }

    private void cloneProfile(String string, Map map) {
        Iterator iterator = this.getItems(string).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof String) {
                this.cloneProfile((String)e, map);
                continue;
            }
            String[] stringArray = this.getShortcuts((ActionImpl)e);
            map.put(e, new HashSet<String>(Arrays.asList(stringArray)));
        }
    }

    public ActionImpl findActionForShortcut(String string) {
        return this.findActionForShortcut(string, "");
    }

    private ActionImpl findActionForShortcut(String string, String string2) {
        Iterator iterator = this.getItems(string2).iterator();
        while (iterator.hasNext()) {
            ActionImpl actionImpl;
            Object e = iterator.next();
            if (e instanceof String) {
                actionImpl = this.findActionForShortcut(string, (String)e);
                if (actionImpl == null) continue;
                return actionImpl;
            }
            actionImpl = (ActionImpl)e;
            String[] stringArray = this.getShortcuts(actionImpl);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (stringArray[i].equals(string)) {
                    return actionImpl;
                }
                if (!stringArray[i].equals(string + " ")) continue;
                return actionImpl;
            }
        }
        return null;
    }

    public ActionImpl findActionForId(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.findActionForId(string, "");
        }
        final ActionImpl[] actionImplArray = new ActionImpl[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    actionImplArray[0] = KeymapViewModel.this.findActionForId(string, "");
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return actionImplArray[0];
    }

    private ActionImpl findActionForId(String string, String string2) {
        Iterator iterator = this.getItems(string2).iterator();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            if (e instanceof String) {
                object = this.findActionForId(string, (String)e);
                if (object == null) continue;
                return object;
            }
            object = ((ActionImpl)e).getId();
            if (!string.equals(object)) continue;
            return (ActionImpl)e;
        }
        return null;
    }

    public String[] getShortcuts(ActionImpl actionImpl) {
        Set set;
        Map map;
        if (this.modifiedProfiles.containsKey(this.currentProfile) && (map = (Map)this.modifiedProfiles.get(this.currentProfile)).containsKey(actionImpl)) {
            Set set2 = (Set)map.get(actionImpl);
            return set2.toArray(new String[set2.size()]);
        }
        if (!this.shortcutsCache.containsKey(this.currentProfile)) {
            map = KeymapViewModel.convertFromEmacs(this.model.getKeymap(this.currentProfile));
            this.shortcutsCache.put(this.currentProfile, map);
        }
        if ((set = (Set)(map = (Map)this.shortcutsCache.get(this.currentProfile)).get(actionImpl)) == null) {
            return new String[0];
        }
        return set.toArray(new String[set.size()]);
    }

    void addShortcut(TreePath treePath, String string) {
        ActionImpl actionImpl = this.findActionForShortcut(string);
        if (actionImpl != null) {
            this.removeShortcut(actionImpl, string);
        }
        actionImpl = (ActionImpl)treePath.getLastPathComponent();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        hashSet.addAll(Arrays.asList(this.getShortcuts(actionImpl)));
        this.setShortcuts(actionImpl, hashSet);
        this.nodeChanged(treePath);
    }

    public void setShortcuts(ActionImpl actionImpl, Set set) {
        HashMap<ActionImpl, Set> hashMap = (HashMap<ActionImpl, Set>)this.modifiedProfiles.get(this.currentProfile);
        if (hashMap == null) {
            hashMap = new HashMap<ActionImpl, Set>();
            this.modifiedProfiles.put(this.currentProfile, hashMap);
        }
        hashMap.put(actionImpl, set);
    }

    void removeShortcut(TreePath treePath, String string) {
        ActionImpl actionImpl = (ActionImpl)treePath.getLastPathComponent();
        this.removeShortcut(actionImpl, string);
        this.nodeChanged(treePath);
    }

    private void removeShortcut(ActionImpl actionImpl, String string) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.getShortcuts(actionImpl)));
        hashSet.remove(string);
        HashMap<ActionImpl, HashSet<String>> hashMap = (HashMap<ActionImpl, HashSet<String>>)this.modifiedProfiles.get(this.currentProfile);
        if (hashMap == null) {
            hashMap = new HashMap<ActionImpl, HashSet<String>>();
            this.modifiedProfiles.put(this.currentProfile, hashMap);
        }
        hashMap.put(actionImpl, hashSet);
    }

    public void refreshActions() {
        this.categoryToActionsCache = new HashMap();
        this.model.refreshActions();
    }

    public void apply() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                String string;
                Iterator<Object> iterator = KeymapViewModel.this.modifiedProfiles.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    Map map = (Map)KeymapViewModel.this.modifiedProfiles.get(string);
                    map = KeymapViewModel.convertToEmacs(map);
                    KeymapViewModel.this.model.changeKeymap(string, map);
                }
                iterator = KeymapViewModel.this.deletedProfiles.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    KeymapViewModel.this.model.deleteProfile(string);
                }
                KeymapViewModel.this.model.setCurrentProfile(KeymapViewModel.this.currentProfile);
                KeymapViewModel.this.modifiedProfiles = new HashMap();
                KeymapViewModel.this.deletedProfiles = new HashSet();
                KeymapViewModel.this.shortcutsCache = new HashMap();
                KeymapViewModel.this.model = new KeymapModel();
            }
        });
    }

    public boolean isChanged() {
        return !this.modifiedProfiles.isEmpty() || !this.deletedProfiles.isEmpty();
    }

    public void cancel() {
        this.modifiedProfiles = new HashMap();
        this.deletedProfiles = new HashSet();
        this.shortcutsCache = new HashMap();
        this.setCurrentProfile(this.model.getCurrentProfile());
        this.model = new KeymapModel();
    }

    private static Map convertToEmacs(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Set set = (Set)map.get(k);
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                KeyStroke[] keyStrokeArray;
                String string = (String)iterator2.next();
                if (string.length() == 0 || (keyStrokeArray = KeymapViewModel.getKeyStrokes(string, " ")) == null) continue;
                StringBuffer stringBuffer = new StringBuffer(Utilities.keyToString((KeyStroke)keyStrokeArray[0]));
                int n = keyStrokeArray.length;
                for (int i = 1; i < n; ++i) {
                    stringBuffer.append(' ').append(Utilities.keyToString((KeyStroke)keyStrokeArray[i]));
                }
                hashSet.add(stringBuffer.toString());
            }
            hashMap.put(k, hashSet);
        }
        return hashMap;
    }

    private static Map convertFromEmacs(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            ActionImpl actionImpl = (ActionImpl)iterator.next();
            Set set = (Set)map.get(actionImpl);
            Iterator iterator2 = set.iterator();
            HashSet<String> hashSet = new HashSet<String>();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                KeyStroke[] keyStrokeArray = Utilities.stringToKeys((String)string);
                hashSet.add(Utils.getKeyStrokesAsText(keyStrokeArray, " "));
            }
            hashMap.put(actionImpl, hashSet);
        }
        return hashMap;
    }

    private static KeyStroke[] getKeyStrokes(String string, String string2) {
        if (string.length() == 0) {
            return new KeyStroke[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            KeyStroke keyStroke = Utils.getKeyStroke(string3);
            if (keyStroke == null) {
                return null;
            }
            arrayList.add(keyStroke);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)KeymapPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)KeymapViewModel.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)KeymapViewModel.loc(string));
        }
    }

    static class ActionsComparator
    implements Comparator {
        ActionsComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof String) {
                if (object2 instanceof String) {
                    return ((String)object).compareTo((String)object2);
                }
                return 1;
            }
            if (object2 instanceof String) {
                return -1;
            }
            return ((ActionImpl)object).getDisplayName().compareTo(((ActionImpl)object2).getDisplayName());
        }
    }
}

