/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.macros;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.macros.MacrosPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class MacrosModel {
    private KeymapViewModel keymapModel;
    private Map macroNameToText;
    private DefaultTableModel tableModel;
    private boolean changed = false;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$BaseOptions;

    MacrosModel(Lookup lookup) {
        this.keymapModel = (KeymapViewModel)lookup.lookup(KeymapViewModel.class);
        this.init();
    }

    private void init() {
        Object object;
        Object object2;
        this.macroNameToText = new HashMap();
        Set set = EditorSettings.getDefault().getMimeTypes();
        Object object3 = set.iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)object2)).lookup(class$org$netbeans$modules$editor$options$BaseOptions == null ? MacrosModel.class$("org.netbeans.modules.editor.options.BaseOptions") : class$org$netbeans$modules$editor$options$BaseOptions);
            if (object == null) continue;
            this.macroNameToText.putAll(object.getMacroMap());
        }
        this.macroNameToText.remove(null);
        object3 = new Vector();
        object2 = this.macroNameToText.keySet().iterator();
        while (object2.hasNext()) {
            String[] stringArray;
            object = (String)object2.next();
            String string = "";
            ActionImpl actionImpl = this.keymapModel.findActionForId("macro-" + (String)object);
            if (actionImpl == null) {
                actionImpl = this.keymapModel.findActionForId((String)object);
            }
            if (actionImpl != null && (stringArray = this.keymapModel.getShortcuts(actionImpl)).length > 0) {
                string = stringArray[0];
            }
            stringArray = new Vector();
            stringArray.add(object);
            stringArray.add(string);
            ((Vector)object3).add(stringArray);
        }
        Collections.sort(object3, new MComparator());
        object2 = new Vector<String>(2);
        ((Vector)object2).add(MacrosModel.loc("Macro_Name_Title"));
        ((Vector)object2).add(MacrosModel.loc("Macro_Code_Title"));
        this.tableModel = new DefaultTableModel((Vector)object3, (Vector)object2){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.tableModel.getColumnName(2);
    }

    DefaultTableModel getShortcutsTableModel() {
        return this.tableModel;
    }

    boolean isChanged() {
        return this.changed;
    }

    Collection getMacroNames() {
        return Collections.unmodifiableCollection(this.macroNameToText.keySet());
    }

    String getMacroText(String string) {
        return (String)this.macroNameToText.get(string);
    }

    void addMacro(String string, String string2) {
        this.tableModel.insertRow(0, new Object[]{string, string2});
        this.macroNameToText.put(string, string2);
    }

    void removeMacro(int n) {
        String string = (String)this.tableModel.getValueAt(n, 0);
        this.macroNameToText.remove(string);
        this.tableModel.removeRow(n);
        this.keymapModel.refreshActions();
        ActionImpl actionImpl = this.keymapModel.findActionForId("macro-" + string);
        if (actionImpl != null) {
            this.keymapModel.setShortcuts(actionImpl, Collections.emptySet());
        }
        this.changed = true;
    }

    void setMacroText(String string, String string2) {
        if (this.macroNameToText.containsKey(string) && string2.equals(this.macroNameToText.get(string))) {
            return;
        }
        this.macroNameToText.put(string, string2);
        this.changed = true;
    }

    void setShortcut(int n, String string) {
        this.tableModel.setValueAt(string, n, 1);
        this.saveMacros();
        this.keymapModel.refreshActions();
        ActionImpl actionImpl = this.keymapModel.findActionForId("macro-" + this.tableModel.getValueAt(n, 0));
        this.keymapModel.setShortcuts(actionImpl, Collections.singleton(string));
        this.changed = true;
    }

    void applyChanges() {
        this.saveMacros();
        this.keymapModel.apply();
        this.changed = false;
    }

    void cancel() {
        this.init();
        this.changed = false;
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)MacrosPanel.class, (String)string);
    }

    private void saveMacros() {
        Set set = EditorSettings.getDefault().getMimeTypes();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            BaseOptions baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)string)).lookup(class$org$netbeans$modules$editor$options$BaseOptions == null ? MacrosModel.class$("org.netbeans.modules.editor.options.BaseOptions") : class$org$netbeans$modules$editor$options$BaseOptions);
            if (baseOptions == null) continue;
            baseOptions.setMacroMap(new HashMap(this.macroNameToText));
        }
    }

    private static class MComparator
    implements Comparator {
        private MComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = (String)((Vector)object).get(0);
            String string2 = (String)((Vector)object2).get(0);
            return string.compareTo(string2);
        }
    }
}

