/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.AWTTask;
import org.openide.awt.Actions;
import org.openide.awt.DynaMenuModel;
import org.openide.awt.ExecBridge;
import org.openide.awt.Mnemonics;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceSupport;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuBar
extends JMenuBar
implements Externalizable {
    private MenuBarFolder menuBarFolder;
    static final long serialVersionUID = -4721949937356581268L;

    public MenuBar() {
    }

    public MenuBar(DataFolder dataFolder) {
        this();
        DataFolder dataFolder2;
        boolean bl = "GTK".equals(UIManager.getLookAndFeel().getID());
        if (!bl) {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        if ((dataFolder2 = dataFolder) == null) {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Menu");
            if (fileObject == null) {
                throw new IllegalStateException("No Menu/");
            }
            dataFolder2 = DataFolder.findFolder(fileObject);
        }
        this.startLoading(dataFolder2);
        if (dataFolder != null) {
            this.getAccessibleContext().setAccessibleDescription(dataFolder.getName());
        }
    }

    @Override
    public void addImpl(Component component, Object object, int n) {
        if (Utilities.isMac() && Boolean.getBoolean("apple.laf.useScreenMenuBar") && !(component instanceof JMenu)) {
            return;
        }
        super.addImpl(component, object, n);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (Utilities.isMac()) {
            boolean bl2;
            int n2 = keyEvent.getModifiers();
            boolean bl3 = (n2 & 2) != 0;
            boolean bl4 = bl2 = (n2 & 8) != 0;
            if (bl2) {
                return false;
            }
            if (bl2 && !bl3) {
                n2 &= 0xFFFFFFF7;
                n2 &= 0xFFFFFDFF;
                n2 |= 2;
                n2 |= 0x80;
            } else if (!bl2 && bl3) {
                n2 &= 0xFFFFFFFD;
                n2 &= 0xFFFFFF7F;
                n2 |= 8;
                n2 |= 0x200;
            } else if (!bl2 && !bl3) {
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }
            MarkedKeyEvent markedKeyEvent = new MarkedKeyEvent((Component)keyEvent.getSource(), keyEvent.getID(), keyEvent.getWhen(), n2, keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation());
            KeyStroke keyStroke2 = keyEvent.getID() == 400 ? KeyStroke.getKeyStroke((int)keyStroke.getKeyChar(), n2) : KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n2, !keyStroke.isOnKeyRelease());
            boolean bl5 = super.processKeyBinding(keyStroke2, markedKeyEvent, n, bl);
            if (markedKeyEvent.isConsumed()) {
                keyEvent.consume();
            }
            return bl5;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void waitFinished() {
        this.menuBarFolder.instanceFinished();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.menuBarFolder.getFolder());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.startLoading((DataFolder)objectInput.readObject());
    }

    void startLoading(DataFolder dataFolder) {
        this.menuBarFolder = new MenuBarFolder(dataFolder);
    }

    static void allInstances(InstanceCookie[] instanceCookieArray, List<Object> list) {
        Exception exception = null;
        for (int i = 0; i < instanceCookieArray.length; ++i) {
            Object object;
            Exception exception2 = null;
            try {
                object = instanceCookieArray[i].instanceCreate();
                list.add(object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                exception2 = classNotFoundException;
            }
            catch (IOException iOException) {
                exception2 = iOException;
            }
            if (exception2 == null) continue;
            object = exception2;
            while (true) {
                if (((Throwable)object).getCause() == null) break;
                object = ((Throwable)object).getCause();
            }
            ((Throwable)object).initCause(exception);
            exception = exception2;
        }
        if (exception != null) {
            Exceptions.printStackTrace(exception);
        }
    }

    private static class LazyMenu
    extends JMenu
    implements NodeListener,
    Runnable,
    ChangeListener {
        DataFolder master;
        boolean icon;
        MenuFolder slave;
        DynaMenuModel dynaModel;
        private boolean selected = false;

        public LazyMenu(DataFolder dataFolder, boolean bl) {
            this.master = dataFolder;
            this.icon = bl;
            this.dynaModel = new DynaMenuModel();
            this.slave = new MenuFolder();
            Node node = this.master.getNodeDelegate();
            node.addNodeListener(NodeOp.weakNodeListener((NodeListener)this, (Object)node));
            this.updateProps();
            this.getModel().addChangeListener(this);
        }

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            if (Utilities.isMac()) {
                boolean bl2;
                int n2 = keyEvent.getModifiers();
                boolean bl3 = (n2 & 2) != 0;
                boolean bl4 = bl2 = (n2 & 8) != 0;
                if (bl2 && keyEvent instanceof MarkedKeyEvent) {
                    n2 &= 0xFFFFFFFD;
                    n2 &= 0xFFFFFF7F;
                    n2 |= 8;
                    MarkedKeyEvent markedKeyEvent = new MarkedKeyEvent((Component)keyEvent.getSource(), keyEvent.getID(), keyEvent.getWhen(), n2 |= 0x200, keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation());
                    KeyStroke keyStroke2 = keyEvent.getID() == 400 ? KeyStroke.getKeyStroke((int)keyStroke.getKeyChar(), n2) : KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n2, !keyStroke.isOnKeyRelease());
                    boolean bl5 = super.processKeyBinding(keyStroke2, markedKeyEvent, n, bl);
                    if (markedKeyEvent.isConsumed()) {
                        keyEvent.consume();
                    }
                    return bl5;
                }
                if (!bl2) {
                    return super.processKeyBinding(keyStroke, keyEvent, n, bl);
                }
                return false;
            }
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        private void updateProps() {
            if (this.master.isValid()) {
                Node node = this.master.getNodeDelegate();
                Mnemonics.setLocalizedText((AbstractButton)this, (String)node.getDisplayName());
                if (this.icon) {
                    this.setIcon(new ImageIcon(node.getIcon(1)));
                }
            } else {
                this.setText(this.master.getName());
                this.setIcon(null);
            }
        }

        public void run() {
            this.updateProps();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("displayName".equals(propertyChangeEvent.getPropertyName()) || "name".equals(propertyChangeEvent.getPropertyName()) || "icon".equals(propertyChangeEvent.getPropertyName())) {
                if (EventQueue.isDispatchThread()) {
                    this.updateProps();
                } else {
                    EventQueue.invokeLater(this);
                }
            }
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (this.selected) {
                this.selected = false;
            } else {
                this.selected = true;
                this.doInitialize();
                this.dynaModel.checkSubmenu(this);
            }
        }

        private void doInitialize() {
            this.slave.waitFinishedSuper();
        }

        private class MenuFolder
        extends FolderInstance {
            public MenuFolder() {
                super(LazyMenu.this.master);
            }

            public String instanceName() {
                return LazyMenu.class.getName();
            }

            public Class instanceClass() {
                return JMenu.class;
            }

            public Object instanceCreate() throws IOException, ClassNotFoundException {
                return LazyMenu.this;
            }

            public void waitFinished() {
            }

            void waitFinishedSuper() {
                super.waitFinished();
            }

            protected InstanceCookie acceptDataObject(DataObject dataObject) {
                InstanceCookie instanceCookie = super.acceptDataObject(dataObject);
                if (instanceCookie == null) {
                    JMenuItem jMenuItem = ExecBridge.createMenuItem(dataObject);
                    return jMenuItem != null ? new InstanceSupport.Instance(jMenuItem) : null;
                }
                return instanceCookie;
            }

            protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
                Class clazz = instanceCookie.instanceClass();
                boolean bl = Presenter.Menu.class.isAssignableFrom(clazz) || JMenuItem.class.isAssignableFrom(clazz) || JSeparator.class.isAssignableFrom(clazz) || Action.class.isAssignableFrom(clazz);
                return bl ? instanceCookie : null;
            }

            protected InstanceCookie acceptFolder(DataFolder dataFolder) {
                boolean bl = dataFolder.getPrimaryFile().getAttribute("SystemFileSystem.icon") != null;
                return new LazyMenu((DataFolder)dataFolder, (boolean)bl).slave;
            }

            protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
                LazyMenu lazyMenu = LazyMenu.this;
                LinkedList<Object> linkedList = new LinkedList<Object>();
                MenuBar.allInstances(instanceCookieArray, linkedList);
                lazyMenu.removeAll();
                if (linkedList.isEmpty()) {
                    JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(DataObject.class, (String)"CTL_EmptyMenu"));
                    jMenuItem.setEnabled(false);
                    lazyMenu.add(jMenuItem);
                }
                lazyMenu.dynaModel.loadSubmenu(linkedList, lazyMenu);
                return lazyMenu;
            }

            protected Task postCreationTask(Runnable runnable) {
                return new AWTTask(runnable);
            }
        }
    }

    private static final class MarkedKeyEvent
    extends KeyEvent {
        public MarkedKeyEvent(Component component, int n, long l, int n2, int n3, char c, int n4) {
            super(component, n, l, n2, n3, c, n4);
        }
    }

    private final class MenuBarFolder
    extends FolderInstance {
        private ArrayList<Component> managed;

        public MenuBarFolder(DataFolder dataFolder) {
            super(dataFolder);
            this.managed = new ArrayList();
            this.recreate();
        }

        private void cleanUp() {
            Iterator<Component> iterator = this.managed.iterator();
            while (iterator.hasNext()) {
                MenuBar.this.remove(iterator.next());
            }
            this.managed.clear();
        }

        private void addComponent(Component component) {
            MenuBar.this.add(component, this.managed.size());
            this.managed.add(component);
        }

        public String instanceName() {
            return MenuBar.class.getName();
        }

        public Class instanceClass() {
            return MenuBar.class;
        }

        protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            Class clazz = instanceCookie.instanceClass();
            boolean bl = Component.class.isAssignableFrom(clazz) || Presenter.Toolbar.class.isAssignableFrom(clazz) || Action.class.isAssignableFrom(clazz);
            return bl ? instanceCookie : null;
        }

        protected InstanceCookie acceptFolder(DataFolder dataFolder) {
            return new LazyMenu((DataFolder)dataFolder, (boolean)false).slave;
        }

        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            MenuBar.allInstances(instanceCookieArray, linkedList);
            MenuBar menuBar = MenuBar.this;
            if (linkedList.equals(Arrays.asList(menuBar.getComponents()))) {
                return menuBar;
            }
            this.cleanUp();
            for (Object e : linkedList) {
                Component component = this.convertToComponent(e);
                if (component == null) continue;
                this.addComponent(component);
            }
            menuBar.validate();
            menuBar.repaint();
            return menuBar;
        }

        private Component convertToComponent(Object object) {
            Component component = null;
            if (object instanceof Component) {
                component = (Component)object;
            } else if (object instanceof Presenter.Toolbar) {
                component = ((Presenter.Toolbar)object).getToolbarPresenter();
            } else if (object instanceof Action) {
                Action action = (Action)object;
                JButton jButton = new JButton();
                Actions.connect((AbstractButton)jButton, (Action)action);
                component = jButton;
            }
            if (component instanceof JButton) {
                ((JButton)component).setBorderPainted(false);
                ((JButton)component).setMargin(new Insets(0, 2, 0, 2));
            }
            return component;
        }

        DataFolder getFolder() {
            return this.folder;
        }

        protected Task postCreationTask(Runnable runnable) {
            return new AWTTask(runnable);
        }
    }
}

