/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLdrActions;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectPool;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.SafeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataLoader
extends SharedClassObject {
    static final Logger ERR = Logger.getLogger("org.openide.loaders.DataLoader");
    private static final long serialVersionUID = 1986614061378346169L;
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_ACTIONS = "actions";
    private static final String PROP_DEF_ACTIONS = "defaultActions";
    private static final Object ACTION_MANAGER = new Object();
    private static final Object PROP_REPRESENTATION_CLASS = new Object();
    private static final Object PROP_REPRESENTATION_CLASS_NAME = new Object();
    private static final int LOADER_VERSION = 1;

    @Deprecated
    protected DataLoader(Class<? extends DataObject> clazz) {
        this.putProperty(PROP_REPRESENTATION_CLASS, clazz);
        this.putProperty(PROP_REPRESENTATION_CLASS_NAME, clazz.getName());
        if (clazz.getClassLoader() == ((Object)((Object)this)).getClass().getClassLoader()) {
            ERR.warning("Use of super(" + clazz.getName() + ".class) in " + ((Object)((Object)this)).getClass().getName() + "() should be replaced with super(\"" + clazz.getName() + "\") to reduce unnecessary class loading");
        }
    }

    protected DataLoader(String string) {
        this.putProperty(PROP_REPRESENTATION_CLASS_NAME, string);
    }

    public final Class<? extends DataObject> getRepresentationClass() {
        Class<DataObject> clazz;
        Class clazz2 = (Class)this.getProperty(PROP_REPRESENTATION_CLASS);
        if (clazz2 != null) {
            return clazz2.asSubclass(DataObject.class);
        }
        String string = (String)this.getProperty(PROP_REPRESENTATION_CLASS_NAME);
        try {
            clazz = Class.forName(string, false, ((Object)((Object)this)).getClass().getClassLoader()).asSubclass(DataObject.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException.toString());
        }
        this.putProperty(PROP_REPRESENTATION_CLASS, clazz);
        return clazz;
    }

    public final String getRepresentationClassName() {
        return (String)this.getProperty(PROP_REPRESENTATION_CLASS_NAME);
    }

    public final SystemAction[] getActions() {
        Action[] actionArray = this.getSwingActions();
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>();
        for (int i = 0; i < actionArray.length; ++i) {
            if (!(actionArray[i] instanceof SystemAction) && actionArray[i] != null) continue;
            arrayList.add((SystemAction)actionArray[i]);
        }
        return arrayList.toArray(new SystemAction[arrayList.size()]);
    }

    final Action[] getSwingActions() {
        DataLdrActions dataLdrActions = this.findManager();
        if (dataLdrActions != null) {
            Action[] actionArray;
            try {
                actionArray = (Action[])dataLdrActions.instanceCreate();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                actionArray = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
                actionArray = null;
            }
            if (actionArray == null) {
                return new Action[0];
            }
            return actionArray;
        }
        SystemAction[] systemActionArray = (SystemAction[])this.getProperty(PROP_ACTIONS);
        if (systemActionArray == null && (systemActionArray = (SystemAction[])this.getProperty(PROP_DEF_ACTIONS)) == null) {
            systemActionArray = this.defaultActions();
            this.putProperty(PROP_DEF_ACTIONS, systemActionArray, false);
        }
        return systemActionArray;
    }

    protected String actionsContext() {
        return null;
    }

    protected SystemAction[] defaultActions() {
        SystemAction[] systemActionArray = NodeOp.getDefaultActions();
        return systemActionArray;
    }

    private final DataLdrActions findManager() {
        Object object = this.getProperty(ACTION_MANAGER);
        if (object instanceof Class) {
            return null;
        }
        DataLdrActions dataLdrActions = (DataLdrActions)((Object)object);
        boolean bl = false;
        if (dataLdrActions == null) {
            SystemAction[] systemActionArray;
            String string = this.actionsContext();
            if (string == null) {
                this.putProperty(ACTION_MANAGER, ((Object)((Object)this)).getClass());
                return null;
            }
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
            if (fileObject == null) {
                fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
                try {
                    fileObject = FileUtil.createFolder((FileObject)fileObject, (String)string);
                }
                catch (IOException iOException) {
                    ERR.log(Level.WARNING, null, iOException);
                }
                bl = true;
            }
            dataLdrActions = new DataLdrActions(DataFolder.findFolder(fileObject), this);
            if (bl && (systemActionArray = this.defaultActions()) != null) {
                dataLdrActions.setActions(systemActionArray);
            }
            this.putProperty(ACTION_MANAGER, (Object)dataLdrActions);
        }
        return dataLdrActions;
    }

    final void waitForActions() {
        DataLdrActions dataLdrActions = this.findManager();
        if (dataLdrActions != null) {
            dataLdrActions.waitFinished();
        }
    }

    public final void setActions(SystemAction[] systemActionArray) {
        DataLdrActions dataLdrActions = this.findManager();
        if (dataLdrActions != null) {
            dataLdrActions.setActions(systemActionArray);
        } else {
            this.putProperty(PROP_ACTIONS, systemActionArray, true);
        }
    }

    final void setSwingActions(List list) {
        this.firePropertyChange(PROP_ACTIONS, null, null);
    }

    public final String getDisplayName() {
        String string = (String)this.getProperty(PROP_DISPLAY_NAME);
        if (string != null) {
            return string;
        }
        string = this.defaultDisplayName();
        if (string != null) {
            return string;
        }
        return this.getRepresentationClassName();
    }

    protected final void setDisplayName(String string) {
        this.putProperty(PROP_DISPLAY_NAME, string, true);
    }

    protected String defaultDisplayName() {
        return NbBundle.getBundle(DataLoader.class).getString("LBL_loader_display_name");
    }

    public final DataObject findDataObject(FileObject fileObject, RecognizedFiles recognizedFiles) throws IOException {
        try {
            return DataObjectPool.handleFindDataObject(this, fileObject, recognizedFiles);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getClass().getName().startsWith("org.openide.util.lookup")) {
                throw runtimeException;
            }
            IOException iOException = new IOException(runtimeException.toString());
            Logger.getLogger(DataLoader.class.getName()).log(Level.WARNING, null, runtimeException);
            iOException.initCause(runtimeException);
            throw iOException;
        }
    }

    protected abstract DataObject handleFindDataObject(FileObject var1, RecognizedFiles var2) throws IOException;

    public final void markFile(FileObject fileObject) throws IOException {
        DataLoaderPool.setPreferredLoader(fileObject, this);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Object object;
        objectOutput.writeObject(new Integer(1));
        SystemAction[] systemActionArray = (SystemAction[])this.getProperty(PROP_ACTIONS);
        if (systemActionArray == null) {
            objectOutput.writeObject(null);
        } else {
            object = new LinkedList();
            for (int i = 0; i < systemActionArray.length; ++i) {
                if (systemActionArray[i] == null) {
                    object.add(null);
                    continue;
                }
                object.add(systemActionArray[i].getClass().getName());
            }
            objectOutput.writeObject(object.toArray());
        }
        object = (String)this.getProperty(PROP_DISPLAY_NAME);
        if (object == null) {
            object = "";
        }
        objectOutput.writeUTF((String)object);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object;
        Object object2;
        ClassNotFoundException classNotFoundException = null;
        int n = 0;
        Object object3 = objectInput.readObject();
        if (object3 instanceof Integer) {
            n = (Integer)object3;
            object3 = objectInput.readObject();
        }
        Object[] objectArray = (Object[])object3;
        boolean bl = true;
        SystemAction[] systemActionArray = this.getActions();
        if (n > 0 || n == 0 && objectArray.length != systemActionArray.length) {
            bl = false;
        }
        if (objectArray != null) {
            object2 = new ArrayList(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                Serializable serializable;
                if (objectArray[i] == null) {
                    object2.add(null);
                    if (n != 0 || !bl || systemActionArray[i] == null) continue;
                    bl = false;
                    continue;
                }
                try {
                    object = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    if (object == null) {
                        object = ((Object)((Object)this)).getClass().getClassLoader();
                    }
                    serializable = Class.forName(Utilities.translate((String)((String)objectArray[i])), false, (ClassLoader)object).asSubclass(SystemAction.class);
                    SystemAction systemAction = SystemAction.get((Class)serializable);
                    object2.add(systemAction);
                    if (n != 0 || !bl || systemActionArray[i].equals((Object)systemAction)) continue;
                    bl = false;
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    if (classNotFoundException == null) {
                        classNotFoundException = classNotFoundException2;
                        continue;
                    }
                    serializable = classNotFoundException;
                    while (serializable.getCause() != null) {
                        serializable = serializable.getCause();
                    }
                    serializable.initCause(classNotFoundException2);
                }
            }
            if (classNotFoundException == null && !bl) {
                this.setActions(object2.toArray(new SystemAction[object2.size()]));
            }
        }
        if (((String)(object2 = objectInput.readUTF())).equals("") || n == 0 && ((String)object2).equals(this.defaultDisplayName())) {
            object2 = null;
        }
        this.setDisplayName((String)object2);
        if (classNotFoundException != null) {
            SafeException safeException = new SafeException(classNotFoundException);
            object = NbBundle.getMessage(DataLoader.class, (String)"EXC_missing_actions_in_loader", (Object)this.getDisplayName());
            Exceptions.attachLocalizedMessage((Throwable)safeException, (String)object);
            throw safeException;
        }
    }

    protected boolean clearSharedData() {
        return false;
    }

    public static <T extends DataLoader> T getLoader(Class<T> clazz) {
        return (T)((Object)((DataLoader)DataLoader.findObject(clazz, (boolean)true)));
    }

    public static interface RecognizedFiles {
        public void markRecognized(FileObject var1);
    }
}

