/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.javadoc.Doc;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.navigation.CaretListeningFactory;
import org.netbeans.modules.java.navigation.DeclarationTopComponent;
import org.netbeans.modules.java.navigation.JavadocTopComponent;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaretListeningTask
implements CancellableTask<CompilationInfo> {
    private CaretListeningFactory caretListeningFactory;
    private FileObject fileObject;
    private boolean canceled;
    private ElementHandle<Element> lastEh;

    CaretListeningTask(CaretListeningFactory caretListeningFactory, FileObject fileObject) {
        this.caretListeningFactory = caretListeningFactory;
        this.fileObject = fileObject;
    }

    public void run(CompilationInfo compilationInfo) {
        this.resume();
        boolean bl = false;
        boolean bl2 = JavadocTopComponent.shouldUpdate();
        boolean bl3 = DeclarationTopComponent.shouldUpdate();
        if (this.isCancelled() || !bl && !bl2 && !bl3) {
            return;
        }
        TreePath treePath = compilationInfo.getTreeUtilities().pathFor(CaretListeningFactory.getLastPosition((FileObject)this.fileObject));
        if (this.isCancelled()) {
            return;
        }
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (this.isCancelled() || element == null) {
            return;
        }
        if (bl) {
            this.updateNavigatorSelection();
        }
        if (this.isCancelled()) {
            return;
        }
        if (this.lastEh != null && this.lastEh.signatureEquals(element)) {
            return;
        }
        switch (element.getKind()) {
            case PACKAGE: 
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case METHOD: 
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: 
            case FIELD: 
            case ENUM_CONSTANT: {
                this.lastEh = ElementHandle.create((Element)element);
                this.setDeclaration("");
                this.setJavadoc("", "");
                break;
            }
            default: {
                this.setDeclaration("");
                this.setJavadoc("", "");
            }
        }
        if (bl2) {
            this.computeAndSetJavadoc(compilationInfo, element);
        }
        if (this.isCancelled()) {
            return;
        }
        if (bl3) {
            this.computeAndSetDeclaration(compilationInfo, element);
        }
    }

    private void setDeclaration(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DeclarationTopComponent declarationTopComponent = DeclarationTopComponent.findInstance();
                if (declarationTopComponent != null && declarationTopComponent.isOpened()) {
                    declarationTopComponent.setDeclaration(string);
                }
            }
        });
    }

    private void setJavadoc(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavadocTopComponent javadocTopComponent = JavadocTopComponent.findInstance();
                if (javadocTopComponent != null && javadocTopComponent.isOpened()) {
                    javadocTopComponent.setJavadoc(string, string2);
                }
            }
        });
    }

    public final synchronized void cancel() {
        this.canceled = true;
    }

    protected final synchronized boolean isCancelled() {
        return this.canceled;
    }

    protected final synchronized void resume() {
        this.canceled = false;
    }

    private void computeAndSetJavadoc(CompilationInfo compilationInfo, Element element) {
        String string;
        if (element.getKind() == ElementKind.PACKAGE) {
            string = "";
        } else {
            Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
            String string2 = string = doc == null ? "" : doc.getRawCommentText();
        }
        if (this.isCancelled()) {
            return;
        }
        this.setJavadoc(element.toString(), string);
    }

    private void computeAndSetDeclaration(CompilationInfo compilationInfo, Element element) {
        if (element.getKind() == ElementKind.PACKAGE) {
            this.setDeclaration("package " + element.toString() + ";");
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        Tree tree = compilationInfo.getTrees().getTree(element);
        if (this.isCancelled()) {
            return;
        }
        if (tree != null) {
            String string = tree.toString();
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                String string2 = element.getEnclosingElement().getSimpleName().toString();
                string = string.replaceAll(Pattern.quote("<init>"), Matcher.quoteReplacement(string2));
            }
            this.setDeclaration(string);
            return;
        }
        tree = SourceUtils.treeFor((CompilationInfo)compilationInfo, (Element)element);
        if (this.isCancelled() || tree == null) {
            return;
        }
        String string = tree.toString();
        if (element.getKind() == ElementKind.CONSTRUCTOR) {
            String string3 = element.getEnclosingElement().getSimpleName().toString();
            string = string.replaceAll(Pattern.quote("<init>"), Matcher.quoteReplacement(string3));
        }
        this.setDeclaration(string);
    }

    private void updateNavigatorSelection() {
    }
}

