/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Image;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.java.navigation.ClassMemberFilters;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.actions.OpenAction;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class ElementNode
extends AbstractNode {
    private static Node WAIT_NODE;
    private OpenAction openAction;
    private Description description;

    public ElementNode(Description description) {
        super((Children)(description.subs == null ? Children.LEAF : new ElementChilren(description.subs, description.ui.getFilters())));
        this.description = description;
        this.setDisplayName(description.name);
    }

    public Image getIcon(int n) {
        return this.description.kind == null ? super.getIcon(n) : Utilities.icon2Image((Icon)UiUtils.getElementIcon((ElementKind)this.description.kind, this.description.modifiers));
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public String getDisplayName() {
        return this.description.name;
    }

    public String getHtmlDisplayName() {
        return this.description.htmlHeader;
    }

    public Action[] getActions(boolean bl) {
        if (bl || this.description.name == null) {
            return this.description.ui.getActions();
        }
        Action[] actionArray = this.description.ui.getActions();
        Action[] actionArray2 = new Action[2 + actionArray.length];
        actionArray2[0] = this.getOpenAction();
        actionArray2[1] = null;
        for (int i = 0; i < actionArray.length; ++i) {
            actionArray2[2 + i] = actionArray[i];
        }
        return actionArray2;
    }

    public Action getPreferredAction() {
        return this.getOpenAction();
    }

    private synchronized Action getOpenAction() {
        if (this.openAction == null) {
            FileObject fileObject = this.description.ui.getFileObject();
            this.openAction = new OpenAction(this.description.elementHandle, fileObject);
        }
        return this.openAction;
    }

    static synchronized Node getWaitNode() {
        if (WAIT_NODE == null) {
            WAIT_NODE = new WaitNode();
        }
        return WAIT_NODE;
    }

    public void refreshRecursively() {
        Children children = this.getChildren();
        if (children instanceof ElementChilren) {
            ((ElementChilren)children).resetKeys(this.description.subs, this.description.ui.getFilters());
            for (Node node : children.getNodes()) {
                this.description.ui.expandNode(node);
                ((ElementNode)node).refreshRecursively();
            }
        }
    }

    public void updateRecursively(Description description) {
        Object object;
        Children children = this.getChildren();
        if (children instanceof ElementChilren) {
            object = new HashSet<Description>(this.description.subs);
            Node[] nodeArray = children.getNodes(true);
            HashMap<Description, ElementNode> hashMap = new HashMap<Description, ElementNode>();
            for (Node node : nodeArray) {
                hashMap.put(((ElementNode)node).description, (ElementNode)node);
            }
            ((ElementChilren)children).resetKeys(description.subs, description.ui.getFilters());
            nodeArray = children.getNodes(true);
            for (Description description2 : description.subs) {
                ElementNode elementNode = (ElementNode)((Object)hashMap.get(description2));
                if (elementNode == null) continue;
                if (!((HashSet)object).contains(description2) && elementNode.getChildren() != Children.LEAF) {
                    this.description.ui.expandNode((Node)elementNode);
                }
                elementNode.updateRecursively(description2);
            }
        }
        object = this.description;
        this.description = description;
        if (((Description)object).htmlHeader != null && !((Description)object).htmlHeader.equals(this.description.htmlHeader)) {
            this.fireDisplayNameChange(((Description)object).htmlHeader, this.description.htmlHeader);
        }
        if (((Description)object).modifiers != null && !((Object)((Description)object).modifiers).equals(description.modifiers)) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
    }

    public Description getDescritption() {
        return this.description;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Description {
        public static final Comparator<Description> ALPHA_COMPARATOR = new DescriptionComparator(true);
        public static final Comparator<Description> POSITION_COMPARATOR = new DescriptionComparator(false);
        ClassMemberPanelUI ui;
        FileObject fileObject;
        final String name;
        final ElementHandle<? extends Element> elementHandle;
        final ElementKind kind;
        Set<Modifier> modifiers;
        List<Description> subs;
        String htmlHeader;
        long pos;

        Description(ClassMemberPanelUI classMemberPanelUI) {
            this.ui = classMemberPanelUI;
            this.name = null;
            this.elementHandle = null;
            this.kind = null;
        }

        Description(ClassMemberPanelUI classMemberPanelUI, String string, ElementHandle<? extends Element> elementHandle, ElementKind elementKind) {
            this.ui = classMemberPanelUI;
            this.name = string;
            this.elementHandle = elementHandle;
            this.kind = elementKind;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Description)) {
                return false;
            }
            Description description = (Description)object;
            if (this.kind != description.kind) {
                return false;
            }
            if (!this.name.equals(description.name)) {
                return false;
            }
            return this.elementHandle.signatureEquals(description.elementHandle);
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.name != null ? this.name.hashCode() : 0);
            n = 29 * n + (this.kind != null ? this.kind.hashCode() : 0);
            return n;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DescriptionComparator
        implements Comparator<Description> {
            boolean alpha;

            DescriptionComparator(boolean bl) {
                this.alpha = bl;
            }

            @Override
            public int compare(Description description, Description description2) {
                if (this.alpha) {
                    if (this.k2i(description.kind) != this.k2i(description2.kind)) {
                        return this.k2i(description.kind) - this.k2i(description2.kind);
                    }
                    return description.name.compareTo(description2.name);
                }
                return description.pos == description2.pos ? 0 : (description.pos < description2.pos ? -1 : 1);
            }

            int k2i(ElementKind elementKind) {
                switch (elementKind) {
                    case CONSTRUCTOR: {
                        return 1;
                    }
                    case METHOD: {
                        return 2;
                    }
                    case FIELD: {
                        return 3;
                    }
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        return 4;
                    }
                }
                return 100;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementChilren
    extends Children.Keys<Description> {
        public ElementChilren(List<Description> list, ClassMemberFilters classMemberFilters) {
            this.resetKeys(list, classMemberFilters);
        }

        protected Node[] createNodes(Description description) {
            return new Node[]{new ElementNode(description)};
        }

        void resetKeys(List<Description> list, ClassMemberFilters classMemberFilters) {
            this.setKeys(classMemberFilters.filter(list));
        }
    }

    private static class WaitNode
    extends AbstractNode {
        private Image waitIcon = Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/wait.gif");

        WaitNode() {
            super(Children.LEAF);
        }

        public Image getIcon(int n) {
            return this.waitIcon;
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public String getDisplayName() {
            return "Please Wait...";
        }
    }
}

