/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementScanner6;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.ElementNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementScanningTask
implements CancellableTask<CompilationInfo> {
    private ClassMemberPanelUI ui;
    private FindChildrenElementVisitor scanner;
    private volatile boolean canceled;

    public ElementScanningTask(ClassMemberPanelUI classMemberPanelUI) {
        this.ui = classMemberPanelUI;
    }

    public void cancel() {
        this.canceled = true;
        if (this.scanner != null) {
            this.scanner.cancel();
        }
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        this.canceled = false;
        ElementNode.Description description = new ElementNode.Description(this.ui);
        description.fileObject = compilationInfo.getFileObject();
        description.subs = new ArrayList<ElementNode.Description>();
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        List<? extends Tree> list = compilationUnitTree.getTypeDecls();
        ArrayList<Element> arrayList = new ArrayList<Element>(list.size());
        TreePath treePath = new TreePath(compilationUnitTree);
        for (Tree object : list) {
            TreePath treePath2 = new TreePath(treePath, object);
            Element element = compilationInfo.getTrees().getElement(treePath2);
            if (element == null) continue;
            arrayList.add(element);
        }
        if (!this.canceled) {
            this.scanner = new FindChildrenElementVisitor(compilationInfo);
            for (Element element : arrayList) {
                this.scanner.scan(element, description);
            }
        }
        if (!this.canceled) {
            this.ui.refresh(description);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindChildrenElementVisitor
    extends ElementScanner6<Void, ElementNode.Description> {
        private CompilationInfo info;
        private volatile boolean canceled = false;

        public FindChildrenElementVisitor(CompilationInfo compilationInfo) {
            this.info = compilationInfo;
        }

        void cancel() {
            this.canceled = true;
        }

        @Override
        public Void visitPackage(PackageElement packageElement, ElementNode.Description description) {
            return null;
        }

        @Override
        public Void visitType(TypeElement typeElement, ElementNode.Description description) {
            if (!this.canceled && !this.info.getElementUtilities().isSynthetic((Element)typeElement)) {
                ElementNode.Description description2 = new ElementNode.Description(description.ui, typeElement.getSimpleName().toString(), (ElementHandle<? extends Element>)ElementHandle.create((Element)typeElement), typeElement.getKind());
                description2.modifiers = typeElement.getModifiers();
                description2.subs = new ArrayList<ElementNode.Description>();
                description2.pos = this.getPosition(typeElement);
                description2.htmlHeader = this.createHtmlHeader(typeElement, this.info.getElements().isDeprecated(typeElement));
                if (description2.pos == -1L) {
                    return null;
                }
                super.visitType(typeElement, description2);
                description.subs.add(description2);
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableElement variableElement, ElementNode.Description description) {
            if (!(this.canceled || this.info.getElementUtilities().isSynthetic((Element)variableElement) || variableElement.getKind() != ElementKind.FIELD && variableElement.getKind() != ElementKind.ENUM_CONSTANT)) {
                ElementNode.Description description2 = new ElementNode.Description(description.ui, variableElement.getSimpleName().toString(), (ElementHandle<? extends Element>)ElementHandle.create((Element)variableElement), variableElement.getKind());
                description2.modifiers = variableElement.getModifiers();
                description2.pos = this.getPosition(variableElement);
                description2.htmlHeader = this.createHtmlHeader(variableElement, this.info.getElements().isDeprecated(variableElement));
                if (description2.pos == -1L) {
                    return null;
                }
                super.visitVariable(variableElement, description2);
                description.subs.add(description2);
            }
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableElement executableElement, ElementNode.Description description) {
            if (!this.canceled && !this.info.getElementUtilities().isSynthetic((Element)executableElement)) {
                ElementNode.Description description2 = new ElementNode.Description(description.ui, executableElement.getSimpleName().toString(), (ElementHandle<? extends Element>)ElementHandle.create((Element)executableElement), executableElement.getKind());
                description2.modifiers = executableElement.getModifiers();
                description2.pos = this.getPosition(executableElement);
                if (description2.pos == -1L) {
                    return null;
                }
                description2.htmlHeader = this.createHtmlHeader(executableElement, this.info.getElements().isDeprecated(executableElement));
                super.visitExecutable(executableElement, description2);
                description.subs.add(description2);
            }
            return null;
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement typeParameterElement, ElementNode.Description description) {
            return null;
        }

        private long getPosition(Element element) {
            Trees trees = this.info.getTrees();
            CompilationUnitTree compilationUnitTree = this.info.getCompilationUnit();
            Tree tree = trees.getTree(element);
            if (tree == null) {
                return -1L;
            }
            SourcePositions sourcePositions = trees.getSourcePositions();
            return sourcePositions.getStartPosition(compilationUnitTree, tree);
        }

        private String createHtmlHeader(ExecutableElement executableElement, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            if (bl) {
                stringBuilder.append("<s>");
            }
            if (executableElement.getKind() == ElementKind.CONSTRUCTOR) {
                stringBuilder.append(executableElement.getEnclosingElement().getSimpleName());
            } else {
                stringBuilder.append(executableElement.getSimpleName());
            }
            if (bl) {
                stringBuilder.append("</s>");
            }
            stringBuilder.append("(");
            List<? extends VariableElement> list = executableElement.getParameters();
            Object object = list.iterator();
            while (object.hasNext()) {
                VariableElement variableElement = object.next();
                stringBuilder.append(this.print(variableElement.asType()));
                stringBuilder.append(" ");
                stringBuilder.append(variableElement.getSimpleName());
                if (!object.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(")");
            if (executableElement.getKind() != ElementKind.CONSTRUCTOR && (object = executableElement.getReturnType()).getKind() != TypeKind.VOID) {
                stringBuilder.append(" : ");
                stringBuilder.append(this.print(executableElement.getReturnType()));
            }
            return stringBuilder.toString();
        }

        private String createHtmlHeader(VariableElement variableElement, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            if (bl) {
                stringBuilder.append("<s>");
            }
            stringBuilder.append(variableElement.getSimpleName());
            if (bl) {
                stringBuilder.append("</s>");
            }
            if (variableElement.getKind() != ElementKind.ENUM_CONSTANT) {
                stringBuilder.append(" : ");
                stringBuilder.append(this.print(variableElement.asType()));
            }
            return stringBuilder.toString();
        }

        private String createHtmlHeader(TypeElement typeElement, boolean bl) {
            List<? extends TypeParameterElement> list;
            StringBuilder stringBuilder = new StringBuilder();
            if (bl) {
                stringBuilder.append("<s>");
            }
            stringBuilder.append(typeElement.getSimpleName());
            if (bl) {
                stringBuilder.append("</s>");
            }
            if ((list = typeElement.getTypeParameters()) != null && !list.isEmpty()) {
                stringBuilder.append("&lt;");
                Iterator<? extends TypeParameterElement> iterator = list.iterator();
                while (iterator.hasNext()) {
                    TypeParameterElement typeParameterElement = iterator.next();
                    stringBuilder.append(typeParameterElement.getSimpleName());
                    try {
                        List<? extends TypeMirror> list2 = typeParameterElement.getBounds();
                        if (!list2.isEmpty()) {
                            stringBuilder.append(this.printBounds(list2));
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        System.err.println("El " + typeElement);
                        nullPointerException.printStackTrace();
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append("&gt;");
            }
            return stringBuilder.toString();
        }

        private String printBounds(List<? extends TypeMirror> list) {
            if (list.size() == 1 && "java.lang.Object".equals(((Object)list.get(0)).toString())) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" extends ");
            Iterator<? extends TypeMirror> iterator = list.iterator();
            while (iterator.hasNext()) {
                TypeMirror typeMirror = iterator.next();
                stringBuilder.append(this.print(typeMirror));
                if (!iterator.hasNext()) continue;
                stringBuilder.append(" & ");
            }
            return stringBuilder.toString();
        }

        private String print(TypeMirror typeMirror) {
            switch (typeMirror.getKind()) {
                case DECLARED: {
                    DeclaredType declaredType = (DeclaredType)typeMirror;
                    StringBuilder stringBuilder = new StringBuilder(declaredType.asElement().getSimpleName().toString());
                    List<? extends TypeMirror> list = declaredType.getTypeArguments();
                    if (!list.isEmpty()) {
                        stringBuilder.append("&lt;");
                        Iterator<? extends TypeMirror> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            TypeMirror typeMirror2 = iterator.next();
                            stringBuilder.append(this.print(typeMirror2));
                            if (!iterator.hasNext()) continue;
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append("&gt;");
                    }
                    return stringBuilder.toString();
                }
                case TYPEVAR: {
                    TypeVariable typeVariable = (TypeVariable)typeMirror;
                    StringBuilder stringBuilder = new StringBuilder(typeVariable.asElement().getSimpleName().toString());
                    return stringBuilder.toString();
                }
                case ARRAY: {
                    ArrayType arrayType = (ArrayType)typeMirror;
                    StringBuilder stringBuilder = new StringBuilder(this.print(arrayType.getComponentType()));
                    stringBuilder.append("[]");
                    return stringBuilder.toString();
                }
                case WILDCARD: {
                    WildcardType wildcardType = (WildcardType)typeMirror;
                    StringBuilder stringBuilder = new StringBuilder("?");
                    if (wildcardType.getExtendsBound() != null) {
                        stringBuilder.append(" extends ");
                        stringBuilder.append(this.print(wildcardType.getExtendsBound()));
                    }
                    if (wildcardType.getSuperBound() != null) {
                        stringBuilder.append(" super ");
                        stringBuilder.append(this.print(wildcardType.getSuperBound()));
                    }
                    return stringBuilder.toString();
                }
            }
            return ((Object)typeMirror).toString();
        }
    }
}

