/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.swing.JDialog;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.navigation.JavaHierarchyPanel;
import org.netbeans.modules.java.navigation.JavaMembersModel;
import org.netbeans.modules.java.navigation.ResizablePopup;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class JavaHierarchy {
    public static void show(final FileObject fileObject) {
        JavaSource javaSource;
        if (fileObject != null && (javaSource = JavaSource.forFileObject((FileObject)fileObject)) != null) {
            try {
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Trees trees = compilationController.getTrees();
                        CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                        List<? extends Tree> list = compilationUnitTree.getTypeDecls();
                        LinkedHashSet<Element> linkedHashSet = new LinkedHashSet<Element>(list.size() + 1);
                        for (Tree tree : list) {
                            Element element = trees.getElement(trees.getPath(compilationUnitTree, tree));
                            if (element == null) continue;
                            linkedHashSet.add(element);
                        }
                        Element[] elementArray = linkedHashSet.toArray(JavaMembersModel.EMPTY_ELEMENTS_ARRAY);
                        JavaHierarchy.show(fileObject, elementArray, compilationController);
                    }
                }, true);
                return;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    public static void show(FileObject fileObject, Element[] elementArray, CompilationController compilationController) {
        if (fileObject != null) {
            JDialog jDialog = ResizablePopup.getDialog();
            jDialog.setTitle(NbBundle.getMessage(JavaHierarchy.class, (String)"TITLE_Hierarchy"));
            jDialog.setContentPane(new JavaHierarchyPanel(fileObject, elementArray, (CompilationInfo)compilationController));
            jDialog.setVisible(true);
        }
    }
}

