/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.javadoc.Doc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.navigation.JavaElement;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.netbeans.modules.java.navigation.Utils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class JavaHierarchyModel
extends DefaultTreeModel {
    static Element[] EMPTY_ELEMENTS_ARRAY = new Element[0];
    static ElementHandle[] EMPTY_ELEMENTHANDLES_ARRAY = new ElementHandle[0];
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    private String pattern = "";
    private String patternLowerCase = "";
    private FileObject fileObject;
    private ElementHandle[] elementHandles;

    public JavaHierarchyModel(FileObject fileObject, Element[] elementArray, CompilationInfo compilationInfo) {
        super(null);
        this.fileObject = fileObject;
        if (elementArray == null || elementArray.length == 0) {
            this.elementHandles = EMPTY_ELEMENTHANDLES_ARRAY;
        } else {
            ArrayList<ElementHandle> arrayList = new ArrayList<ElementHandle>(elementArray.length);
            for (Element element : elementArray) {
                arrayList.add(ElementHandle.create((Element)element));
            }
            this.elementHandles = arrayList.toArray(EMPTY_ELEMENTHANDLES_ARRAY);
        }
        this.update(elementArray, compilationInfo);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
        this.patternLowerCase = string == null ? null : string.toLowerCase();
    }

    public void update() {
        this.update(this.elementHandles);
    }

    private void update(final ElementHandle[] elementHandleArray) {
        if (elementHandleArray == null && elementHandleArray.length == 0) {
            return;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        ArrayList<Element> arrayList = new ArrayList<Element>(elementHandleArray.length);
                        for (ElementHandle elementHandle : elementHandleArray) {
                            arrayList.add(elementHandle.resolve((CompilationInfo)compilationController));
                        }
                        Element[] elementArray = arrayList.toArray(EMPTY_ELEMENTS_ARRAY);
                        JavaHierarchyModel.this.update(elementArray, (CompilationInfo)compilationController);
                    }
                }, true);
                return;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private void update(Element[] elementArray, CompilationInfo compilationInfo) {
        if (elementArray == null && elementArray.length == 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (Element element : elementArray) {
            if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE && element.getKind() != ElementKind.ENUM) continue;
            if (JavaMembersAndHierarchyOptions.isShowSuperTypeHierarchy()) {
                defaultMutableTreeNode.add(new TypeTreeNode(this.fileObject, (TypeElement)element, compilationInfo));
                continue;
            }
            Types types = compilationInfo.getTypes();
            TypeElement typeElement = (TypeElement)element;
            ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
            arrayList.add(typeElement);
            TypeElement typeElement2 = (TypeElement)types.asElement(typeElement.getSuperclass());
            while (typeElement2 != null) {
                arrayList.add(0, typeElement2);
                typeElement2 = (TypeElement)types.asElement(typeElement2.getSuperclass());
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
            for (TypeElement typeElement3 : arrayList) {
                FileObject fileObject = SourceUtils.getFile((Element)typeElement3, (ClasspathInfo)compilationInfo.getClasspathInfo());
                SimpleTypeTreeNode simpleTypeTreeNode = new SimpleTypeTreeNode(fileObject, typeElement3, compilationInfo, typeElement != typeElement3 || ((Object)typeElement.getQualifiedName()).equals(Object.class.getName()));
                defaultMutableTreeNode2.insert(simpleTypeTreeNode, 0);
                defaultMutableTreeNode2 = simpleTypeTreeNode;
            }
            JavaMembersAndHierarchyOptions.setSubTypeHierarchyDepth(arrayList.size() + 2);
        }
        this.setRoot(defaultMutableTreeNode);
    }

    public boolean patternMatch(JavaElement javaElement) {
        return Utils.patternMatch(javaElement, this.pattern, this.patternLowerCase);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractHierarchyTreeNode
    extends DefaultMutableTreeNode
    implements JavaElement {
        private FileObject fileObject;
        private ElementHandle<? extends Element> elementHandle;
        private ElementKind elementKind;
        private Set<Modifier> modifiers;
        private String name = "";
        private String label = "";
        private String tooltip = null;
        private Icon icon = null;
        private String javaDoc = "";
        private boolean loaded = false;

        AbstractHierarchyTreeNode(FileObject fileObject, Element element, CompilationInfo compilationInfo) {
            this(fileObject, element, compilationInfo, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AbstractHierarchyTreeNode(FileObject fileObject, Element element, CompilationInfo compilationInfo, boolean bl) {
            this.fileObject = fileObject;
            this.elementHandle = ElementHandle.create((Element)element);
            this.elementKind = element.getKind();
            this.modifiers = element.getModifiers();
            this.setName(element.getSimpleName().toString());
            this.setIcon(UiUtils.getElementIcon((ElementKind)element.getKind(), element.getModifiers()));
            this.setLabel(Utils.format(element));
            this.setToolTip(Utils.format(element, true));
            Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
            if (doc != null) {
                StringBuilder stringBuilder = new StringBuilder();
                this.setJavaDoc(doc.getRawCommentText());
            }
            if (!bl) {
                try {
                    this.loadChildren(element, compilationInfo);
                }
                finally {
                    this.loaded = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getChildCount() {
            if (!this.loaded) {
                try {
                    this.loadChildren();
                }
                finally {
                    this.loaded = true;
                }
            }
            return super.getChildCount();
        }

        @Override
        public FileObject getFileObject() {
            return this.fileObject;
        }

        @Override
        public String getName() {
            return this.name;
        }

        protected void setName(String string) {
            this.name = string;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        protected void setLabel(String string) {
            this.label = string;
        }

        @Override
        public String getTooltip() {
            return this.tooltip;
        }

        protected void setToolTip(String string) {
            this.tooltip = string;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        protected void setIcon(Icon icon) {
            this.icon = icon;
        }

        protected void setElementHandle(ElementHandle<? extends Element> elementHandle) {
            this.elementHandle = elementHandle;
        }

        @Override
        public String getJavaDoc() {
            return this.javaDoc;
        }

        public void setJavaDoc(String string) {
            this.javaDoc = string;
        }

        public Set<Modifier> getModifiers() {
            return this.modifiers;
        }

        @Override
        public ElementHandle getElementHandle() {
            return this.elementHandle;
        }

        @Override
        public void gotoElement() {
            this.openElementHandle();
        }

        protected void loadChildren() {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                        public void cancel() {
                        }

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Element element = AbstractHierarchyTreeNode.this.elementHandle.resolve((CompilationInfo)compilationController);
                            if (!(element instanceof TypeElement) || !((TypeElement)element).getQualifiedName().toString().equals(Object.class.getName())) {
                                AbstractHierarchyTreeNode.this.loadChildren(element, (CompilationInfo)compilationController);
                            }
                        }
                    }, true);
                    return;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }

        protected abstract void loadChildren(Element var1, CompilationInfo var2);

        @Override
        public String toString() {
            return this.getLabel();
        }

        protected void openElementHandle() {
            if (this.elementHandle == null) {
                return;
            }
            UiUtils.open((FileObject)this.fileObject, this.elementHandle);
        }
    }

    private class SimpleTypeTreeNode
    extends AbstractHierarchyTreeNode {
        private boolean inSuperClassRole;

        SimpleTypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo) {
            this(fileObject, typeElement, compilationInfo, false);
        }

        SimpleTypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, boolean bl) {
            super(fileObject, typeElement, compilationInfo, bl);
            this.inSuperClassRole = bl;
        }

        public boolean isLeaf() {
            return false;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
            if (this.inSuperClassRole) {
                return;
            }
            TypeElement typeElement = (TypeElement)element;
            if (typeElement.getQualifiedName().toString().equals(Object.class.getName())) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaHierarchyModel.class, (String)"MSG_WontShowSubTypesOfObject", (Object)Object.class.getName()));
                return;
            }
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            if (projectArray == null) {
                return;
            }
            LinkedHashSet<ElementHandle> linkedHashSet = new LinkedHashSet<ElementHandle>();
            ElementHandle elementHandle = ElementHandle.create((Element)typeElement);
            final int[] nArray = new int[]{0};
            for (Project project : projectArray) {
                Collection collection = project.getLookup().lookupAll(Sources.class);
                if (collection == null) continue;
                for (Sources sources : collection) {
                    SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
                    if (sourceGroupArray == null) continue;
                    for (SourceGroup sourceGroup : sourceGroupArray) {
                        ClassIndex classIndex;
                        ClasspathInfo classpathInfo;
                        ClassPath classPath;
                        FileObject fileObject = sourceGroup.getRootFolder();
                        if (fileObject == null || (classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject})) == null || (classpathInfo = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH, (ClassPath)classPath)) == null || (classIndex = classpathInfo.getClassIndex()) == null) continue;
                        Set set = classIndex.getElements(elementHandle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
                        for (ElementHandle elementHandle2 : set) {
                            JavaSource javaSource;
                            if (linkedHashSet.contains(elementHandle2)) continue;
                            linkedHashSet.add(elementHandle2);
                            final ElementHandle elementHandle3 = elementHandle2;
                            FileObject fileObject2 = SourceUtils.getFile((ElementHandle)elementHandle2, (ClasspathInfo)classpathInfo);
                            if (fileObject2 == null || (javaSource = JavaSource.forFileObject((FileObject)fileObject2)) == null) continue;
                            try {
                                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                                    public void cancel() {
                                    }

                                    public void run(CompilationController compilationController) throws Exception {
                                        FileObject fileObject;
                                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                        Element element = elementHandle3.resolve((CompilationInfo)compilationController);
                                        if (element instanceof TypeElement && ((TypeElement)element).getNestingKind() != NestingKind.ANONYMOUS && (fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo())) != null) {
                                            int n = nArray[0];
                                            nArray[0] = n + 1;
                                            SimpleTypeTreeNode.this.insert(new SimpleTypeTreeNode(fileObject, (TypeElement)element, (CompilationInfo)compilationController), n);
                                        }
                                    }
                                }, true);
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify((Throwable)iOException);
                            }
                        }
                    }
                }
            }
        }
    }

    private class TypeTreeNode
    extends AbstractHierarchyTreeNode {
        private boolean inSuperClassRole;

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo) {
            this(fileObject, typeElement, compilationInfo, false);
        }

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, boolean bl) {
            super(fileObject, typeElement, compilationInfo);
            this.inSuperClassRole = bl;
        }

        public boolean isLeaf() {
            return false;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
            this.loadChildren(element, compilationInfo, 0);
        }

        protected int loadChildren(Element element, CompilationInfo compilationInfo, int n) {
            Object object;
            FileObject fileObject;
            TypeElement typeElement;
            Types types = compilationInfo.getTypes();
            TypeElement typeElement2 = (TypeElement)types.asElement((typeElement = (TypeElement)element).getSuperclass());
            if (typeElement2 != null && !typeElement2.getQualifiedName().toString().equals(Object.class.getName())) {
                fileObject = SourceUtils.getFile((Element)typeElement2, (ClasspathInfo)compilationInfo.getClasspathInfo());
                this.insert(new TypeTreeNode(fileObject, typeElement2, compilationInfo, true), n++);
            }
            fileObject = typeElement.getInterfaces();
            for (TypeMirror annotatedConstruct : fileObject) {
                object = (TypeElement)types.asElement(annotatedConstruct);
                if (object == null) continue;
                FileObject fileObject2 = SourceUtils.getFile((Element)object, (ClasspathInfo)compilationInfo.getClasspathInfo());
                this.insert(new TypeTreeNode(fileObject2, (TypeElement)object, compilationInfo, true), n++);
            }
            if (JavaMembersAndHierarchyOptions.isShowInner() && !this.inSuperClassRole) {
                for (Element element2 : typeElement.getEnclosedElements()) {
                    object = null;
                    if (element2.getKind() != ElementKind.CLASS && element2.getKind() != ElementKind.INTERFACE && element2.getKind() != ElementKind.ENUM) continue;
                    object = new TypeTreeNode(JavaHierarchyModel.this.fileObject, (TypeElement)element2, compilationInfo, true);
                    this.insert((MutableTreeNode)object, n++);
                }
            }
            return n;
        }
    }
}

