/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import com.sun.source.util.TreePath;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.java.navigation.JavaMembers;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class InspectMembersAtCaretAction
extends BaseAction {
    private static final String INSPECT_MEMBERS_AT_CARET = "inspect-members-at-caret";

    public InspectMembersAtCaretAction() {
        super(NbBundle.getMessage(InspectMembersAtCaretAction.class, (String)INSPECT_MEMBERS_AT_CARET), 0);
        this.putValue("ShortDescription", this.getValue("Name"));
        this.putValue("trimmed-text", this.getValue("Name"));
        this.putValue("PopupMenuText", this.getValue("Name"));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        JavaSource javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument());
        if (javaSource == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    Document document = compilationController.getDocument();
                    if (document != null) {
                        int n = jTextComponent.getCaret().getDot();
                        TreePath treePath = compilationController.getTreeUtilities().pathFor(n);
                        Element element = compilationController.getTrees().getElement(treePath);
                        if (element instanceof TypeElement) {
                            FileObject fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo());
                            if (fileObject != null) {
                                JavaMembers.show(fileObject, new Element[]{element}, compilationController);
                            }
                        } else if (element instanceof VariableElement) {
                            FileObject fileObject;
                            TypeMirror typeMirror = ((VariableElement)element).asType();
                            if (typeMirror.getKind() == TypeKind.DECLARED && (element = ((DeclaredType)typeMirror).asElement()) != null && (fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo())) != null) {
                                JavaMembers.show(fileObject, new Element[]{element}, compilationController);
                            }
                        } else if (element instanceof ExecutableElement) {
                            FileObject fileObject;
                            if (element.getKind() == ElementKind.METHOD) {
                                FileObject fileObject2;
                                TypeMirror typeMirror = ((ExecutableElement)element).getReturnType();
                                if (typeMirror.getKind() == TypeKind.DECLARED && (element = ((DeclaredType)typeMirror).asElement()) != null && (fileObject2 = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo())) != null) {
                                    JavaMembers.show(fileObject2, new Element[]{element}, compilationController);
                                }
                            } else if (element.getKind() == ElementKind.CONSTRUCTOR && (element = element.getEnclosingElement()) != null && (fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo())) != null) {
                                JavaMembers.show(fileObject, new Element[]{element}, compilationController);
                            }
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Logger.global.log(Level.WARNING, iOException.getMessage(), iOException);
        }
    }
}

