/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.autoupdate.ServerPanel;
import org.netbeans.modules.autoupdate.Settings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class AutoCheckInfo
extends JPanel {
    private Settings settings = Settings.getShared();
    private int prefX = 0;
    private Dimension prefSize = null;
    private JCheckBox beforeCheckBox;
    private JCheckBox configCheckBox;
    private JPanel configPanel;
    private JPanel extSettingsPanel;
    private JLabel iconLabel;
    private JLabel jLabel2;
    private JPanel messagePanel;
    private JTextArea messageText;
    private JCheckBox negativCheckBox;
    private JComboBox periodComboBox;
    private JButton proxyButton;

    public AutoCheckInfo(String string, int n) {
        int n2 = this.settings.getPeriod();
        this.initComponents();
        Settings.PeriodPropertyEditor periodPropertyEditor = new Settings.PeriodPropertyEditor();
        String[] stringArray = periodPropertyEditor.getTags();
        for (int i = 0; i < stringArray.length; ++i) {
            this.periodComboBox.addItem(stringArray[i]);
        }
        this.messageText.setText(string);
        this.iconLabel.setIcon(AutoCheckInfo.getIconForType(n));
        this.beforeCheckBox.setSelected(this.settings.isAskBefore());
        this.negativCheckBox.setSelected(this.settings.isNegativeResults());
        this.periodComboBox.setSelectedIndex(n2);
        this.prefX = this.getPreferredSize().width;
        ServerPanel serverPanel = new ServerPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.extSettingsPanel.add((Component)serverPanel, gridBagConstraints);
        this.configPanel.setBorder(new TitledBorder(NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.configBorder")));
        this.extSettingsPanel.setBorder(new TitledBorder(NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.additionalBorder")));
        this.configPanel.setVisible(false);
        this.extSettingsPanel.setVisible(false);
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(AutoCheckInfo.class).getString("CTL_AutoCheck_Title"));
        this.getAccessibleContext().setAccessibleDescription(string);
        this.configCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AutoCheckInfo.class).getString("ACS_AutoCheckInfo.configCheckBox.text"));
        this.periodComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AutoCheckInfo.class).getString("ACS_AutoCheckInfo.jLabel2.text"));
        this.beforeCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AutoCheckInfo.class).getString("ACS_AutoCheckInfo.jCheckBox1.text"));
        this.negativCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AutoCheckInfo.class).getString("ACS_AutoCheckInfo.jCheckBox2.text"));
        this.proxyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AutoCheckInfo.class).getString("ACS_AutoCheckInfo.proxyButton.text"));
        this.messageText.getAccessibleContext().setAccessibleName(string);
        this.messageText.getAccessibleContext().setAccessibleDescription(string);
    }

    public Dimension getPreferredSize() {
        if (this.prefX == 0) {
            return super.getPreferredSize();
        }
        this.prefSize = super.getPreferredSize();
        this.prefSize.width = Math.max(this.prefSize.width, this.prefX);
        return this.prefSize;
    }

    private void initComponents() {
        this.messagePanel = new JPanel();
        this.iconLabel = new JLabel();
        this.messageText = new JTextArea();
        this.configCheckBox = new JCheckBox();
        this.configPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.periodComboBox = new JComboBox();
        this.beforeCheckBox = new JCheckBox();
        this.negativCheckBox = new JCheckBox();
        this.extSettingsPanel = new JPanel();
        this.proxyButton = new JButton();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.messagePanel.setLayout(new GridBagLayout());
        this.iconLabel.setLabelFor(this.configCheckBox);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.messagePanel.add((Component)this.iconLabel, gridBagConstraints);
        this.messageText.setEditable(false);
        this.messageText.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 18, 0, 0);
        this.messagePanel.add((Component)this.messageText, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.configCheckBox, (String)NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.configCheckBox.text"));
        this.configCheckBox.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 18, 0, 0);
        this.messagePanel.add((Component)this.configCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.messagePanel, gridBagConstraints);
        this.configPanel.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.periodComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 8, 0, 5);
        this.configPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.periodComboBox.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.configPanel.add((Component)this.periodComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.beforeCheckBox, (String)NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.jCheckBox1.text"));
        this.beforeCheckBox.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.configPanel.add((Component)this.beforeCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.negativCheckBox, (String)NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.jCheckBox2.text"));
        this.negativCheckBox.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 8, 0);
        this.configPanel.add((Component)this.negativCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.configPanel, gridBagConstraints);
        this.extSettingsPanel.setLayout(new GridBagLayout());
        this.extSettingsPanel.setPreferredSize(new Dimension(350, 200));
        Mnemonics.setLocalizedText((AbstractButton)this.proxyButton, (String)NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.proxyButton.text"));
        this.proxyButton.setPreferredSize(new Dimension(139, 27));
        this.proxyButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.extSettingsPanel.add((Component)this.proxyButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.extSettingsPanel, gridBagConstraints);
    }

    private void proxyButtonActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void periodComboBoxActionPerformed(ActionEvent actionEvent) {
        this.settings.setPeriod(this.periodComboBox.getSelectedIndex());
    }

    private void negativCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.settings.setNegativeResults(this.negativCheckBox.isSelected());
    }

    private void beforeCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.settings.setAskBefore(this.beforeCheckBox.isSelected());
    }

    private void configButtonActionPerformed(ActionEvent actionEvent) {
        this.configPanel.setVisible(this.configCheckBox.isSelected());
        this.extSettingsPanel.setVisible(this.configCheckBox.isSelected());
        if (this.getTopLevelAncestor() instanceof Window) {
            ((Window)this.getTopLevelAncestor()).pack();
        }
    }

    boolean showDialog(boolean bl) {
        DialogDescriptor dialogDescriptor = this.createDialog(bl);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.setVisible(false);
        dialog.dispose();
        return bl ? dialogDescriptor.getValue() == DialogDescriptor.YES_OPTION : true;
    }

    private DialogDescriptor createDialog(boolean bl) {
        DialogDescriptor dialogDescriptor;
        if (bl) {
            dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getBundle(AutoCheckInfo.class).getString("CTL_AutoCheck_Title"), true, 0, DialogDescriptor.YES_OPTION, 0, null, null);
        } else {
            dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getBundle(AutoCheckInfo.class).getString("CTL_AutoCheck_Title"), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
            dialogDescriptor.setClosingOptions(null);
        }
        return dialogDescriptor;
    }

    private static Icon getIconForType(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        switch (n) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    private class FormListener
    implements ActionListener {
        private FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AutoCheckInfo.this.configCheckBox) {
                AutoCheckInfo.this.configButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == AutoCheckInfo.this.periodComboBox) {
                AutoCheckInfo.this.periodComboBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == AutoCheckInfo.this.beforeCheckBox) {
                AutoCheckInfo.this.beforeCheckBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == AutoCheckInfo.this.negativCheckBox) {
                AutoCheckInfo.this.negativCheckBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == AutoCheckInfo.this.proxyButton) {
                AutoCheckInfo.this.proxyButtonActionPerformed(actionEvent);
            }
        }
    }
}

