/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.IdeDescription;
import org.netbeans.modules.autoupdate.L10NUpdate;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

class DependencyChecker {
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate");

    DependencyChecker() {
    }

    Collection modulesToAdd(ModuleUpdate moduleUpdate, Enumeration enumeration, List list, StringBuffer stringBuffer) {
        err.log(Level.FINE, "DO modulesToAdd: " + moduleUpdate.getCodeNameBase() + "[L10N? " + (moduleUpdate instanceof L10NUpdate) + "], group: " + list + ", dontAddModuleName: " + stringBuffer);
        ArrayList arrayList = new ArrayList();
        this.checkDependencies(moduleUpdate.getRemoteModule(), arrayList, enumeration, list, stringBuffer, moduleUpdate.getLocalModule() != null);
        if (err.isLoggable(Level.FINE)) {
            String string = "";
            for (ModuleUpdate moduleUpdate2 : arrayList) {
                string = string + moduleUpdate2.getCodeNameBase() + "[L10N? " + (moduleUpdate2 instanceof L10NUpdate) + "], ";
                err.log(Level.FINE, "modulesToAdd: " + moduleUpdate.getCodeNameBase() + ", RETURNS: " + string);
            }
        }
        err.log(Level.FINE, "Do find localization for " + moduleUpdate.getCodeNameBase() + " on locale " + Locale.getDefault());
        DependencyChecker.checkFreeLocalizationDependency(moduleUpdate, Locale.getDefault().toString(), arrayList, enumeration, list);
        return arrayList;
    }

    Collection modulesToRemove(ModuleUpdate moduleUpdate, ModuleUpdate moduleUpdate2) {
        ArrayList arrayList = new ArrayList();
        this.checkReverseDependencies(moduleUpdate.getRemoteModule(), arrayList, moduleUpdate2);
        return arrayList;
    }

    private boolean checkDependencies(ModuleInfo moduleInfo, Collection collection, Enumeration enumeration, List list, StringBuffer stringBuffer, boolean bl) {
        Object object2;
        Set set = moduleInfo.getDependencies();
        Dependency[] dependencyArray = set.toArray(new Dependency[set.size()]);
        boolean[] blArray = new boolean[dependencyArray.length];
        ModuleInfo[] moduleInfoArray = Updates.getInstalledModules();
        ModuleInfo[] moduleInfoArray2 = Updates.getInstalledPatches();
        for (int i = 0; i < dependencyArray.length; ++i) {
            if (dependencyArray[i].getType() == 1 || dependencyArray[i].getType() == 5) {
                int n;
                boolean bl2 = false;
                for (n = 0; n < moduleInfoArray.length && !(bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], moduleInfoArray[n])); ++n) {
                }
                if (!bl2) {
                    for (n = 0; n < moduleInfoArray2.length && !(bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], moduleInfoArray2[n])); ++n) {
                    }
                }
                if (!bl2 && enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        ModuleUpdate moduleUpdate = (ModuleUpdate)enumeration.nextElement();
                        if (moduleUpdate instanceof L10NUpdate || !(bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], moduleUpdate.getRemoteModule()))) continue;
                        if (collection.contains(moduleUpdate)) break;
                        err.log(Level.FINE, "  ADDED[SELECTED]: " + moduleUpdate.getCodeNameBase() + "[L10N? " + (moduleUpdate instanceof L10NUpdate) + "]: DEP: " + dependencyArray[i]);
                        collection.add(moduleUpdate);
                        break;
                    }
                }
                if (!bl2 && list != null) {
                    for (Object object2 : list) {
                        if (object2 instanceof L10NUpdate || !(bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], ((ModuleUpdate)object2).getRemoteModule()))) continue;
                        if (collection.contains(object2)) break;
                        err.log(Level.FINE, "  ADDED[GROUP]: " + ((ModuleUpdate)object2).getCodeNameBase() + "[L10N? " + (object2 instanceof L10NUpdate) + "]: DEP: " + dependencyArray[i]);
                        collection.add(object2);
                        break;
                    }
                }
                if (!bl2) {
                    for (Object object2 : Wizard.getAllModules()) {
                        if (object2 instanceof L10NUpdate || !(bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], ((ModuleUpdate)object2).getRemoteModule()))) continue;
                        if (collection.contains(object2)) break;
                        err.log(Level.FINE, "  ADDED[ALL]: " + ((ModuleUpdate)object2).getCodeNameBase() + "[L10N? " + (object2 instanceof L10NUpdate) + "]: DEP: " + dependencyArray[i]);
                        collection.add(object2);
                        break;
                    }
                }
                if (!bl2) {
                    blArray[i] = false;
                    continue;
                }
                blArray[i] = true;
                continue;
            }
            if (dependencyArray[i].getType() == 4) {
                if (this.checkIdeDependency(dependencyArray[i], IdeDescription.getIdeDescription())) {
                    blArray[i] = true;
                    continue;
                }
                Iterator iterator = Wizard.getAllModules().iterator();
                boolean bl3 = false;
                while (iterator.hasNext()) {
                    object2 = (ModuleUpdate)iterator.next();
                    if (object2 instanceof L10NUpdate || !(bl3 = DependencyChecker.checkModuleDependency(dependencyArray[i], ((ModuleUpdate)object2).getRemoteModule()))) continue;
                    if (collection.contains(object2)) break;
                    err.log(Level.FINE, "  ADDED[GROUP]: " + ((ModuleUpdate)object2).getCodeNameBase() + "[L10N? " + (object2 instanceof L10NUpdate) + "]: DEP: " + dependencyArray[i]);
                    collection.add(object2);
                    break;
                }
                blArray[i] = bl3;
                continue;
            }
            blArray[i] = true;
        }
        StringBuffer stringBuffer2 = new StringBuffer(280);
        stringBuffer2.append(this.getBundle("MSG_NotSatisfied"));
        stringBuffer2.append(NbBundle.getMessage(DependencyChecker.class, (String)"TXT_DependencyChecker_Module", (Object)moduleInfo.getDisplayName(), (Object)moduleInfo.getCodeName()));
        int n = 0;
        for (int i = 0; i < dependencyArray.length; ++i) {
            if (blArray[i]) continue;
            stringBuffer2.append(dependencyArray[i] + "\n");
            ++n;
        }
        StringBuffer stringBuffer3 = null;
        if (bl && (object2 = this.checkBrokenImplDependency(moduleInfo, collection)).size() > 0) {
            stringBuffer3 = new StringBuffer(280);
            stringBuffer3.append(NbBundle.getMessage(DependencyChecker.class, (String)"TXT_BrokenDependencyChecker_Module", (Object)moduleInfo.getDisplayName(), (Object)moduleInfo.getCodeName()));
            stringBuffer3.append(this.getBundle("MSG_BadsList"));
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                stringBuffer3.append(((ModuleInfo)iterator.next()).getCodeName() + "\n");
            }
            stringBuffer3.append(this.getBundle("MSG_IncludeBadsAnyway"));
        }
        if (n == 0 && stringBuffer3 == null) {
            return true;
        }
        if (n > 0) {
            stringBuffer2.append(this.getBundle("MSG_IncludeAnyway"));
            object2 = new NotifyDescriptor.Confirmation((Object)stringBuffer2.toString(), 0, 0);
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)object2).equals(NotifyDescriptor.YES_OPTION)) {
                stringBuffer.append(moduleInfo.getDisplayName());
                return false;
            }
        }
        if (stringBuffer3 != null) {
            object2 = new NotifyDescriptor.Confirmation((Object)stringBuffer3.toString(), 0, 0);
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)object2).equals(NotifyDescriptor.YES_OPTION)) {
                stringBuffer.append(moduleInfo.getDisplayName());
            }
        }
        return false;
    }

    boolean checkReverseDependencies(ModuleInfo moduleInfo, Collection collection, ModuleUpdate moduleUpdate) {
        ModuleInfo[] moduleInfoArray = Updates.getInstalledModules();
        ModuleInfo[] moduleInfoArray2 = Updates.getInstalledPatches();
        for (ModuleUpdate moduleUpdate2 : Wizard.getAllModules()) {
            ModuleInfo moduleInfo2 = moduleUpdate2.getRemoteModule();
            Set set = moduleInfo2.getDependencies();
            Dependency[] dependencyArray = set.toArray(new Dependency[set.size()]);
            boolean bl = true;
            for (int i = 0; i < dependencyArray.length; ++i) {
                if (dependencyArray[i].getType() == 1 && (dependencyArray[i].getName() + "/").startsWith(moduleInfo.getCodeNameBase() + "/") || dependencyArray[i].getType() == 5 && Arrays.asList(moduleInfo.getProvides()).contains(dependencyArray[i].getName())) {
                    int n;
                    boolean bl2 = false;
                    for (n = 0; n < moduleInfoArray.length && !(bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], moduleInfoArray[n])); ++n) {
                    }
                    if (!bl2 && moduleUpdate != null) {
                        bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], moduleUpdate.getRemoteModule());
                    }
                    if (!bl2) {
                        for (n = 0; n < moduleInfoArray2.length && !(bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], moduleInfoArray2[n])); ++n) {
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break;
                }
                if (dependencyArray[i].getType() != 4 || !dependencyArray[i].getName().equals(moduleInfo.getCodeName()) || DependencyChecker.checkModuleDependency(dependencyArray[i], IdeDescription.getIdeDescription())) continue;
                bl = false;
                break;
            }
            if (bl || collection.contains(moduleUpdate2)) continue;
            collection.add(moduleUpdate2);
        }
        return collection.size() == 0;
    }

    static boolean checkModuleDependency(Dependency dependency, ModuleInfo moduleInfo) {
        if (dependency.getType() == 5) {
            return Arrays.asList(moduleInfo.getProvides()).contains(dependency.getName());
        }
        String string = dependency.getName();
        if (string.equals(moduleInfo.getCodeName())) {
            if (dependency.getComparison() == 3) {
                return true;
            }
            if (dependency.getComparison() == 1) {
                if (moduleInfo.getSpecificationVersion() == null) {
                    return false;
                }
                return new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) <= 0;
            }
            if (moduleInfo.getImplementationVersion() == null) {
                return false;
            }
            return moduleInfo.getImplementationVersion().equals(dependency.getVersion());
        }
        int n = string.indexOf(45);
        if (n != -1) {
            int n2 = string.indexOf(47);
            String string2 = string.substring(0, n2);
            int n3 = Integer.parseInt(string.substring(n2 + 1, n));
            int n4 = Integer.parseInt(string.substring(n + 1));
            if (string2.equals(moduleInfo.getCodeNameBase()) && n3 <= moduleInfo.getCodeNameRelease() && n4 >= moduleInfo.getCodeNameRelease()) {
                if (dependency.getComparison() == 3) {
                    return true;
                }
                if (moduleInfo.getCodeNameRelease() > n3) {
                    return true;
                }
                if (moduleInfo.getSpecificationVersion() == null) {
                    return false;
                }
                return new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) <= 0;
            }
        }
        return false;
    }

    boolean checkIdeDependency(Dependency dependency, ModuleInfo moduleInfo) {
        String string = moduleInfo.getCodeName();
        SpecificationVersion specificationVersion = moduleInfo.getSpecificationVersion();
        String string2 = moduleInfo.getImplementationVersion();
        if (!string.equals(dependency.getName())) {
            return false;
        }
        if (dependency.getComparison() == 1) {
            return new SpecificationVersion(dependency.getVersion()).compareTo((Object)specificationVersion) <= 0;
        }
        if (dependency.getComparison() == 2) {
            return dependency.getVersion().equals(string2);
        }
        throw new IllegalStateException("Cannot have COMPARE_ANY on IDE dependency");
    }

    private List checkBrokenImplDependency(ModuleInfo moduleInfo, Collection collection) {
        ModuleInfo[] moduleInfoArray = Updates.getInstalledModules();
        ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>();
        block0: for (int i = 0; i < moduleInfoArray.length; ++i) {
            for (Dependency dependency : moduleInfoArray[i].getDependencies()) {
                if (!dependency.getName().equals(moduleInfo.getCodeName()) || dependency.getComparison() != 2) continue;
                if (dependency.getVersion().equals(moduleInfo.getImplementationVersion())) continue block0;
                Iterator iterator = Wizard.getAllModules().iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    ModuleUpdate moduleUpdate = (ModuleUpdate)iterator.next();
                    if (!moduleUpdate.getRemoteModule().getCodeName().equals(moduleInfoArray[i].getCodeName()) || moduleUpdate.getRemoteModule().getSpecificationVersion().compareTo((Object)moduleInfoArray[i].getSpecificationVersion()) <= 0) continue;
                    boolean bl2 = true;
                    for (Dependency dependency2 : moduleUpdate.getRemoteModule().getDependencies()) {
                        if (!dependency2.getName().equals(moduleInfo.getCodeName()) || dependency2.getComparison() != 2 || dependency2.getVersion().equals(moduleInfo.getImplementationVersion())) continue;
                        bl2 = false;
                        break;
                    }
                    if (!bl2) continue;
                    if (!collection.contains(moduleUpdate)) {
                        collection.add(moduleUpdate);
                    }
                    bl = true;
                    break;
                }
                if (bl) continue block0;
                arrayList.add(moduleInfoArray[i]);
                continue block0;
            }
        }
        return arrayList;
    }

    static boolean checkPlatformDependency(ModuleInfo moduleInfo) {
        Set set = moduleInfo.getDependencies();
        Iterator iterator = set.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            if (5 != dependency.getType() || !dependency.getName().startsWith("org.openide.modules.os")) continue;
            bl = false;
            ModuleInfo[] moduleInfoArray = Updates.getInstalledModules();
            for (int i = 0; !bl && i < moduleInfoArray.length; ++i) {
                bl = DependencyChecker.checkModuleDependency(dependency, moduleInfoArray[i]);
            }
            err.log(Level.FINE, "checkPlatformDependency on module " + moduleInfo.getCodeNameBase() + " which requires " + dependency + " returns " + bl);
        }
        return bl;
    }

    private static boolean checkFreeLocalizationDependency(ModuleUpdate moduleUpdate, String string, Collection collection, Enumeration enumeration, List list) {
        L10NUpdate l10NUpdate;
        boolean bl = false;
        if (moduleUpdate instanceof L10NUpdate) {
            return false;
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                ModuleUpdate moduleUpdate2;
                ModuleUpdate moduleUpdate3 = (ModuleUpdate)enumeration.nextElement();
                if (!(moduleUpdate3 instanceof L10NUpdate) || !(bl = string.equals(((L10NUpdate)(moduleUpdate2 = (L10NUpdate)moduleUpdate3)).getLangcode()) && moduleUpdate2.getCodeNameBase().equals(moduleUpdate.getCodeNameBase()))) continue;
                if (collection.contains(moduleUpdate2)) break;
                err.log(Level.FINE, "  ADDED[SELECTED]: " + moduleUpdate2.getCodeNameBase() + "[" + ((L10NUpdate)moduleUpdate2).getLangcode() + "]");
                collection.add(moduleUpdate2);
                break;
            }
        }
        if (!bl && list != null) {
            for (ModuleUpdate moduleUpdate2 : list) {
                if (!(moduleUpdate2 instanceof L10NUpdate) || !(bl = string.equals((l10NUpdate = (L10NUpdate)moduleUpdate2).getLangcode()) && l10NUpdate.getCodeNameBase().equals(moduleUpdate.getCodeNameBase()))) continue;
                if (collection.contains(l10NUpdate)) break;
                err.log(Level.FINE, "  ADDED[GROUP]: " + l10NUpdate.getCodeNameBase() + "[" + l10NUpdate.getLangcode() + "]");
                collection.add(l10NUpdate);
                break;
            }
        }
        if (!bl) {
            for (ModuleUpdate moduleUpdate2 : Wizard.getAllModules()) {
                if (!(moduleUpdate2 instanceof L10NUpdate) || !(bl = string.equals((l10NUpdate = (L10NUpdate)moduleUpdate2).getLangcode()) && l10NUpdate.getCodeNameBase().equals(moduleUpdate.getCodeNameBase()))) continue;
                if (collection.contains(l10NUpdate)) break;
                err.log(Level.FINE, "  ADDED[ALL]: " + l10NUpdate.getCodeNameBase() + "[" + l10NUpdate.getLangcode() + "]");
                collection.add(l10NUpdate);
                break;
            }
        }
        return bl;
    }

    private String getBundle(String string) {
        return NbBundle.getMessage(DependencyChecker.class, (String)string);
    }
}

