/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.SafeModule;
import org.netbeans.updater.UpdateTracking;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class L10NUpdate
extends ModuleUpdate {
    private static final String ATTR_LONG_DESC = "OpenIDE-Module-Long-Description";
    private String langcode;
    private String brandingcode;
    private SpecificationVersion specversion;
    private int majorversion;
    private String l10nname;
    private String l10ndesc;
    private L10NModuleInfo remoteinfo;

    L10NUpdate(URL uRL, Node node, Element element) {
        super(uRL, node, element);
    }

    L10NUpdate(File file, Node node, Element element) {
        super(file, node, element);
    }

    ModuleInfo readRemoteInfo() throws IllegalArgumentException {
        NodeList nodeList = ((Element)this.getNode()).getElementsByTagName("l10n");
        if (nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            this.langcode = this.getAttribute(node, "langcode");
            this.brandingcode = this.getAttribute(node, "brandingcode");
            this.specversion = new SpecificationVersion(this.getAttribute(node, "module_spec_version"));
            String string = this.getAttribute(node, "module_major_version");
            this.majorversion = string != null ? Integer.parseInt(string) : -1;
            this.l10nname = this.getAttribute(node, "OpenIDE-Module-Name");
            this.l10ndesc = this.getAttribute(node, ATTR_LONG_DESC);
            if (this.getDescription() == null || this.getDescription().equals("")) {
                this.setDescription(this.l10ndesc);
            }
        }
        this.remoteinfo = new L10NModuleInfo();
        this.remoteinfo.setName(this.l10nname);
        this.remoteinfo.setCodeNameBase(this.getInfoCodenamebase());
        this.remoteinfo.setMajorversion(this.majorversion);
        this.remoteinfo.setSpecificationVersion(this.specversion);
        this.remoteinfo.setDependency(this.getInfoCodenamebase(), this.majorversion);
        return this.remoteinfo;
    }

    ModuleInfo readLocalInfo() {
        ModuleInfo moduleInfo = super.readLocalInfo();
        L10NModuleInfo l10NModuleInfo = null;
        if (moduleInfo != null) {
            SafeModule.ModuleStatus moduleStatus;
            if (this.l10nname == null || this.l10nname.equals("")) {
                this.remoteinfo.setName(moduleInfo.getDisplayName());
            }
            if (this.getDescription() == null || this.getDescription().equals("")) {
                this.setDescription((String)moduleInfo.getLocalizedAttribute(ATTR_LONG_DESC));
            }
            if ((moduleStatus = SafeModule.getModuleStatus(this.getInfoCodenamebase())) != null) {
                String string = moduleStatus.getJarPath() + "locale/" + moduleStatus.getJarName();
                if (this.brandingcode != null && this.brandingcode.length() > 0) {
                    string = string + "_" + this.brandingcode;
                }
                if (this.langcode != null && this.langcode.length() > 0) {
                    string = string + "_" + this.langcode;
                }
                string = string + ".jar";
                SpecificationVersion specificationVersion = this.getTrackingSpecVersion(string);
                l10NModuleInfo = new L10NModuleInfo();
                l10NModuleInfo.setName(this.remoteinfo.getDisplayName());
                l10NModuleInfo.setCodeNameBase(this.getInfoCodenamebase());
                if (specificationVersion != null) {
                    l10NModuleInfo.setSpecificationVersion(specificationVersion);
                }
            }
            this.markNamesWithL10N();
        }
        return l10NModuleInfo;
    }

    private void markNamesWithL10N() {
        String string;
        String string2 = "";
        if (this.langcode != null && this.langcode.length() > 0) {
            string = new Locale(this.langcode, "").getDisplayLanguage();
            string2 = NbBundle.getMessage(L10NUpdate.class, (String)"TXT_L10N_Prefix", (Object)string);
        }
        if (this.brandingcode != null && this.brandingcode.length() > 0) {
            if (this.langcode != null && this.langcode.length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + NbBundle.getMessage(L10NUpdate.class, (String)"TXT_L10N_Branding", (Object)this.brandingcode);
        }
        if (string2.length() > 0) {
            string2 = string2 + NbBundle.getMessage(L10NUpdate.class, (String)"TXT_L10N_DescEnd");
        }
        string2 = string2 + this.getDescription();
        this.setDescription(string2);
        if (this.l10nname == null || this.l10nname.equals("")) {
            string = this.remoteinfo.getDisplayName() + " (";
            if (this.langcode != null && this.langcode.length() > 0) {
                string = string + this.langcode;
            }
            if (this.brandingcode != null && this.brandingcode.length() > 0) {
                if (this.langcode != null && this.langcode.length() > 0) {
                    string = string + " ";
                }
                string = string + this.brandingcode;
            }
            string = string + ")";
            this.remoteinfo.setName(string);
        }
    }

    private SpecificationVersion getTrackingSpecVersion(String string) {
        for (File file : UpdateTracking.clusters(true)) {
            SpecificationVersion specificationVersion;
            UpdateTracking updateTracking = UpdateTracking.getTracking(file, false);
            if (updateTracking == null) continue;
            String string2 = updateTracking.getL10NSpecificationVersion(this.getInfoCodenamebase(), true, string);
            String string3 = updateTracking.getL10NSpecificationVersion(this.getInfoCodenamebase(), false, string);
            if (string2 == null && string3 == null) continue;
            SpecificationVersion specificationVersion2 = string2 != null ? new SpecificationVersion(string2) : null;
            SpecificationVersion specificationVersion3 = specificationVersion = string3 != null ? new SpecificationVersion(string3) : null;
            if (specificationVersion != null && specificationVersion2 == null) {
                return specificationVersion;
            }
            if (specificationVersion == null && specificationVersion2 != null) {
                return specificationVersion2;
            }
            if (specificationVersion.compareTo((Object)specificationVersion2) > 0) {
                return specificationVersion;
            }
            return specificationVersion2;
        }
        return null;
    }

    private String getAttribute(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        return node2 == null ? null : node2.getNodeValue();
    }

    String getLangcode() {
        return this.langcode;
    }

    String getBrandingcode() {
        return this.brandingcode;
    }

    int getMajorversion() {
        return this.majorversion;
    }

    String getL10nname() {
        return this.l10nname;
    }

    String getL10ndesc() {
        return this.l10ndesc;
    }

    boolean isUpdateAvailable() {
        return this.getLocalModule() != null && (this.getLocalModule().getSpecificationVersion() == null || this.getLocalModule().getSpecificationVersion().compareTo((Object)this.remoteinfo.getSpecificationVersion()) < 0);
    }

    boolean isRemoteModuleAvailable(List list) {
        for (ModuleUpdate moduleUpdate : list) {
            if (!moduleUpdate.getCodeNameBase().equals(this.remoteinfo.getCodeNameBase()) || moduleUpdate.getRemoteModule().getSpecificationVersion().compareTo((Object)this.remoteinfo.getSpecificationVersion()) > 0) continue;
            if (this.remoteinfo.getDisplayName() == null || this.remoteinfo.getDisplayName().equals("")) {
                this.remoteinfo.setName(moduleUpdate.getRemoteModule().getDisplayName());
            }
            if (this.getDescription() == null || this.getDescription().equals("")) {
                this.setDescription((String)moduleUpdate.getRemoteModule().getLocalizedAttribute(ATTR_LONG_DESC));
            }
            this.markNamesWithL10N();
            return true;
        }
        return false;
    }

    class L10NModuleInfo
    extends ModuleInfo {
        private SpecificationVersion specversion;
        private String name;
        private Set dep;
        private String codenamebase;
        private int majorversion;

        void setSpecificationVersion(SpecificationVersion specificationVersion) {
            this.specversion = specificationVersion;
        }

        void setName(String string) {
            this.name = string;
        }

        void setCodeNameBase(String string) {
            this.codenamebase = string;
        }

        void setMajorversion(int n) {
            this.majorversion = n;
        }

        void setDependency(String string, int n) {
            String string2 = string;
            if (n > 0) {
                string2 = string2 + "/" + n;
            }
            this.dep = Dependency.create((int)1, (String)string2);
        }

        public SpecificationVersion getSpecificationVersion() {
            return this.specversion;
        }

        public String getDisplayName() {
            return this.name;
        }

        public Object getAttribute(String string) {
            return null;
        }

        public String getCodeName() {
            return this.codenamebase + "/" + this.majorversion;
        }

        public String getCodeNameBase() {
            return this.codenamebase;
        }

        public int getCodeNameRelease() {
            return this.majorversion;
        }

        public Set getDependencies() {
            return this.dep;
        }

        public Object getLocalizedAttribute(String string) {
            return null;
        }

        public boolean isEnabled() {
            return false;
        }

        public boolean owns(Class clazz) {
            return false;
        }
    }
}

