/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.netbeans.modules.autoupdate.AutoupdateClusterCreator;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.DummyModuleInfo;
import org.netbeans.modules.autoupdate.IdeDescription;
import org.netbeans.modules.autoupdate.L10NUpdate;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.XMLAutoupdateType;
import org.netbeans.updater.UpdateTracking;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ModuleUpdate
implements Node.Cookie {
    private static final String ATTR_HOMEPAGE = "homepage";
    private static final String ATTR_DISTRIBUTION = "distribution";
    private static final String ATTR_CODENAMEBASE = "codenamebase";
    private static final String ATTR_DOWNLOAD_SIZE = "downloadsize";
    private static final String ATTR_UNPACKED_SIZE = "unpacksize";
    private static final String ATTR_LICENSE = "license";
    private static final String ATTR_LICENSE_MISSPELLED = "licence";
    private static final String ATTR_PURCHASED = "purchased";
    private static final String ATTR_NEEDSRESTART = "needsrestart";
    private static final String ATTR_AUTHOR = "moduleauthor";
    private static final String ATTR_RELEASE_DATE = "releasedate";
    private static final String ATTR_IS_GLOBAL = "global";
    private static final String ATTR_TARGET_CLUSTER = "targetcluster";
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_NOTIFICATION = "module_notification";
    private static final String ELEMENT_EXTERNAL = "external_package";
    static final String ELEMENT_L10N = "l10n";
    private static final String ATTR_EXT_NAME = "name";
    private static final String ATTR_EXT_TARGET = "target_name";
    private static final String ATTR_EXT_URL = "start_url";
    private static final String ATTR_EXT_DESC = "description";
    static final String NBM_LIB = "lib";
    static final String NBM_CORE = "core";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.autoupdate.ModuleUpdate");
    private URL xmlURL;
    private Node node;
    private Element documentElement;
    private File nbmFile;
    private URL distribution = null;
    private URL homepage = null;
    private String infoCodenamebase = null;
    private long downloadSize = -1L;
    private long unpackedSize = -1L;
    private boolean downloadOK = false;
    private String description = null;
    private String licenceID = null;
    private String licenceText = null;
    private boolean selected = false;
    private int security = -1;
    private Collection certs = null;
    private boolean installApproved = false;
    private ModuleInfo localModule = null;
    private ModuleInfo remoteModule = null;
    private boolean purchased = false;
    private String notification = null;
    private String moduleAuthor = null;
    private Date releaseDate = null;
    private boolean notificationAccepted = false;
    private String distributionFilename = null;
    private List externals;
    private boolean depending;
    private boolean toInstallDir;
    private boolean downloadStarted;
    private boolean safeToInstall;
    private Boolean isGlobal;
    private String targetCluster;
    private List jarList = new ArrayList();
    private File target;

    ModuleUpdate(URL uRL, Node node, Element element) {
        this.xmlURL = uRL;
        this.node = node;
        this.documentElement = element;
    }

    ModuleUpdate(File file, Node node, Element element) {
        this.nbmFile = file;
        this.node = node;
        this.documentElement = element;
    }

    static ModuleUpdate getModuleUpdate(URL uRL, Node node, Element element, AutoupdateType autoupdateType) {
        NodeList nodeList = ((Element)node).getElementsByTagName(ELEMENT_L10N);
        ModuleUpdate moduleUpdate = nodeList != null && nodeList.getLength() > 0 ? new L10NUpdate(uRL, node, element) : new ModuleUpdate(uRL, node, element);
        if (moduleUpdate.readModuleUpdate(autoupdateType)) {
            return moduleUpdate;
        }
        return null;
    }

    private static String getMessage(String string, String string2) {
        return NbBundle.getMessage(ModuleUpdate.class, (String)string, (Object)string2);
    }

    /*
     * Exception decompiling
     */
    static ModuleUpdate getModuleUpdate(File var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean readModuleUpdate(AutoupdateType autoupdateType) {
        Object object;
        try {
            object = this.getAttribute(ATTR_HOMEPAGE);
            if (object != null) {
                this.homepage = new URL(this.xmlURL, (String)object);
            }
        }
        catch (MalformedURLException malformedURLException) {
            LOG.log(Level.WARNING, null, malformedURLException);
        }
        this.setInfoCodenamebase(this.getAttribute(ATTR_CODENAMEBASE));
        try {
            this.setDownloadSize(Long.parseLong(this.getAttribute(ATTR_DOWNLOAD_SIZE)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.setUnpackedSize(Long.parseLong(this.getAttribute(ATTR_UNPACKED_SIZE)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setDescription(this.getTextOfElement("description"));
        this.setNotification(this.getTextOfElement(ELEMENT_NOTIFICATION));
        object = this.externalFromXML();
        if (object != null) {
            this.externals = object;
        }
        try {
            String string = this.getAttribute(ATTR_DISTRIBUTION);
            if (string != null) {
                String string2 = this.xmlURL.toString();
                int n = string2.indexOf(63);
                this.distribution = n > -1 && n < string2.lastIndexOf(47) ? new URL(new URL(string2.substring(0, n)), string) : new URL(this.xmlURL, string);
                if (autoupdateType instanceof XMLAutoupdateType) {
                    this.distribution = ((XMLAutoupdateType)autoupdateType).modifyURL(this.distribution);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            LOG.log(Level.WARNING, null, malformedURLException);
        }
        this.purchased = Boolean.valueOf(this.getAttribute(ATTR_PURCHASED));
        this.processNeedsRestart();
        this.processIsGlobal();
        this.processTargetCluster();
        this.readReleaseDate();
        this.readModuleAuthor();
        try {
            this.remoteModule = this.readRemoteInfo();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.log(Level.WARNING, null, illegalArgumentException);
        }
        this.licenceID = this.getAttribute(ATTR_LICENSE);
        if (this.licenceID == null) {
            this.licenceID = this.getAttribute(ATTR_LICENSE_MISSPELLED);
        }
        this.licenceText = this.licenseFromXML(this.licenceID, this.documentElement);
        this.localModule = this.readLocalInfo();
        return this.remoteModule != null;
    }

    ModuleInfo readRemoteInfo() throws IllegalArgumentException {
        String string;
        Manifest manifest = this.manifestFromXML();
        if ((this.description == null || this.description.equals("")) && (string = manifest.getMainAttributes().getValue("OpenIDE-Module-Long-Description")) != null) {
            this.description = string;
        }
        return new DummyModuleInfo(manifest.getMainAttributes());
    }

    ModuleInfo readLocalInfo() {
        ModuleInfo moduleInfo = null;
        ModuleInfo[] moduleInfoArray = Updates.getInstalledModules();
        ModuleInfo[] moduleInfoArray2 = Updates.getInstalledPatches();
        if (this.remoteModule != null) {
            int n;
            if (this.remoteModule.getCodeName().equals(IdeDescription.getName())) {
                moduleInfo = IdeDescription.getIdeDescription();
            }
            for (n = 0; this.localModule == null && n < moduleInfoArray.length; ++n) {
                if (!moduleInfoArray[n].getCodeNameBase().equals(this.remoteModule.getCodeNameBase())) continue;
                moduleInfo = moduleInfoArray[n];
                break;
            }
            for (n = 0; this.localModule == null && n < moduleInfoArray2.length; ++n) {
                if (!moduleInfoArray2[n].getCodeNameBase().equals(this.remoteModule.getCodeNameBase())) continue;
                moduleInfo = moduleInfoArray2[n];
                break;
            }
        }
        return moduleInfo;
    }

    private static ZipEntry getLocalizedInfo(JarFile jarFile) {
        String string = Locale.getDefault().getLanguage();
        ZipEntry zipEntry = jarFile.getEntry("Info/locale/info_" + string + ".xml");
        if (zipEntry == null) {
            zipEntry = jarFile.getEntry("Info/info.xml");
        }
        return zipEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createFromDistribution() {
        Object object;
        Document document = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(this.nbmFile);
            object = ModuleUpdate.getLocalizedInfo(jarFile);
            if (object == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ModuleUpdate.class, (String)"MSG_NoInfoXml", (Object)this.nbmFile.getName()), 0));
                boolean bl = false;
                return bl;
            }
            InputStream inputStream = jarFile.getInputStream((ZipEntry)object);
            InputSource inputSource = new InputSource(inputStream);
            document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, (ErrorHandler)new ErrorCatcher(), (EntityResolver)org.netbeans.updater.XMLUtil.createAUResolver());
            this.documentElement = document.getDocumentElement();
            this.node = this.documentElement;
        }
        catch (SAXException sAXException) {
            Exceptions.attachMessage((Throwable)sAXException, (String)("Bad info : " + this.nbmFile.getName()));
            LOG.log(Level.WARNING, null, sAXException);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            Exceptions.attachMessage((Throwable)iOException, (String)("Missing info : " + this.nbmFile.getName()));
            LOG.log(Level.WARNING, null, iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        try {
            object = this.getAttribute(ATTR_HOMEPAGE);
            if (object != null && ((String)object).length() > 0) {
                this.homepage = new URL((String)object);
            }
        }
        catch (MalformedURLException malformedURLException) {
            LOG.log(Level.WARNING, null, malformedURLException);
        }
        this.setInfoCodenamebase(this.getAttribute(ATTR_CODENAMEBASE));
        this.setDownloadSize(this.nbmFile.length());
        this.setDescription(this.getTextOfElement("description"));
        this.setNotification(this.getTextOfElement(ELEMENT_NOTIFICATION));
        object = this.externalFromXML();
        if (object != null) {
            this.externals = object;
        }
        this.purchased = Boolean.valueOf(this.getAttribute(ATTR_PURCHASED));
        this.processNeedsRestart();
        this.processIsGlobal();
        this.processTargetCluster();
        this.readReleaseDate();
        this.readModuleAuthor();
        try {
            this.remoteModule = this.readRemoteInfo();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.log(Level.WARNING, null, illegalArgumentException);
        }
        this.licenceID = this.getAttribute(ATTR_LICENSE);
        if (this.licenceID == null) {
            this.licenceID = this.getAttribute(ATTR_LICENSE_MISSPELLED);
        }
        this.licenceText = this.licenseFromXML(this.licenceID, this.documentElement);
        this.localModule = this.readLocalInfo();
        return this.remoteModule != null;
    }

    void resolveInstalledModule(Collection collection) {
    }

    private void readReleaseDate() {
        String string = this.getAttribute(ATTR_RELEASE_DATE);
        if (string != null) {
            try {
                this.setReleaseDate(DATE_FORMAT.parse(string));
            }
            catch (ParseException parseException) {
                LOG.log(Level.WARNING, null, parseException);
            }
        }
    }

    private void readModuleAuthor() {
        this.setModuleAuthor(this.getAttribute(ATTR_AUTHOR));
    }

    private void processNeedsRestart() {
        String string = this.getAttribute(ATTR_NEEDSRESTART);
        if (string != null && Boolean.FALSE.toString().equals(string.toLowerCase())) {
            this.setSafeToInstall(true);
        }
    }

    private void processIsGlobal() {
        String string = this.getAttribute(ATTR_IS_GLOBAL);
        if (string != null) {
            if (Boolean.TRUE.toString().equals(string.toLowerCase())) {
                this.isGlobal = Boolean.TRUE;
            } else if (Boolean.FALSE.toString().equals(string.toLowerCase())) {
                this.isGlobal = Boolean.FALSE;
            }
        }
    }

    private void processTargetCluster() {
        String string = this.getAttribute(ATTR_TARGET_CLUSTER);
        if (string != null) {
            Object object2;
            Pattern pattern = Pattern.compile(string);
            for (Object object2 : UpdateTracking.clusters(false)) {
                if (!pattern.matcher(((File)object2).getName()).matches()) continue;
                this.targetCluster = ((File)object2).getName();
                return;
            }
            object2 = Lookup.getDefault().lookupAll(AutoupdateClusterCreator.class).iterator();
            while (object2.hasNext() && this.targetCluster == null) {
                AutoupdateClusterCreator autoupdateClusterCreator = (AutoupdateClusterCreator)object2.next();
                File file = autoupdateClusterCreator.findCluster(string);
                if (file == null) continue;
                this.targetCluster = file.getName();
                return;
            }
        }
    }

    String getCodeNameBase() {
        return this.remoteModule.getCodeNameBase();
    }

    String getName() {
        return this.remoteModule.getDisplayName();
    }

    URL getDistribution() {
        return this.distribution;
    }

    void setRemoteDistributionFilename(URLConnection uRLConnection) {
        if (this.distributionFilename == null) {
            String string = uRLConnection.getURL().getFile();
            int n = string.indexOf(63);
            if (n > 0) {
                string = string.substring(0, n);
            }
            if ((n = string.lastIndexOf(47)) > 0 && n < string.length() - 1) {
                string = string.substring(n + 1);
            }
            this.distributionFilename = string;
        }
    }

    String getDistributionFilename() {
        if (this.distributionFilename == null) {
            if (this.nbmFile != null) {
                this.distributionFilename = this.nbmFile.getName();
            } else {
                try {
                    URLConnection uRLConnection = this.getDistribution().openConnection();
                    this.setRemoteDistributionFilename(uRLConnection);
                }
                catch (IOException iOException) {
                    this.distributionFilename = new File(this.getDistribution().getFile()).getName();
                }
            }
        }
        return this.distributionFilename;
    }

    String getLicenceID() {
        return this.licenceID;
    }

    public String getInfoCodenamebase() {
        return this.infoCodenamebase;
    }

    void setInfoCodenamebase(String string) {
        this.infoCodenamebase = string;
    }

    long getDownloadSize() {
        return this.downloadSize;
    }

    void setDownloadSize(long l) {
        this.downloadSize = l;
    }

    long getUnpackedSize() {
        return this.unpackedSize;
    }

    void setUnpackedSize(long l) {
        this.unpackedSize = l;
    }

    String getDescription() {
        return this.description;
    }

    void setDescription(String string) {
        this.description = string;
    }

    String getModuleAuthor() {
        return this.moduleAuthor;
    }

    void setModuleAuthor(String string) {
        this.moduleAuthor = string;
    }

    Date getReleaseDate() {
        return this.releaseDate;
    }

    void setReleaseDate(Date date) {
        this.releaseDate = date;
    }

    String getNotification() {
        return this.notification;
    }

    void setNotification(String string) {
        this.notification = string;
    }

    boolean getNotificationAccepted() {
        return this.notificationAccepted;
    }

    void setNotificationAccepted(boolean bl) {
        this.notificationAccepted = bl;
    }

    boolean isSelected() {
        return this.selected;
    }

    void setSelected(boolean bl) {
        this.selected = bl;
    }

    boolean isNew() {
        return this.localModule == null;
    }

    boolean isPurchased() {
        return this.purchased;
    }

    URL getHomePage() {
        return this.homepage;
    }

    String getLicenceText() {
        return this.licenceText;
    }

    ModuleInfo getRemoteModule() {
        return this.remoteModule;
    }

    ModuleInfo getLocalModule() {
        return this.localModule;
    }

    Node getNode() {
        return this.node;
    }

    boolean isUpdateAvailable() {
        if (this.getLocalModule() == null) {
            return true;
        }
        if (this.getRemoteModule().getCodeNameRelease() > this.getLocalModule().getCodeNameRelease()) {
            return true;
        }
        if (this.getLocalModule().getSpecificationVersion() == null) {
            return true;
        }
        if (this.getRemoteModule().getSpecificationVersion() == null) {
            return false;
        }
        return this.getLocalModule().getSpecificationVersion().compareTo((Object)this.getRemoteModule().getSpecificationVersion()) < 0;
    }

    boolean isNotChecked() {
        return this.security == -1;
    }

    boolean isDownloadOK() {
        return this.downloadOK;
    }

    void setDownloadOK(boolean bl) {
        this.downloadOK = bl;
    }

    int getSecurity() {
        return this.security;
    }

    void setSecurity(int n) {
        this.security = n;
    }

    Collection getCerts() {
        return this.certs;
    }

    void setCerts(Collection collection) {
        this.certs = collection;
    }

    File getDistributionFile() {
        return this.nbmFile;
    }

    boolean isInstallApproved() {
        return this.installApproved;
    }

    void setInstallApproved(boolean bl) {
        this.installApproved = bl;
    }

    private String getAttribute(String string) {
        Node node = this.node.getAttributes().getNamedItem(string);
        return node == null ? null : node.getNodeValue();
    }

    private String getTextOfElement(String string) {
        if (this.node.getNodeType() != 1 || !(this.node instanceof Element)) {
            return null;
        }
        NodeList nodeList = ((Element)this.node).getElementsByTagName(string);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nodeList.getLength() && nodeList.item(i).getNodeType() == 1 && nodeList.item(i) instanceof Element; ++i) {
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                short s = nodeList2.item(j).getNodeType();
                if (s != 3 && s != 4) continue;
                stringBuffer.append(nodeList2.item(j).getNodeValue());
            }
        }
        return stringBuffer.toString();
    }

    private List externalFromXML() {
        if (this.node.getNodeType() != 1 || !(this.node instanceof Element)) {
            return null;
        }
        ArrayList<External> arrayList = null;
        NodeList nodeList = ((Element)this.node).getElementsByTagName(ELEMENT_EXTERNAL);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (i == 0) {
                arrayList = new ArrayList<External>();
            }
            if (nodeList.item(i).getNodeType() != 1 || !(nodeList.item(i) instanceof Element)) break;
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            External external = new External();
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Attr attr = (Attr)namedNodeMap.item(j);
                if (attr.getName().equals(ATTR_EXT_NAME)) {
                    external.setName(attr.getValue());
                    continue;
                }
                if (attr.getName().equals(ATTR_EXT_TARGET)) {
                    external.setTarget_name(attr.getValue());
                    continue;
                }
                if (attr.getName().equals(ATTR_EXT_URL)) {
                    external.setStart_url(attr.getValue());
                    continue;
                }
                if (!attr.getName().equals("description")) continue;
                external.setDescription(attr.getValue());
            }
            arrayList.add(external);
        }
        return arrayList;
    }

    private Manifest manifestFromXML() {
        if (this.node.getNodeType() != 1 || !(this.node instanceof Element)) {
            return null;
        }
        int n = 0;
        NodeList nodeList = ((Element)this.node).getElementsByTagName("manifest");
        if (n < nodeList.getLength() && nodeList.item(n).getNodeType() == 1 && nodeList.item(n) instanceof Element) {
            NamedNodeMap namedNodeMap = nodeList.item(n).getAttributes();
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                attributes.put(new Attributes.Name(attr.getName()), attr.getValue());
            }
            return manifest;
        }
        return null;
    }

    private String licenseFromXML(String string, Element element) {
        NodeList nodeList = element.getElementsByTagName(ATTR_LICENSE);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i).getAttributes().getNamedItem(ATTR_EXT_NAME);
            if (node == null || !node.getNodeValue().equals(string)) continue;
            StringBuffer stringBuffer = new StringBuffer();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                short s = nodeList2.item(j).getNodeType();
                if (s != 3 && s != 4) continue;
                stringBuffer.append(nodeList2.item(j).getNodeValue());
            }
            return stringBuffer.toString();
        }
        if (string != null) {
            Logger.getAnonymousLogger().log(Level.WARNING, "[AutoUpdate] warning: no license found with name " + string);
        }
        return null;
    }

    List getExternals() {
        return this.externals;
    }

    public boolean isForcedGlobal() {
        return this.depending || !this.isAbleToInstallToUserDir();
    }

    public void setDepending(boolean bl) {
        this.depending = bl;
    }

    public boolean isToInstallDir() {
        if (this.isForcedGlobal()) {
            return true;
        }
        if (this.isGlobal() != null) {
            return this.isGlobal();
        }
        return this.toInstallDir;
    }

    public void setToInstallDir(boolean bl) throws IllegalArgumentException {
        if (this.isGlobal() != null && bl != this.isGlobal()) {
            throw new IllegalArgumentException("Cannot setToInstallDir (" + bl + ") when isGlobal is set to " + this.isGlobal());
        }
        if (this.isForcedGlobal() && !bl) {
            throw new IllegalArgumentException("Cannot setToInstallDir (" + bl + ") when isForderGlobal is " + this.isForcedGlobal());
        }
        this.toInstallDir = bl;
    }

    public boolean isDownloadStarted() {
        return this.downloadStarted;
    }

    public void setDownloadStarted(boolean bl) {
        this.downloadStarted = bl;
    }

    boolean isSafeToInstall() {
        return this.safeToInstall && this.isNew() && !this.isForcedGlobal();
    }

    void setSafeToInstall(boolean bl) {
        this.safeToInstall = bl;
    }

    Boolean isGlobal() {
        return this.isGlobal;
    }

    String getTargetCluster() {
        return this.targetCluster;
    }

    List getJarList() {
        return this.jarList;
    }

    void setJarList(List list) {
        this.jarList = list;
    }

    void addToJarList(String string) {
        this.jarList.add(string);
    }

    final File findInstallDirectory() {
        if (this.target == null) {
            Object object;
            File file = null;
            Object object2 = null;
            Object object3 = null;
            for (Object object4 : UpdateTracking.clusters(false)) {
                if (!(file != null || ((File)object4).isDirectory() && UpdateTracking.getTracking((File)object4, false) == null)) {
                    file = object4;
                }
                if (((File)object4).getName().equals(this.getTargetCluster())) {
                    object2 = object4;
                }
                if ((object = UpdateTracking.getTracking((File)object4, false)) == null || !((UpdateTracking)object).isModuleInstalled(this.getInfoCodenamebase())) continue;
                assert (object2 == null || ((File)object4).equals(object2)) : "Update's target cluster must be placed into as same cluster as original module.";
                object3 = object4;
                break;
            }
            if (object3 != null) {
                this.target = object3;
            } else {
                if (object2 != null) {
                    this.target = object2;
                }
                if (this.getTargetCluster() != null) {
                    Object object4;
                    object4 = Lookup.getDefault().lookupAll(AutoupdateClusterCreator.class).iterator();
                    while (object4.hasNext() && this.target == null) {
                        object = (AutoupdateClusterCreator)object4.next();
                        this.target = ((AutoupdateClusterCreator)object).findCluster(this.getTargetCluster());
                    }
                }
                if (this.target == null) {
                    this.target = file;
                }
                if (this.target != null && !this.target.exists()) {
                    new File(this.target, "update_tracking").mkdirs();
                }
            }
        }
        return this.target;
    }

    final boolean isAbleToInstallToUserDir() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.nbmFile == null) {
            hashSet.addAll(this.jarList);
        } else {
            try {
                JarFile jarFile = new JarFile(this.nbmFile);
                Object object = jarFile.entries();
                while (object.hasMoreElements()) {
                    JarEntry jarEntry = object.nextElement();
                    String string = jarEntry.getName();
                    if (string.startsWith("netbeans/")) {
                        string = string.substring(9);
                    }
                    hashSet.add(string);
                }
            }
            catch (IOException iOException) {
                assert (false) : "IOException caught: " + iOException.getMessage();
                return false;
            }
        }
        for (Object object : UpdateTracking.clusters(false)) {
            for (String string : hashSet) {
                File file;
                if (!string.startsWith("core/") && !string.startsWith("lib/") || (file = new File((File)object, string)).isDirectory() || !file.exists()) continue;
                return false;
            }
        }
        return true;
    }

    static class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String string, SAXParseException sAXParseException) {
        }

        public void error(SAXParseException sAXParseException) {
        }

        public void warning(SAXParseException sAXParseException) {
            LOG.log(Level.WARNING, null, sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) {
        }
    }

    class External {
        private String name;
        private String target_name;
        private String start_url;
        private String description;

        External() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getTarget_name() {
            return this.target_name;
        }

        public void setTarget_name(String string) {
            this.target_name = string;
        }

        public String getStart_url() {
            return this.start_url;
        }

        public void setStart_url(String string) {
            this.start_url = string;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }
    }
}

